/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.tree;

import java.util.HashSet;
import java.util.Objects;
import java.util.Random;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import org.bukkit.Material;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.terraform.coregen.HeightMap;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.TerraformWorld;
import org.terraform.main.config.TConfig;
import org.terraform.tree.FractalLeaves;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;
import org.terraform.utils.noise.FastNoise;
import org.terraform.utils.noise.NoiseCacheHandler;
import org.terraform.utils.version.BeeHiveSpawner;

public class NewFractalTreeBuilder
implements Cloneable {
    private static final int[][] rotationMatrixX = new int[][]{{1, 0, 0}, {0, 0, -1}, {0, 1, 0}};
    private static final int[][] rotationMatrixZ = new int[][]{{0, -1, 0}, {1, 0, 0}, {0, 0, 1}};
    final int maxHeight = 9999;
    private final Vector initialNormal = new Vector(0, 1, 0);
    private final double displacementThetaDelta = Math.PI * 2;
    private int maxDepth = 3;
    private int originalTrunkLength = 20;
    private float lengthVariance = 4.0f;
    private float firstEnd = 0.8f;
    private int crownBranches = 4;
    private float initialBranchRadius = 3.0f;
    private double branchSpawnChance = 0.08f;
    private float minBranchSpawnLength = 0.4f;
    private int randomBranchSegmentCount = 3;
    private float randomBranchSpawnCooldown = 0.0f;
    private int randomBranchClusterCount = 1;
    private double maxInitialNormalDelta = 0.3;
    private double minInitialNormalDelta = -0.3;
    private double minBranchHorizontalComponent = 0.5;
    private double maxBranchHorizontalComponent = 1.3;
    private int treeRootThreshold = 2;
    private float treeRootMultiplier = 1.5f;
    private float noisePriority = 0.1f;
    private int leafSpawnDepth = 1;
    private FractalLeaves fractalLeaves;
    private BiConsumer<Random, SimpleBlock> prePlacement = null;
    private BiFunction<Float, Float, Float> branchDecrement = (currentBranchLength, totalTreeHeight) -> Float.valueOf(currentBranchLength.floatValue() * 0.7f);
    private BiFunction<Float, Float, Float> getBranchWidth = (initialBranchWidth, branchRatio) -> Float.valueOf(initialBranchWidth.floatValue() * (1.0f - branchRatio.floatValue() / 2.0f));
    private Material branchMaterial = Material.OAK_LOG;
    private Material rootMaterial = Material.OAK_WOOD;
    private boolean spawnBees = false;
    private boolean checkGradient = true;

    public boolean build(@NotNull TerraformWorld tw, @NotNull SimpleBlock base) {
        if (!TConfig.areTreesEnabled()) {
            return false;
        }
        if (!this.checkGradient(base.getPopData(), base.getX(), base.getZ())) {
            return false;
        }
        int oriY = base.getY();
        Random random = tw.getHashedRand(base.getX(), base.getY(), base.getZ());
        if (this.prePlacement != null) {
            this.prePlacement.accept(random, base);
        }
        double displacementTheta = GenUtils.randDouble(random, 0.0, Math.PI * 2);
        HashSet<SimpleBlock> prospectiveHives = new HashSet<SimpleBlock>();
        double currentBranchTheta = GenUtils.randInt(random, 0, this.randomBranchSegmentCount);
        this.fractalLeaves.purgeOccupiedLeavesCache();
        this.branch(tw, random, base, this.initialNormal.clone().add(new Vector(GenUtils.randDouble(random, this.minInitialNormalDelta, this.maxInitialNormalDelta), 0.0, GenUtils.randDouble(random, this.minInitialNormalDelta, this.maxInitialNormalDelta))).normalize(), prospectiveHives, currentBranchTheta, oriY, displacementTheta, (float)this.originalTrunkLength + (float)GenUtils.randDouble(random, -this.lengthVariance, this.lengthVariance), this.firstEnd, 0, this.initialBranchRadius, 0.0f);
        if (this.spawnBees) {
            for (SimpleBlock b2 : prospectiveHives) {
                if (b2.isSolid()) continue;
                BeeHiveSpawner.spawnFullBeeNest(b2);
                break;
            }
        }
        this.fractalLeaves.setSnowy(false);
        return true;
    }

    boolean checkGradient(PopulatorDataAbstract data, int x, int z) {
        return !this.checkGradient || HeightMap.getTrueHeightGradient(data, x, z, 3) <= TConfig.c.MISC_TREES_GRADIENT_LIMIT;
    }

    @NotNull
    public NewFractalTreeBuilder setCheckGradient(boolean checkGradient) {
        this.checkGradient = checkGradient;
        return this;
    }

    void branch(TerraformWorld tw, @NotNull Random random, @NotNull SimpleBlock base, @NotNull Vector normal, @NotNull HashSet<SimpleBlock> prospectiveHives, double currentBranchTheta, int oriY, double displacementTheta, float length, float end, int depth, float currentWidth, float startingBranchIndex) {
        boolean spawnedNewBranch = false;
        SimpleBlock lastOperatedCentre = base;
        if (length > 0.0f && depth < this.maxDepth) {
            float initialWidth = currentWidth;
            FastNoise noiseGen = NoiseCacheHandler.getNoise(tw, NoiseCacheHandler.NoiseCacheEntry.FRACTALTREES_BASE_NOISE, world -> {
                FastNoise n = new FastNoise((int)world.getSeed());
                n.SetNoiseType(FastNoise.NoiseType.SimplexFractal);
                n.SetFractalOctaves(5);
                n.SetFrequency(0.05f);
                return n;
            });
            Vector branchVect = normal.clone().multiply(length);
            float randomBranchSpawnCooldownCurrent = 0.0f;
            for (float i = 0.0f; i < length - startingBranchIndex && !(i / length > end); i += 0.5f) {
                float appliedWidth = currentWidth;
                float appliedNoisePriority = this.noisePriority;
                Vector appliedNormal = normal;
                Material temp = this.branchMaterial;
                if (depth == 0 && i < (float)this.treeRootThreshold) {
                    appliedWidth *= (float)((double)this.treeRootMultiplier + (1.0 - (double)this.treeRootMultiplier) / (double)this.treeRootThreshold * (double)i);
                    appliedNoisePriority = (float)(0.7 + ((double)this.noisePriority - 0.4) / (double)this.treeRootThreshold * (double)i);
                    appliedNormal = new Vector(0, 1, 0);
                    this.branchMaterial = this.rootMaterial;
                }
                lastOperatedCentre = this.generateRotatedCircle(random, oriY, lastOperatedCentre.getPopData(), branchVect.clone().multiply(i / length).add(base.toVector()), appliedNormal, prospectiveHives, appliedNoisePriority, appliedWidth, noiseGen, i);
                this.branchMaterial = temp;
                currentWidth = this.getBranchWidth.apply(Float.valueOf(initialWidth), Float.valueOf(i / length)).floatValue();
                randomBranchSpawnCooldownCurrent -= 0.5f;
                if (!(i / length > this.minBranchSpawnLength) || !GenUtils.chance(random, (int)(100.0 * this.branchSpawnChance), 100) || !(randomBranchSpawnCooldownCurrent <= 0.0f)) continue;
                randomBranchSpawnCooldownCurrent = this.randomBranchSpawnCooldown;
                spawnedNewBranch = true;
                double effectiveDisplacementTheta = displacementTheta;
                if (this.randomBranchClusterCount > 0) {
                    displacementTheta = GenUtils.randDouble(random, 0.0, Math.PI * 2);
                }
                for (int y = 0; y < this.randomBranchClusterCount; ++y) {
                    this.branch(tw, random, lastOperatedCentre, this.calculateNextProjection(random, normal, this.getNextTheta(currentBranchTheta += 1.0, this.randomBranchSegmentCount, effectiveDisplacementTheta)), prospectiveHives, currentBranchTheta, oriY, displacementTheta, this.branchDecrement.apply(Float.valueOf(length), Float.valueOf(lastOperatedCentre.getY() - oriY)).floatValue(), 1.0f, depth + 1, currentWidth, 0.0f);
                }
            }
            if (depth == 0 && this.crownBranches > 0) {
                double thetaDelta = Math.PI * 2 / (double)this.crownBranches;
                for (int i = 0; i < this.crownBranches; ++i) {
                    spawnedNewBranch = true;
                    this.branch(tw, random, lastOperatedCentre, this.calculateNextProjection(random, normal, thetaDelta * (double)i), prospectiveHives, currentBranchTheta, oriY, displacementTheta, this.branchDecrement.apply(Float.valueOf(length), Float.valueOf(lastOperatedCentre.getY() - oriY)).floatValue(), 1.0f, depth + 1, currentWidth, 0.0f);
                }
            }
        }
        if (length <= 0.0f || !spawnedNewBranch || depth >= this.leafSpawnDepth) {
            this.fractalLeaves.placeLeaves(tw, oriY, 9999, lastOperatedCentre);
        }
    }

    double getNextTheta(double currentBranchTheta, int numSegments, double displacementTheta) {
        double thetaDelta = Math.PI * 2 / (double)numSegments;
        return displacementTheta + currentBranchTheta * thetaDelta;
    }

    @NotNull
    Vector calculateNextProjection(@NotNull Random random, @NotNull Vector normal, double theta) {
        Vector A = normal.clone();
        A.setX((double)rotationMatrixX[0][0] * normal.getX() + (double)rotationMatrixX[0][1] * normal.getY() + (double)rotationMatrixX[0][2] * normal.getZ());
        A.setY((double)rotationMatrixX[1][0] * normal.getX() + (double)rotationMatrixX[1][1] * normal.getY() + (double)rotationMatrixX[1][2] * normal.getZ());
        A.setZ((double)rotationMatrixX[2][0] * normal.getX() + (double)rotationMatrixX[2][1] * normal.getY() + (double)rotationMatrixX[2][2] * normal.getZ());
        double x = A.getX();
        double y = A.getY();
        double z = A.getZ();
        double u = normal.getX();
        double v = normal.getY();
        double w = normal.getZ();
        double AdotNormal = A.dot(normal);
        double xPrime = u * AdotNormal * (1.0 - Math.cos(theta)) + x * Math.cos(theta) + (-w * y + v * z) * Math.sin(theta);
        double yPrime = v * AdotNormal * (1.0 - Math.cos(theta)) + y * Math.cos(theta) + (w * x - u * z) * Math.sin(theta);
        double zPrime = w * AdotNormal * (1.0 - Math.cos(theta)) + z * Math.cos(theta) + (-v * x + u * y) * Math.sin(theta);
        A = new Vector(xPrime, yPrime, zPrime);
        return normal.clone().add(A.multiply(GenUtils.randDouble(random, this.minBranchHorizontalComponent, this.maxBranchHorizontalComponent))).normalize();
    }

    @NotNull
    SimpleBlock generateRotatedCircle(@NotNull Random random, int oriY, @NotNull PopulatorDataAbstract data, @NotNull Vector centre, @NotNull Vector normal, @NotNull HashSet<SimpleBlock> prospectiveHives, float noisePriority, float radius, @NotNull FastNoise noiseGen, float heightIndex) {
        if (radius <= 0.5f) {
            data.rsetType(centre, BlockUtils.replacableByTrees, this.branchMaterial);
            return new SimpleBlock(data, centre);
        }
        Vector A = normal.clone();
        Vector B = normal.clone();
        A.setX((double)rotationMatrixX[0][0] * normal.getX() + (double)rotationMatrixX[0][1] * normal.getY() + (double)rotationMatrixX[0][2] * normal.getZ());
        A.setY((double)rotationMatrixX[1][0] * normal.getX() + (double)rotationMatrixX[1][1] * normal.getY() + (double)rotationMatrixX[1][2] * normal.getZ());
        A.setZ((double)rotationMatrixX[2][0] * normal.getX() + (double)rotationMatrixX[2][1] * normal.getY() + (double)rotationMatrixX[2][2] * normal.getZ());
        B.setX((double)rotationMatrixZ[0][0] * normal.getX() + (double)rotationMatrixZ[0][1] * normal.getY() + (double)rotationMatrixZ[0][2] * normal.getZ());
        B.setY((double)rotationMatrixZ[1][0] * normal.getX() + (double)rotationMatrixZ[1][1] * normal.getY() + (double)rotationMatrixZ[1][2] * normal.getZ());
        B.setZ((double)rotationMatrixZ[2][0] * normal.getX() + (double)rotationMatrixZ[2][1] * normal.getY() + (double)rotationMatrixZ[2][2] * normal.getZ());
        boolean didNotGenerate = true;
        double maxPossibleRadius = (1.0f + noisePriority * 2.0f) * radius;
        for (double rA = -maxPossibleRadius; rA <= maxPossibleRadius; rA += 1.0) {
            for (double rB = -maxPossibleRadius; rB <= maxPossibleRadius; rB += 1.0) {
                double newRadius;
                double distFromCentre = Math.sqrt(Math.pow(rA, 2.0) + Math.pow(rB, 2.0));
                double theta = Math.atan2(rB, rA);
                if (theta < 0.0) {
                    theta = Math.PI * 2 - theta;
                }
                if (!(distFromCentre <= (newRadius = noisePriority > 0.0f ? (double)(radius + noisePriority * radius * noiseGen.GetNoise(Objects.hash(centre.getX(), centre.getZ()), (float)theta, heightIndex)) : (double)radius))) continue;
                data.rsetType(centre.clone().add(A.clone().multiply(rA)).add(B.clone().multiply(rB)), BlockUtils.replacableByTrees, this.branchMaterial);
                didNotGenerate = false;
                if (!this.spawnBees || !(centre.getY() > (double)((float)oriY + (float)this.originalTrunkLength / 2.0f)) || !GenUtils.chance(random, 1, 200)) continue;
                prospectiveHives.add(new SimpleBlock(data, centre.clone().add(A.clone().multiply(rA)).add(B.clone().multiply(rB)).add(new Vector(0, -1, 0))));
            }
        }
        if (didNotGenerate) {
            data.rsetType(centre, BlockUtils.replacableByTrees, this.branchMaterial);
        }
        return new SimpleBlock(data, centre);
    }

    @NotNull
    NewFractalTreeBuilder setMaxDepth(int maxDepth) {
        this.maxDepth = maxDepth;
        return this;
    }

    @NotNull
    NewFractalTreeBuilder setOriginalTrunkLength(int originalTrunkLength) {
        this.originalTrunkLength = originalTrunkLength;
        return this;
    }

    @NotNull
    NewFractalTreeBuilder setFirstEnd(float firstEnd) {
        this.firstEnd = firstEnd;
        return this;
    }

    @NotNull
    NewFractalTreeBuilder setCrownBranches(int crownBranches) {
        this.crownBranches = crownBranches;
        return this;
    }

    @NotNull
    NewFractalTreeBuilder setInitialBranchRadius(float initialBranchRadius) {
        this.initialBranchRadius = initialBranchRadius;
        return this;
    }

    @NotNull
    NewFractalTreeBuilder setBranchSpawnChance(double branchSpawnChance) {
        this.branchSpawnChance = branchSpawnChance;
        return this;
    }

    @NotNull
    NewFractalTreeBuilder setMinBranchSpawnLength(float minBranchSpawnLength) {
        this.minBranchSpawnLength = minBranchSpawnLength;
        return this;
    }

    @NotNull
    NewFractalTreeBuilder setTreeRootThreshold(int treeRootThreshold) {
        this.treeRootThreshold = treeRootThreshold;
        return this;
    }

    @NotNull
    NewFractalTreeBuilder setRandomBranchClusterCount(int randomBranchClusterCount) {
        this.randomBranchClusterCount = randomBranchClusterCount;
        return this;
    }

    @NotNull
    NewFractalTreeBuilder setRandomBranchSegmentCount(int randomBranchSegmentCount) {
        this.randomBranchSegmentCount = randomBranchSegmentCount;
        return this;
    }

    @NotNull
    NewFractalTreeBuilder setMaxInitialNormalDelta(double maxInitialNormalDelta) {
        this.maxInitialNormalDelta = maxInitialNormalDelta;
        return this;
    }

    @NotNull
    NewFractalTreeBuilder setRandomBranchSpawnCooldown(float randomBranchSpawnCooldown) {
        this.randomBranchSpawnCooldown = randomBranchSpawnCooldown;
        return this;
    }

    @NotNull
    NewFractalTreeBuilder setTreeRootMultiplier(float treeRootMultiplier) {
        this.treeRootMultiplier = treeRootMultiplier;
        return this;
    }

    @NotNull
    NewFractalTreeBuilder setLeafSpawnDepth(int leafSpawnDepth) {
        this.leafSpawnDepth = leafSpawnDepth;
        return this;
    }

    @NotNull
    NewFractalTreeBuilder setMinBranchHorizontalComponent(double minBranchHorizontalComponent) {
        this.minBranchHorizontalComponent = minBranchHorizontalComponent;
        return this;
    }

    @NotNull
    NewFractalTreeBuilder setMaxBranchHorizontalComponent(double maxBranchHorizontalComponent) {
        this.maxBranchHorizontalComponent = maxBranchHorizontalComponent;
        return this;
    }

    @NotNull
    NewFractalTreeBuilder setBranchDecrement(BiFunction<Float, Float, Float> branchDecrement) {
        this.branchDecrement = branchDecrement;
        return this;
    }

    @NotNull
    NewFractalTreeBuilder setGetBranchWidth(BiFunction<Float, Float, Float> getBranchWidth) {
        this.getBranchWidth = getBranchWidth;
        return this;
    }

    @NotNull
    NewFractalTreeBuilder setPrePlacement(BiConsumer<Random, SimpleBlock> func) {
        this.prePlacement = func;
        return this;
    }

    @NotNull
    NewFractalTreeBuilder setSpawnBees(boolean spawnBees) {
        this.spawnBees = spawnBees;
        return this;
    }

    @NotNull
    NewFractalTreeBuilder setLengthVariance(float lengthVariance) {
        this.lengthVariance = lengthVariance;
        return this;
    }

    @NotNull
    public NewFractalTreeBuilder setBranchMaterial(Material branchMaterial) {
        this.branchMaterial = branchMaterial;
        return this;
    }

    @NotNull
    public NewFractalTreeBuilder setRootMaterial(Material rootMaterial) {
        this.rootMaterial = rootMaterial;
        return this;
    }

    @NotNull
    NewFractalTreeBuilder setNoisePriority(float noisePriority) {
        this.noisePriority = noisePriority;
        return this;
    }

    @NotNull
    NewFractalTreeBuilder setMinInitialNormalDelta(double minInitialNormalDelta) {
        this.minInitialNormalDelta = minInitialNormalDelta;
        return this;
    }

    public FractalLeaves getFractalLeaves() {
        return this.fractalLeaves;
    }

    @NotNull
    NewFractalTreeBuilder setFractalLeaves(FractalLeaves fractalLeaves) {
        this.fractalLeaves = fractalLeaves;
        return this;
    }

    @NotNull
    protected Object clone() throws CloneNotSupportedException {
        NewFractalTreeBuilder cl = (NewFractalTreeBuilder)super.clone();
        cl.setFractalLeaves(this.fractalLeaves.clone());
        return cl;
    }
}

