/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.jetbrains.annotations.NotNull;
import org.terraform.data.SimpleBlock;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;
import org.terraform.utils.noise.FastNoise;

public class BoxBuilder {
    private final Random random;
    private final int seed;
    private final SimpleBlock core;
    @NotNull
    private final Collection<Material> replaceWhitelist = new ArrayList<Material>();
    private float rX = 1.0f;
    private float rY = 1.0f;
    private float rZ = 1.0f;
    private boolean hardReplace = false;
    private Material[] types;
    private Material[] upperType;
    private Material[] lowerType;
    private int staticWaterLevel = -9999;
    private BoxType boxType = BoxType.FULL_BOX;

    public BoxBuilder(@NotNull Random random, SimpleBlock core, Material ... types) {
        this.random = random;
        this.seed = random.nextInt(99999999);
        this.types = types;
        this.core = core;
    }

    @NotNull
    public BoxBuilder setBoxType(BoxType sphereType) {
        this.boxType = sphereType;
        return this;
    }

    @NotNull
    public BoxBuilder setUpperType(Material ... upperType) {
        this.upperType = upperType;
        return this;
    }

    @NotNull
    public BoxBuilder setLowerType(Material ... lowerType) {
        this.lowerType = lowerType;
        return this;
    }

    @NotNull
    public BoxBuilder setStaticWaterLevel(int staticWaterLevel) {
        this.staticWaterLevel = staticWaterLevel;
        return this;
    }

    @NotNull
    public BoxBuilder addToWhitelist(Material ... mats) {
        this.replaceWhitelist.addAll(Arrays.asList(mats));
        return this;
    }

    @NotNull
    public BoxBuilder setRadius(float radius) {
        this.rX = radius;
        this.rY = radius;
        this.rZ = radius;
        return this;
    }

    @NotNull
    public BoxBuilder setRX(float rX) {
        this.rX = rX;
        return this;
    }

    @NotNull
    public BoxBuilder setRZ(float rZ) {
        this.rZ = rZ;
        return this;
    }

    @NotNull
    public BoxBuilder setRY(float rY) {
        this.rY = rY;
        return this;
    }

    @NotNull
    public BoxBuilder setSnowy() {
        this.upperType = new Material[]{Material.SNOW};
        return this;
    }

    @NotNull
    public BoxBuilder setHardReplace(boolean hardReplace) {
        this.hardReplace = hardReplace;
        return this;
    }

    public void build() {
        if (this.rX <= 0.0f && this.rY <= 0.0f && this.rZ <= 0.0f) {
            return;
        }
        if ((double)this.rX <= 0.5 && (double)this.rY <= 0.5 && (double)this.rZ <= 0.5) {
            this.unitReplace(this.core);
            return;
        }
        FastNoise noise = new FastNoise(this.seed);
        noise.SetNoiseType(FastNoise.NoiseType.Simplex);
        noise.SetFrequency(0.12f);
        float effectiveRYLower = -this.rY;
        if (this.boxType == BoxType.UPPER_SEMIBOX) {
            effectiveRYLower = 0.0f;
        }
        float effectiveRYUpper = this.rY;
        if (this.boxType == BoxType.LOWER_SEMIBOX) {
            effectiveRYUpper = 0.0f;
        }
        float fuzzMultiplier = 0.2f;
        for (float y = effectiveRYLower * (1.0f + fuzzMultiplier); y <= effectiveRYUpper * (1.0f + fuzzMultiplier); y += 1.0f) {
            float yMultiplier = 1.0f - Math.abs(y) / this.rY;
            for (float x = -this.rX * (1.0f + fuzzMultiplier) * yMultiplier; x <= this.rX * (1.0f + fuzzMultiplier) * yMultiplier; x += 1.0f) {
                for (float z = -this.rZ * (1.0f + fuzzMultiplier) * yMultiplier; z <= this.rZ * (1.0f + fuzzMultiplier) * yMultiplier; z += 1.0f) {
                    SimpleBlock rel = this.core.getRelative(Math.round(x), Math.round(y), Math.round(z));
                    double noiseVal = Math.abs(noise.GetNoise(rel.getX(), rel.getY(), rel.getZ()));
                    if (!((double)Math.abs(x) <= (double)this.rX * (1.0 + noiseVal * (double)fuzzMultiplier)) || !((double)Math.abs(y) <= (double)this.rY * (1.0 + noiseVal * (double)fuzzMultiplier)) || !((double)Math.abs(z) <= (double)this.rZ * (1.0 + noiseVal * (double)fuzzMultiplier))) continue;
                    Material[] original = this.types;
                    if (rel.getY() <= this.staticWaterLevel) {
                        this.types = new Material[]{Material.WATER};
                        for (BlockFace face : new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST, BlockFace.DOWN}) {
                            if (!BlockUtils.isAir(rel.getRelative(face).getType())) continue;
                            this.types = new Material[]{Material.STONE};
                        }
                    }
                    this.unitReplace(rel);
                    this.types = original;
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void unitReplace(@NotNull SimpleBlock rel) {
        if (this.replaceWhitelist.isEmpty()) {
            if (!this.hardReplace && rel.isSolid()) return;
            rel.setType(GenUtils.randChoice(this.random, this.types));
        } else {
            if (!this.replaceWhitelist.contains(rel.getType())) return;
            rel.setType(GenUtils.randChoice(this.random, this.types));
        }
        if (!rel.getDown().isSolid()) return;
        if (this.upperType != null) {
            rel.getUp().lsetType(this.upperType);
        }
        if (this.lowerType == null) return;
        rel.getDown().setType(this.lowerType);
    }

    public static enum BoxType {
        UPPER_SEMIBOX,
        LOWER_SEMIBOX,
        FULL_BOX;

    }
}

