/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.utils.datastructs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConcurrentLRUCache<K, V> {
    private final ThreadLocal<HashMap<K, LRUNode<K, V>>> localCache = ThreadLocal.withInitial(HashMap::new);
    private final int maxSize;
    private final int localCacheSize;
    private final ReadWriteLock rwlock = new ReentrantReadWriteLock();
    private final Lock readLock = this.rwlock.readLock();
    private final Lock writeLock = this.rwlock.writeLock();
    private final HashMap<K, LRUNode<K, V>> keyToValue;
    private final Function<@NotNull K, @Nullable V> generator;
    private final String name;

    public ConcurrentLRUCache(String name, int maxSize, Function<@NotNull K, @Nullable V> generator) {
        this.name = name;
        this.maxSize = maxSize;
        this.localCacheSize = 5;
        this.generator = generator;
        this.keyToValue = new HashMap(maxSize);
    }

    public ConcurrentLRUCache(String name, int maxSize, int localMaxSize, Function<@NotNull K, @Nullable V> generator) {
        this.name = name;
        this.maxSize = maxSize;
        this.localCacheSize = localMaxSize;
        this.generator = generator;
        this.keyToValue = new HashMap(maxSize);
    }

    private LRUNode<K, V> slowPathGet(K key) {
        LRUNode<K, V> node = null;
        this.readLock.lock();
        try {
            node = this.keyToValue.get(key);
            if (node != null) {
                node.lastAccess.lazySet(System.nanoTime());
            }
        }
        finally {
            this.readLock.unlock();
            if (node == null) {
                node = this.calculateAndInsert(key);
            }
        }
        return node;
    }

    public V get(K key) {
        HashMap<K, LRUNode<K, LRUNode<K, V>>> localMap = this.localCache.get();
        LRUNode<K, V> node = localMap.get(key);
        if (node == null) {
            node = this.slowPathGet(key);
            if (localMap.size() >= this.localCacheSize) {
                localMap.clear();
            }
            localMap.put(key, node);
        } else {
            node.lastAccess.lazySet(System.nanoTime());
        }
        return node.value;
    }

    private LRUNode<K, V> calculateAndInsert(K key) {
        LRUNode<K, V> node;
        this.writeLock.lock();
        try {
            node = this.keyToValue.get(key);
            if (node == null) {
                if (this.keyToValue.size() >= this.maxSize) {
                    this.pruneLRU();
                }
                node = new LRUNode<K, V>(key, this.generator.apply(key));
                this.keyToValue.put(key, node);
            }
        }
        finally {
            this.writeLock.unlock();
        }
        return node;
    }

    private void pruneLRU() {
        ArrayList<LRUNode<K, V>> nodes = new ArrayList<LRUNode<K, V>>(this.keyToValue.values());
        long min = Long.MAX_VALUE;
        long max = Long.MIN_VALUE;
        for (LRUNode<K, V> node : nodes) {
            long cmp = node.snap();
            min = Math.min(cmp, min);
            max = Math.max(cmp, max);
        }
        long midPoint = (min + max) / 2L;
        for (LRUNode<K, V> node : nodes) {
            if (node.snapshot >= midPoint) continue;
            this.keyToValue.remove(node.key);
        }
    }

    private static final class LRUNode<K, V> {
        @NotNull
        public final K key;
        @Nullable
        public final V value;
        @NotNull
        public final AtomicLong lastAccess = new AtomicLong(System.nanoTime());
        private long snapshot;

        public LRUNode(@NotNull K k, @Nullable V v) {
            this.key = k;
            this.value = v;
        }

        public long snap() {
            this.snapshot = this.lastAccess.get();
            return this.snapshot;
        }
    }
}

