/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.v1_18_R2;

import org.apache.commons.lang.StringUtils;
import org.bukkit.Keyed;
import org.bukkit.Tag;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Wall;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.terraform.coregen.BlockDataFixerAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.utils.BlockUtils;

public class BlockDataFixer
extends BlockDataFixerAbstract {
    public static void correctWallData(@NotNull SimpleBlock target) {
        BlockFace[] blockFaceArray = target.getBlockData();
        if (!(blockFaceArray instanceof Wall)) {
            return;
        }
        Wall data = (Wall)blockFaceArray;
        for (BlockFace face : BlockUtils.directBlockFaces) {
            if (target.getRelative(face).isSolid() && !target.getRelative(face).getType().toString().contains("PRESSURE_PLATE")) {
                data.setHeight(face, Wall.Height.LOW);
                if (!target.getRelative(BlockFace.UP).isSolid()) continue;
                data.setHeight(face, Wall.Height.TALL);
                continue;
            }
            data.setHeight(face, Wall.Height.NONE);
        }
    }

    public static void correctSurroundingWallData(@NotNull SimpleBlock target) {
        if (!(target.getBlockData() instanceof Wall)) {
            return;
        }
        BlockDataFixer.correctWallData(target);
        for (BlockFace face : BlockUtils.directBlockFaces) {
            if (!Tag.WALLS.isTagged((Keyed)target.getRelative(face).getType())) continue;
            BlockDataFixer.correctWallData(target.getRelative(face));
        }
    }

    @Override
    @Nullable
    public String updateSchematic(double schematicVersion, String schematic) {
        if (schematicVersion > 18.0) {
            schematic = StringUtils.replace((String)schematic, (String)"persistent=true,waterlogged=false]", (String)"persistent=true]");
            schematic = StringUtils.replace((String)schematic, (String)"mud_brick_", (String)"stone_brick_");
            schematic = StringUtils.replace((String)schematic, (String)"mud_bricks", (String)"stone_bricks");
        }
        return schematic;
    }

    @Override
    public void correctFacing(Vector v, @Nullable SimpleBlock b, @Nullable BlockData data, BlockFace face) {
        if (data == null && b != null) {
            data = b.getBlockData();
        }
        if (!this.hasFlushed && data instanceof Wall) {
            this.pushChanges(v);
            return;
        }
        if (data instanceof Wall && b != null) {
            BlockDataFixer.correctSurroundingWallData(b);
        }
    }
}

