/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.v1_18_R2;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.block.entity.TileEntityBeehive;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.IChunkAccess;
import org.bukkit.World;
import org.bukkit.block.Beehive;
import org.bukkit.craftbukkit.v1_18_R2.CraftChunk;
import org.bukkit.craftbukkit.v1_18_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_18_R2.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_18_R2.generator.CraftLimitedRegion;
import org.bukkit.craftbukkit.v1_18_R2.generator.CustomChunkGenerator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.terraform.coregen.BlockDataFixerAbstract;
import org.terraform.coregen.NMSInjectorAbstract;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.coregen.populatordata.PopulatorDataICAAbstract;
import org.terraform.coregen.populatordata.PopulatorDataPostGen;
import org.terraform.coregen.populatordata.PopulatorDataSpigotAPI;
import org.terraform.data.TerraformWorld;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.v1_18_R2.BlockDataFixer;
import org.terraform.v1_18_R2.CustomBiomeHandler;
import org.terraform.v1_18_R2.NMSChunkGenerator;
import org.terraform.v1_18_R2.PopulatorDataICA;

public class NMSInjector
extends NMSInjectorAbstract {
    @Nullable
    private static Method getTileEntity = null;

    @Override
    public void startupTasks() {
        CustomBiomeHandler.init();
    }

    @Override
    @NotNull
    public BlockDataFixerAbstract getBlockDataFixer() {
        return new BlockDataFixer();
    }

    @Override
    public boolean attemptInject(@NotNull World world) {
        CraftWorld cw = (CraftWorld)world;
        WorldServer ws = cw.getHandle();
        TerraformWorld.get((World)world).minY = -64;
        TerraformWorld.get((World)world).maxY = 320;
        NMSChunkGenerator bpg = new NMSChunkGenerator(world.getName(), (int)world.getSeed(), ws.k().g());
        TerraformGeneratorPlugin.logger.info("NMSChunkGenerator Delegate is of type " + ws.k().g().getClass().getSimpleName());
        if (ws.k().g() instanceof CustomChunkGenerator) {
            try {
                Field f = CustomChunkGenerator.class.getDeclaredField("delegate");
                f.setAccessible(true);
                ChunkGenerator delegate = (ChunkGenerator)f.get(ws.k().g());
                TerraformGeneratorPlugin.logger.info("CustomChunkGenerator Delegate is of type " + delegate.getClass().getSimpleName());
            }
            catch (Exception e) {
                TerraformGeneratorPlugin.logger.stackTrace(e);
            }
        }
        TerraformGeneratorPlugin.logger.info("- minY " + ws.q_().k() + "   " + world.getMinHeight());
        TerraformGeneratorPlugin.logger.info("- Height " + ws.q_().l() + "   " + world.getMaxHeight());
        TerraformGeneratorPlugin.logger.info("- LogicalHeight " + ws.q_().m() + "   " + world.getLogicalHeight());
        PlayerChunkMap pcm = ws.k().a;
        try {
            TerraformGeneratorPlugin.privateFieldHandler.injectField((Object)pcm, "u", (Object)bpg);
        }
        catch (Throwable e) {
            TerraformGeneratorPlugin.logger.stackTrace(e);
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public PopulatorDataICAAbstract getICAData(@NotNull org.bukkit.Chunk chunk) {
        Chunk ica = ((CraftChunk)chunk).getHandle();
        CraftWorld cw = (CraftWorld)chunk.getWorld();
        WorldServer ws = cw.getHandle();
        TerraformWorld tw = TerraformWorld.get(chunk.getWorld());
        return new PopulatorDataICA(new PopulatorDataPostGen(chunk), tw, ws, (IChunkAccess)ica, chunk.getX(), chunk.getZ());
    }

    @Override
    @Nullable
    public PopulatorDataICAAbstract getICAData(PopulatorDataAbstract data) {
        if (data instanceof PopulatorDataSpigotAPI) {
            PopulatorDataSpigotAPI pdata = (PopulatorDataSpigotAPI)data;
            GeneratorAccessSeed gas = ((CraftLimitedRegion)pdata.lr).getHandle();
            WorldServer ws = gas.getMinecraftWorld();
            TerraformWorld tw = TerraformWorld.get(ws.getWorld().getName(), ws.D());
            return new PopulatorDataICA(data, tw, ws, gas.a(data.getChunkX(), data.getChunkZ()), data.getChunkX(), data.getChunkZ());
        }
        if (data instanceof PopulatorDataPostGen) {
            PopulatorDataPostGen gdata = (PopulatorDataPostGen)data;
            return this.getICAData(gdata.getChunk());
        }
        return null;
    }

    @Override
    public void storeBee(Beehive hive) {
        try {
            if (getTileEntity == null) {
                getTileEntity = CraftBlockEntityState.class.getDeclaredMethod("getTileEntity", new Class[0]);
                getTileEntity.setAccessible(true);
            }
            TileEntityBeehive teb = (TileEntityBeehive)getTileEntity.invoke((Object)hive, new Object[0]);
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.a("id", "minecraft:bee");
            teb.a(nbttagcompound, 0, false);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getMinY() {
        return -64;
    }

    @Override
    public int getMaxY() {
        return 320;
    }
}

