/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.v1_19_R3;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.WorldChunkManager;
import org.bukkit.block.Biome;
import org.bukkit.craftbukkit.v1_19_R3.block.CraftBlock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.terraform.biome.BiomeBank;
import org.terraform.biome.custombiomes.CustomBiomeType;
import org.terraform.data.TerraformWorld;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.v1_19_R3.CustomBiomeHandler;

public class TerraformWorldProviderBiome
extends WorldChunkManager {
    private static final boolean debug = false;
    private final TerraformWorld tw;
    private final IRegistry<BiomeBase> registry;
    private final Set<Holder<BiomeBase>> biomeList = TerraformWorldProviderBiome.biomeListToBiomeBaseSet(CustomBiomeHandler.getBiomeRegistry());

    public TerraformWorldProviderBiome(TerraformWorld tw, WorldChunkManager delegate) {
        this.tw = tw;
        this.registry = CustomBiomeHandler.getBiomeRegistry();
    }

    private static Set<Holder<BiomeBase>> biomeListToBiomeBaseSet(@NotNull IRegistry<BiomeBase> registry) {
        ArrayList<Holder> biomeBases = new ArrayList<Holder>();
        for (Biome biome : Biome.values()) {
            if (biome == null || biome == Biome.CUSTOM) continue;
            try {
                biomeBases.add(CraftBlock.biomeToBiomeBase(registry, (Biome)biome));
            }
            catch (IllegalStateException e) {
                TerraformGeneratorPlugin.logger.info("Ignoring biome " + String.valueOf(biome));
            }
        }
        for (CustomBiomeType customBiomeType : CustomBiomeType.values()) {
            if (customBiomeType == CustomBiomeType.NONE) continue;
            ResourceKey<BiomeBase> rkey = CustomBiomeHandler.terraformGenBiomeRegistry.get((Object)customBiomeType);
            Optional holder = registry.b(rkey);
            holder.ifPresent(biomeBases::add);
        }
        return Set.copyOf(biomeBases);
    }

    public Stream<Holder<BiomeBase>> b() {
        return this.biomeList.stream();
    }

    public Set<Holder<BiomeBase>> c() {
        return this.biomeList;
    }

    protected Codec<? extends WorldChunkManager> a() {
        throw new UnsupportedOperationException("Cannot serialize TerraformWorldProviderBiome");
    }

    @Nullable
    public Holder<BiomeBase> getNoiseBiome(int x, int y, int z, Climate.Sampler arg3) {
        BiomeBank bank = this.tw.getBiomeBank(x << 2, z << 2);
        if (bank.getHandler().getCustomBiome() == CustomBiomeType.NONE) {
            return CraftBlock.biomeToBiomeBase(this.registry, (Biome)bank.getHandler().getBiome());
        }
        ResourceKey<BiomeBase> rkey = CustomBiomeHandler.terraformGenBiomeRegistry.get((Object)bank.getHandler().getCustomBiome());
        Optional holder = this.registry.b(rkey);
        if (holder.isEmpty()) {
            TerraformGeneratorPlugin.logger.error("Custom biome was not found in the vanilla registry!");
        }
        if (holder.isPresent()) {
            return (Holder)holder.get();
        }
        return CraftBlock.biomeToBiomeBase(this.registry, (Biome)bank.getHandler().getBiome());
    }

    public static class TerraformBiomeResolverProxy
    implements BiomeResolver {
        final TerraformWorldProviderBiome delegate;

        public TerraformBiomeResolverProxy(TerraformWorldProviderBiome delegate) {
            this.delegate = delegate;
        }

        @Nullable
        public Holder<BiomeBase> getNoiseBiome(int arg0, int arg1, int arg2, Climate.Sampler arg3) {
            return this.delegate.getNoiseBiome(arg0, arg1, arg2, arg3);
        }
    }
}

