/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.v1_20_R4;

import org.bukkit.Keyed;
import org.bukkit.Tag;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Wall;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.terraform.coregen.BlockDataFixerAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.utils.BlockUtils;

public class BlockDataFixer
extends BlockDataFixerAbstract {
    public static void correctWallData(@NotNull SimpleBlock target) {
        BlockFace[] blockFaceArray = target.getBlockData();
        if (!(blockFaceArray instanceof Wall)) {
            return;
        }
        Wall data = (Wall)blockFaceArray;
        for (BlockFace face : BlockUtils.directBlockFaces) {
            if (target.getRelative(face).isSolid() && !target.getRelative(face).getType().toString().contains("PRESSURE_PLATE")) {
                data.setHeight(face, Wall.Height.LOW);
                if (!target.getRelative(BlockFace.UP).isSolid()) continue;
                data.setHeight(face, Wall.Height.TALL);
                continue;
            }
            data.setHeight(face, Wall.Height.NONE);
        }
    }

    public static void correctSurroundingWallData(@NotNull SimpleBlock target) {
        if (!(target.getBlockData() instanceof Wall)) {
            return;
        }
        BlockDataFixer.correctWallData(target);
        for (BlockFace face : BlockUtils.directBlockFaces) {
            if (!Tag.WALLS.isTagged((Keyed)target.getRelative(face).getType())) continue;
            BlockDataFixer.correctWallData(target.getRelative(face));
        }
    }

    @Override
    public String updateSchematic(double schematicVersion, String schematic) {
        return schematic;
    }

    @Override
    public void correctFacing(Vector v, @Nullable SimpleBlock b, @Nullable BlockData data, BlockFace face) {
        if (data == null && b != null) {
            data = b.getBlockData();
        }
        if (!this.hasFlushed && data instanceof Wall) {
            this.pushChanges(v);
            return;
        }
        if (data instanceof Wall && b != null) {
            BlockDataFixer.correctSurroundingWallData(b);
        }
    }
}

