/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.v1_21_R1;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.RegionLimitedWorldAccess;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockColumn;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.levelgen.WorldGenStage;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.structures.BuriedTreasureStructure;
import net.minecraft.world.level.levelgen.structure.structures.JigsawStructure;
import net.minecraft.world.level.levelgen.structure.structures.OceanMonumentStructure;
import net.minecraft.world.level.levelgen.structure.structures.StrongholdStructure;
import net.minecraft.world.level.levelgen.structure.structures.WoodlandMansionStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.jetbrains.annotations.NotNull;
import org.terraform.coregen.bukkit.TerraformGenerator;
import org.terraform.data.MegaChunk;
import org.terraform.data.TerraformWorld;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.main.config.TConfig;
import org.terraform.structure.SingleMegaChunkStructurePopulator;
import org.terraform.structure.StructureLocator;
import org.terraform.structure.StructurePopulator;
import org.terraform.structure.StructureRegistry;
import org.terraform.structure.VanillaStructurePopulator;
import org.terraform.structure.monument.MonumentPopulator;
import org.terraform.structure.pillager.mansion.MansionPopulator;
import org.terraform.structure.small.buriedtreasure.BuriedTreasurePopulator;
import org.terraform.structure.stronghold.StrongholdPopulator;
import org.terraform.structure.trialchamber.TrialChamberPopulator;
import org.terraform.v1_21_R1.MapRenderWorldProviderBiome;
import org.terraform.v1_21_R1.TerraformWorldProviderBiome;

public class NMSChunkGenerator
extends ChunkGenerator {
    @NotNull
    private final ChunkGenerator delegate;
    @NotNull
    private final TerraformWorld tw;
    @NotNull
    private final MapRenderWorldProviderBiome mapRendererBS;
    @NotNull
    private final TerraformWorldProviderBiome twBS;
    @NotNull
    private final Method tryGenerateStructure;
    private final ArrayList<MinecraftKey> possibleStructureSets = new ArrayList();
    @NotNull
    private final Method getWriteableArea;
    @NotNull
    private final Supplier featuresPerStep;

    public NMSChunkGenerator(String worldName, long seed, @NotNull ChunkGenerator delegate) throws NoSuchMethodException, SecurityException, NoSuchFieldException, IllegalAccessException {
        super(delegate.d(), delegate.d);
        this.tw = TerraformWorld.get(worldName, seed);
        this.delegate = delegate;
        this.mapRendererBS = new MapRenderWorldProviderBiome(this.tw, delegate.d());
        this.twBS = new TerraformWorldProviderBiome(TerraformWorld.get(worldName, seed), delegate.d());
        Field f = ChunkGenerator.class.getDeclaredField("c");
        f.setAccessible(true);
        this.featuresPerStep = (Supplier)f.get(delegate);
        this.getWriteableArea = ChunkGenerator.class.getDeclaredMethod("a", IChunkAccess.class);
        this.getWriteableArea.setAccessible(true);
        for (StructurePopulator pop : StructureRegistry.getAllPopulators()) {
            if (!(pop instanceof VanillaStructurePopulator)) continue;
            VanillaStructurePopulator vsp = (VanillaStructurePopulator)pop;
            this.possibleStructureSets.add(MinecraftKey.a((String)vsp.structureRegistryKey));
        }
        this.tryGenerateStructure = ChunkGenerator.class.getDeclaredMethod("a", StructureSet.a.class, StructureManager.class, IRegistryCustom.class, RandomState.class, StructureTemplateManager.class, Long.TYPE, IChunkAccess.class, ChunkCoordIntPair.class, SectionPosition.class);
        this.tryGenerateStructure.setAccessible(true);
    }

    @NotNull
    public WorldChunkManager d() {
        return this.mapRendererBS;
    }

    @NotNull
    public TerraformWorld getTerraformWorld() {
        return this.tw;
    }

    @NotNull
    protected MapCodec<? extends ChunkGenerator> b() {
        return MapCodec.unit(null);
    }

    @NotNull
    public CompletableFuture<IChunkAccess> a(RandomState randomstate, Blender blender, StructureManager structuremanager, @NotNull IChunkAccess ichunkaccess) {
        return CompletableFuture.supplyAsync(SystemUtils.a((String)"init_biomes", () -> ichunkaccess), SystemUtils.g());
    }

    public Pair<BlockPosition, Holder<Structure>> a(WorldServer worldserver, @NotNull HolderSet<Structure> holderset, @NotNull BlockPosition blockposition, int i, boolean flag) {
        int pX = blockposition.u();
        int pZ = blockposition.w();
        for (Holder holder : holderset) {
            Structure feature = (Structure)holder.a();
            TerraformGeneratorPlugin.logger.info("Vanilla locate for " + feature.getClass().getName() + " invoked.");
            if (((Structure)holder.a()).getClass() == StrongholdStructure.class) {
                int[] coords = new StrongholdPopulator().getNearestFeature(this.tw, pX, pZ);
                return new Pair((Object)new BlockPosition(coords[0], 20, coords[1]), (Object)holder);
            }
            if (TConfig.c.DEVSTUFF_VANILLA_LOCATE_DISABLE) continue;
            if (((Structure)holder.a()).getClass() == OceanMonumentStructure.class) {
                int[] coords = StructureLocator.locateSingleMegaChunkStructure(this.tw, pX, pZ, new MonumentPopulator(), TConfig.c.DEVSTUFF_VANILLA_LOCATE_TIMEOUTMILLIS);
                return new Pair((Object)new BlockPosition(coords[0], 50, coords[1]), (Object)holder);
            }
            if (((Structure)holder.a()).getClass() == WoodlandMansionStructure.class) {
                int[] coords = StructureLocator.locateSingleMegaChunkStructure(this.tw, pX, pZ, new MansionPopulator(), TConfig.c.DEVSTUFF_VANILLA_LOCATE_TIMEOUTMILLIS);
                return new Pair((Object)new BlockPosition(coords[0], 50, coords[1]), (Object)holder);
            }
            if (holder.a() instanceof JigsawStructure && MinecraftServer.getServer().bc().d(Registries.aR).a(MinecraftKey.a((String)"trial_chambers")) == holder.a()) {
                int[] coords = StructureLocator.locateSingleMegaChunkStructure(this.tw, pX, pZ, new TrialChamberPopulator(), TConfig.c.DEVSTUFF_VANILLA_LOCATE_TIMEOUTMILLIS);
                return new Pair((Object)new BlockPosition(coords[0], 50, coords[1]), (Object)holder);
            }
            if (((Structure)holder.a()).getClass() != BuriedTreasureStructure.class) continue;
            int[] coords = StructureLocator.locateMultiMegaChunkStructure(this.tw, new MegaChunk(pX, 0, pZ), new BuriedTreasurePopulator(), TConfig.c.DEVSTUFF_VANILLA_LOCATE_TIMEOUTMILLIS);
            if (coords == null) {
                return null;
            }
            return new Pair((Object)new BlockPosition(coords[0], 50, coords[1]), (Object)holder);
        }
        return null;
    }

    public void a(GeneratorAccessSeed generatoraccessseed, IChunkAccess ichunkaccess, StructureManager structuremanager) {
        this.delegate.a(generatoraccessseed, ichunkaccess, structuremanager);
        this.addVanillaDecorations(generatoraccessseed, ichunkaccess, structuremanager);
    }

    public void addVanillaDecorations(GeneratorAccessSeed generatoraccessseed, IChunkAccess ichunkaccess, StructureManager structuremanager) {
        ChunkCoordIntPair chunkcoordintpair = ichunkaccess.f();
        if (!SharedConstants.a((ChunkCoordIntPair)chunkcoordintpair)) {
            SectionPosition sectionposition = SectionPosition.a((ChunkCoordIntPair)chunkcoordintpair, (int)generatoraccessseed.ao());
            BlockPosition blockposition = sectionposition.j();
            IRegistry iregistry = generatoraccessseed.H_().d(Registries.aR);
            Map<Integer, List<Structure>> map = iregistry.t().collect(Collectors.groupingBy(structure -> structure.c().ordinal()));
            List list = (List)this.featuresPerStep.get();
            SeededRandom seededrandom = new SeededRandom((RandomSource)new XoroshiroRandomSource(RandomSupport.a()));
            long i = seededrandom.a(generatoraccessseed.C(), blockposition.u(), blockposition.w());
            ObjectArraySet set = new ObjectArraySet();
            ChunkCoordIntPair.a((ChunkCoordIntPair)sectionposition.r(), (int)1).forEach(arg_0 -> NMSChunkGenerator.lambda$addVanillaDecorations$2(generatoraccessseed, (Set)set, arg_0));
            set.retainAll(this.b.c());
            int j = list.size();
            try {
                IRegistry iregistry1 = generatoraccessseed.H_().d(Registries.aQ);
                int k = Math.max(WorldGenStage.Decoration.values().length, j);
                for (int l = 0; l < k; ++l) {
                    int i1 = 0;
                    if (!structuremanager.a()) continue;
                    List list1 = map.getOrDefault(l, Collections.emptyList());
                    for (Structure structure2 : list1) {
                        seededrandom.b(i, i1, l);
                        Supplier<String> supplier = () -> {
                            Optional<String> optional = iregistry.d((Object)structure2).map(Object::toString);
                            Objects.requireNonNull(structure2);
                            return (String)optional.orElseGet(structure2::toString);
                        };
                        try {
                            generatoraccessseed.a(supplier);
                            structuremanager.a(sectionposition, structure2).forEach(structurestart -> {
                                try {
                                    structurestart.a(generatoraccessseed, structuremanager, (ChunkGenerator)this, (RandomSource)seededrandom, (StructureBoundingBox)this.getWriteableArea.invoke(null, ichunkaccess), chunkcoordintpair);
                                }
                                catch (IllegalAccessException | InvocationTargetException e) {
                                    CrashReport crashreport = CrashReport.a((Throwable)e, (String)"TerraformGenerator");
                                    throw new ReportedException(crashreport);
                                }
                            });
                        }
                        catch (Exception exception) {
                            CrashReport crashreport = CrashReport.a((Throwable)exception, (String)"Feature placement");
                            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Feature");
                            Objects.requireNonNull(supplier);
                            crashreportsystemdetails.a("Description", supplier::get);
                            throw new ReportedException(crashreport);
                        }
                        ++i1;
                    }
                }
                generatoraccessseed.a((Supplier)null);
            }
            catch (Exception exception2) {
                CrashReport crashreport2 = CrashReport.a((Throwable)exception2, (String)"Biome decoration");
                crashreport2.a("Generation").a("CenterX", (Object)chunkcoordintpair.e).a("CenterZ", (Object)chunkcoordintpair.f).a("Decoration Seed", (Object)i);
                throw new ReportedException(crashreport2);
            }
        }
    }

    public void a(RegionLimitedWorldAccess regionlimitedworldaccess, long seed, RandomState randomstate, BiomeManager biomemanager, StructureManager structuremanager, @NotNull IChunkAccess ichunkaccess, WorldGenStage.Features worldgenstage_features) {
        ichunkaccess.a((BiomeResolver)this.twBS, null);
        this.delegate.a(regionlimitedworldaccess, seed, randomstate, biomemanager, structuremanager, ichunkaccess, worldgenstage_features);
    }

    public int e() {
        return this.delegate.e();
    }

    public void a(IRegistryCustom iregistrycustom, @NotNull ChunkGeneratorStructureState chunkgeneratorstructurestate, StructureManager structuremanager, @NotNull IChunkAccess ichunkaccess, StructureTemplateManager structuretemplatemanager) {
        ChunkCoordIntPair chunkcoordintpair = ichunkaccess.f();
        SectionPosition sectionposition = SectionPosition.a((IChunkAccess)ichunkaccess);
        RandomState randomstate = chunkgeneratorstructurestate.c();
        MegaChunk mc = new MegaChunk(chunkcoordintpair.e, chunkcoordintpair.f);
        SingleMegaChunkStructurePopulator[] spops = StructureRegistry.getLargeStructureForMegaChunk(this.tw, mc);
        int[] centerCoords = mc.getCenterBiomeSectionChunkCoords();
        for (SingleMegaChunkStructurePopulator pop : spops) {
            if (!(pop instanceof VanillaStructurePopulator)) continue;
            VanillaStructurePopulator vpop = (VanillaStructurePopulator)pop;
            this.possibleStructureSets.stream().filter(resourceLoc -> vpop.structureRegistryKey.equals(resourceLoc.a())).map(resourceLoc -> (StructureSet)MinecraftServer.getServer().bc().d(Registries.aT).a(resourceLoc)).forEach(structureSet -> {
                StructurePlacement structureplacement = structureSet.b();
                List list = structureSet.a();
                if (centerCoords[0] == chunkcoordintpair.e && centerCoords[1] == chunkcoordintpair.f) {
                    try {
                        Object retVal = this.tryGenerateStructure.invoke((Object)this, list.getFirst(), structuremanager, iregistrycustom, randomstate, structuretemplatemanager, chunkgeneratorstructurestate.d(), ichunkaccess, chunkcoordintpair, sectionposition);
                        TerraformGeneratorPlugin.logger.info(chunkcoordintpair.e + "," + chunkcoordintpair.f + " will spawn a vanilla structure, with tryGenerateStructure == " + String.valueOf(retVal));
                    }
                    catch (Throwable t) {
                        TerraformGeneratorPlugin.logger.info(chunkcoordintpair.e + "," + chunkcoordintpair.f + " Failed to generate a vanilla structure");
                        TerraformGeneratorPlugin.logger.stackTrace(t);
                    }
                }
            });
        }
    }

    public void a(GeneratorAccessSeed gas, StructureManager manager, IChunkAccess ica) {
        this.delegate.a(gas, manager, ica);
    }

    public int a(LevelHeightAccessor levelheightaccessor) {
        return 64;
    }

    public CompletableFuture<IChunkAccess> a(Blender blender, RandomState randomstate, StructureManager structuremanager, IChunkAccess ichunkaccess) {
        return this.delegate.a(blender, randomstate, structuremanager, ichunkaccess);
    }

    public void a(RegionLimitedWorldAccess regionlimitedworldaccess, StructureManager structuremanager, RandomState randomstate, IChunkAccess ichunkaccess) {
        this.delegate.a(regionlimitedworldaccess, structuremanager, randomstate, ichunkaccess);
    }

    public BlockColumn a(int i, int j, LevelHeightAccessor levelheightaccessor, RandomState randomstate) {
        return this.delegate.a(i, j, levelheightaccessor, randomstate);
    }

    public void a(RegionLimitedWorldAccess regionlimitedworldaccess) {
        this.delegate.a(regionlimitedworldaccess);
    }

    public int f() {
        return TerraformGenerator.seaLevel;
    }

    public int g() {
        return this.delegate.g();
    }

    public int b(int i, int j, HeightMap.Type heightmap_type, LevelHeightAccessor levelheightaccessor, RandomState randomstate) {
        return this.a(i, j, heightmap_type, levelheightaccessor, randomstate);
    }

    public int c(int i, int j, HeightMap.Type heightmap_type, LevelHeightAccessor levelheightaccessor, RandomState randomstate) {
        return this.a(i, j, heightmap_type, levelheightaccessor, randomstate) - 1;
    }

    public int a(int i, int j, HeightMap.Type heightmap_type, LevelHeightAccessor levelheightaccessor, RandomState randomstate) {
        return 100;
    }

    public void a(List<String> list, RandomState randomstate, BlockPosition blockposition) {
    }

    private static /* synthetic */ void lambda$addVanillaDecorations$2(GeneratorAccessSeed generatoraccessseed, Set set, ChunkCoordIntPair chunkcoordintpair1) {
        IChunkAccess ichunkaccess1 = generatoraccessseed.a(chunkcoordintpair1.e, chunkcoordintpair1.f);
        for (ChunkSection chunksection : ichunkaccess1.d()) {
            PalettedContainerRO palettedcontainerro = chunksection.i();
            Objects.requireNonNull(set);
            palettedcontainerro.a(set::add);
        }
    }
}

