/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.v1_21_R6;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.WritableRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ReloadableServerRegistries;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.MobSpawnSettings;
import org.bukkit.Bukkit;
import org.bukkit.Registry;
import org.bukkit.block.Biome;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.block.CraftBiome;
import org.jetbrains.annotations.NotNull;
import org.terraform.biome.custombiomes.CustomBiomeType;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.utils.version.TerraformFieldHandler;
import org.terraform.utils.version.TerraformMethodHandler;

public class CustomBiomeHandler {
    public static final HashMap<CustomBiomeType, ResourceKey<net.minecraft.world.level.biome.Biome>> terraformGenBiomeRegistry = new HashMap();

    public static net.minecraft.core.Registry<net.minecraft.world.level.biome.Biome> getBiomeRegistry() {
        return (net.minecraft.core.Registry)MinecraftServer.getServer().registryAccess().lookup(Registries.BIOME).orElseThrow();
    }

    public static void init() {
        CraftServer craftserver = (CraftServer)Bukkit.getServer();
        DedicatedServer dedicatedserver = craftserver.getServer();
        WritableRegistry registrywritable = (WritableRegistry)CustomBiomeHandler.getBiomeRegistry();
        try {
            TerraformFieldHandler frozen = new TerraformFieldHandler(MappedRegistry.class, "frozen", "l");
            frozen.field.set(registrywritable, false);
            TerraformGeneratorPlugin.logger.info("Unfreezing biome registry...");
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e1) {
            TerraformGeneratorPlugin.logger.error(e1.toString());
            TerraformGeneratorPlugin.logger.stackTrace(e1);
            return;
        }
        Holder.Reference forestbiome = registrywritable.createRegistrationLookup().getOrThrow(Biomes.FOREST);
        for (CustomBiomeType type : CustomBiomeType.values()) {
            if (type == CustomBiomeType.NONE) continue;
            try {
                assert (forestbiome != null);
                CustomBiomeHandler.registerCustomBiome(type, dedicatedserver, (WritableRegistry<net.minecraft.world.level.biome.Biome>)registrywritable, (Holder<net.minecraft.world.level.biome.Biome>)forestbiome);
                TerraformGeneratorPlugin.logger.info("Registered custom biome: " + type.toString().toLowerCase(Locale.ENGLISH));
            }
            catch (Throwable e2) {
                TerraformGeneratorPlugin.logger.error("Failed to register custom biome: " + type.getKey());
                TerraformGeneratorPlugin.logger.stackTrace(e2);
            }
        }
        try {
            TerraformFieldHandler frozen = new TerraformFieldHandler(MappedRegistry.class, "frozen", "l");
            frozen.field.set(registrywritable, true);
            TerraformGeneratorPlugin.logger.info("Freezing biome registry");
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e1) {
            TerraformGeneratorPlugin.logger.stackTrace(e1);
        }
    }

    private static void registerCustomBiome(@NotNull CustomBiomeType biomeType, DedicatedServer dedicatedserver, @NotNull WritableRegistry<net.minecraft.world.level.biome.Biome> registrywritable, @NotNull Holder<net.minecraft.world.level.biome.Biome> forestBiomeHolder) throws Throwable {
        net.minecraft.world.level.biome.Biome forestbiome = (net.minecraft.world.level.biome.Biome)forestBiomeHolder.value();
        TerraformFieldHandler defaultRegInfoField = new TerraformFieldHandler(ReloadableServerRegistries.class, "b", "DEFAULT_REGISTRATION_INFO");
        Object regInfo = defaultRegInfoField.field.get(null);
        ResourceKey newKey = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"terraformgenerator", (String)biomeType.toString().toLowerCase(Locale.ENGLISH)));
        Biome.BiomeBuilder newBiomeBuilder = new Biome.BiomeBuilder();
        newBiomeBuilder.hasPrecipitation(forestbiome.hasPrecipitation());
        TerraformFieldHandler biomeSettingMobsField = new TerraformFieldHandler(net.minecraft.world.level.biome.Biome.class, "mobSettings", "k");
        MobSpawnSettings biomeSettingMobs = (MobSpawnSettings)biomeSettingMobsField.field.get(forestbiome);
        newBiomeBuilder.mobSpawnSettings(biomeSettingMobs);
        TerraformFieldHandler biomeSettingGenField = new TerraformFieldHandler(net.minecraft.world.level.biome.Biome.class, "generationSettings", "j");
        BiomeGenerationSettings biomeSettingGen = (BiomeGenerationSettings)biomeSettingGenField.field.get(forestbiome);
        newBiomeBuilder.generationSettings(biomeSettingGen);
        newBiomeBuilder.temperature(0.7f);
        newBiomeBuilder.downfall(biomeType.getRainFall());
        if (biomeType.isCold()) {
            newBiomeBuilder.temperatureAdjustment(Biome.TemperatureModifier.FROZEN);
        } else {
            newBiomeBuilder.temperatureAdjustment(Biome.TemperatureModifier.NONE);
        }
        BiomeSpecialEffects.Builder newFog = new BiomeSpecialEffects.Builder();
        newFog.fogColor(biomeType.getFogColor().isEmpty() ? forestbiome.getFogColor() : Integer.parseInt(biomeType.getFogColor(), 16)).waterColor(biomeType.getWaterColor().isEmpty() ? forestbiome.getWaterColor() : Integer.parseInt(biomeType.getWaterColor(), 16)).waterFogColor(biomeType.getWaterFogColor().isEmpty() ? forestbiome.getWaterFogColor() : Integer.parseInt(biomeType.getWaterFogColor(), 16)).skyColor(biomeType.getSkyColor().isEmpty() ? forestbiome.getSkyColor() : Integer.parseInt(biomeType.getSkyColor(), 16)).foliageColorOverride(biomeType.getFoliageColor().isEmpty() ? forestbiome.getFoliageColor() : Integer.parseInt(biomeType.getFoliageColor(), 16)).grassColorOverride(biomeType.getGrassColor().isEmpty() ? Integer.parseInt("79C05A", 16) : Integer.parseInt(biomeType.getGrassColor(), 16));
        newBiomeBuilder.specialEffects(newFog.build());
        net.minecraft.world.level.biome.Biome biome = newBiomeBuilder.build();
        if (registrywritable.createRegistrationLookup().get(newKey).isPresent() && ((Holder.Reference)registrywritable.createRegistrationLookup().get(newKey).get()).isBound()) {
            TerraformGeneratorPlugin.logger.info(String.valueOf(newKey) + " was already registered. Was there a plugin/server reload?");
            return;
        }
        TerraformMethodHandler register = new TerraformMethodHandler(registrywritable.getClass(), new String[]{"register", "a"}, ResourceKey.class, Object.class, Class.forName("net.minecraft.core.RegistrationInfo"));
        Holder.Reference holder = (Holder.Reference)register.method.invoke(registrywritable, newKey, biome, regInfo);
        TerraformMethodHandler bindValue = new TerraformMethodHandler(Holder.Reference.class, new String[]{"bindValue", "b"}, Object.class);
        bindValue.method.invoke((Object)holder, biome);
        HashSet tags = new HashSet();
        forestBiomeHolder.tags().forEach(tags::add);
        TerraformMethodHandler bindTags = new TerraformMethodHandler(Holder.Reference.class, new String[]{"bindTags", "a"}, Collection.class);
        bindTags.method.invoke((Object)holder, tags);
        terraformGenBiomeRegistry.put(biomeType, (ResourceKey<net.minecraft.world.level.biome.Biome>)newKey);
    }

    public static Set<Holder<net.minecraft.world.level.biome.Biome>> biomeListToBiomeSet(@NotNull net.minecraft.core.Registry<net.minecraft.world.level.biome.Biome> registry) {
        ArrayList Biomes2 = new ArrayList();
        Registry.BIOME.iterator().forEachRemaining(biome -> {
            try {
                if (biome == null) {
                    return;
                }
                Holder holder = CraftBiome.bukkitToMinecraftHolder((Biome)biome);
                if (holder == null) {
                    return;
                }
                Biomes2.add(holder);
            }
            catch (Throwable e2) {
                TerraformGeneratorPlugin.logger.info("Ignoring biome " + String.valueOf(biome));
            }
        });
        for (CustomBiomeType cbt : CustomBiomeType.values()) {
            if (cbt == CustomBiomeType.NONE) continue;
            ResourceKey<net.minecraft.world.level.biome.Biome> rkey = terraformGenBiomeRegistry.get((Object)cbt);
            Optional holder = registry.get(rkey);
            holder.ifPresent(Biomes2::add);
        }
        return Set.copyOf(Biomes2);
    }
}

