/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.biome.beach;

import java.util.Random;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.jetbrains.annotations.NotNull;
import org.terraform.biome.BiomeHandler;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.TerraformWorld;
import org.terraform.utils.GenUtils;

public class IcyBeachHandler
extends BiomeHandler {
    private static void makeIceSheet(int x, int y, int z, @NotNull PopulatorDataAbstract data, @NotNull Random random) {
        int length = GenUtils.randInt(6, 16);
        int nx = x;
        int nz = z;
        while (length > 0) {
            --length;
            if (data.getType(nx, y, nz).isSolid() && data.getType(nx, y + 1, nz) == Material.AIR) {
                data.setType(nx, y, nz, Material.ICE);
            }
            switch (random.nextInt(5)) {
                case 0: {
                    ++nx;
                    break;
                }
                case 2: {
                    ++nz;
                    break;
                }
                case 3: {
                    --nx;
                    break;
                }
                case 4: {
                    --nz;
                }
            }
            y = GenUtils.getTransformedHeight(data.getTerraformWorld(), nx, nz);
        }
    }

    @Override
    public boolean isOcean() {
        return false;
    }

    @Override
    @NotNull
    public Biome getBiome() {
        return Biome.SNOWY_BEACH;
    }

    @Override
    public Material @NotNull [] getSurfaceCrust(@NotNull Random rand) {
        return new Material[]{GenUtils.weightedRandomMaterial(rand, Material.STONE, 35, Material.GRAVEL, 5, Material.COBBLESTONE, 10), GenUtils.weightedRandomMaterial(rand, Material.STONE, 35, Material.GRAVEL, 5, Material.COBBLESTONE, 10), GenUtils.randChoice(rand, new Material[]{Material.STONE, Material.COBBLESTONE, Material.GRAVEL}), GenUtils.randChoice(rand, new Material[]{Material.STONE, Material.COBBLESTONE, Material.GRAVEL})};
    }

    @Override
    public void populateSmallItems(TerraformWorld world, @NotNull Random random, int rawX, int surfaceY, int rawZ, @NotNull PopulatorDataAbstract data) {
        if (GenUtils.chance(random, 7, 100)) {
            IcyBeachHandler.makeIceSheet(rawX, surfaceY, rawZ, data, random);
            return;
        }
    }

    @Override
    public void populateLargeItems(TerraformWorld tw, Random random, PopulatorDataAbstract data) {
    }
}

