/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.biome.cavepopulators;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.jetbrains.annotations.NotNull;
import org.terraform.biome.cavepopulators.AbstractCavePopulator;
import org.terraform.data.SimpleBlock;
import org.terraform.data.TerraformWorld;
import org.terraform.data.Wall;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.noise.FastNoise;
import org.terraform.utils.noise.NoiseCacheHandler;

public abstract class AbstractCaveClusterPopulator
extends AbstractCavePopulator {
    private final float radius;
    protected SimpleBlock center;
    protected SimpleBlock lowestYCenter;

    public AbstractCaveClusterPopulator(float radius) {
        this.radius = radius;
    }

    protected abstract void oneUnit(TerraformWorld var1, Random var2, SimpleBlock var3, SimpleBlock var4, boolean var5);

    @Override
    public void populate(TerraformWorld tw, Random random, @NotNull SimpleBlock ceil, @NotNull SimpleBlock floor) {
        if (this.radius <= 0.0f) {
            return;
        }
        ArrayList<SimpleBlock[]> ceilFloorPairs = new ArrayList<SimpleBlock[]>();
        ArrayList<Boolean> boundaries = new ArrayList<Boolean>();
        FastNoise circleNoise = NoiseCacheHandler.getNoise(tw, NoiseCacheHandler.NoiseCacheEntry.BIOME_CAVECLUSTER_CIRCLENOISE, world -> {
            FastNoise n = new FastNoise((int)(world.getSeed() * 11L));
            n.SetNoiseType(FastNoise.NoiseType.Simplex);
            n.SetFrequency(0.09f);
            return n;
        });
        this.center = new SimpleBlock(ceil.getPopData(), ceil.getX(), (ceil.getY() + floor.getY()) / 2, ceil.getZ());
        int lowest = this.center.getY();
        HashMap<SimpleBlock, Wall[]> seen = new HashMap<SimpleBlock, Wall[]>();
        ArrayDeque<SimpleBlock> queue = new ArrayDeque<SimpleBlock>();
        queue.add(this.center);
        seen.put(this.center, new Wall[]{new Wall(ceil), new Wall(floor)});
        while (!queue.isEmpty()) {
            SimpleBlock v = (SimpleBlock)queue.remove();
            Wall vCeil = ((Wall[])seen.get(v))[0];
            Wall vFloor = ((Wall[])seen.get(v))[1];
            lowest = Math.min(vFloor.getY(), lowest);
            ceilFloorPairs.add(new SimpleBlock[]{vCeil.get(), vFloor.get()});
            boolean sawFailCondition = false;
            for (BlockFace face : BlockUtils.directBlockFaces) {
                SimpleBlock neighbour = v.getRelative(face);
                if (seen.containsKey(neighbour)) continue;
                double equationResult = Math.pow(neighbour.getX() - this.center.getX(), 2.0) / Math.pow(this.radius, 2.0) + Math.pow(neighbour.getZ() - this.center.getZ(), 2.0) / Math.pow(this.radius, 2.0);
                if (equationResult > 1.0 + 0.7 * (double)circleNoise.GetNoise(neighbour.getX(), neighbour.getZ())) {
                    sawFailCondition = true;
                    continue;
                }
                Wall candidateFloorWall = new Wall(neighbour).findStonelikeFloor(60);
                Wall candidateCeilWall = new Wall(neighbour).findStonelikeCeiling(60);
                if (candidateFloorWall == null || candidateCeilWall == null || BlockUtils.amethysts.contains(floor.getType()) || BlockUtils.fluids.contains(floor.getUp().getType()) || BlockUtils.amethysts.contains(ceil.getDown().getType()) || candidateFloorWall.getType() == Material.MOSS_BLOCK || candidateFloorWall.getType() == Material.DRIPSTONE_BLOCK || candidateFloorWall.getUp().isSolid() || candidateCeilWall.getDown().isSolid()) continue;
                seen.put(neighbour, new Wall[]{candidateCeilWall, candidateFloorWall});
                queue.add(neighbour);
            }
            boundaries.add(sawFailCondition);
        }
        this.lowestYCenter = this.center.getAtY(lowest);
        for (int i = 0; i < ceilFloorPairs.size(); ++i) {
            SimpleBlock[] candidates = (SimpleBlock[])ceilFloorPairs.get(i);
            if (BlockUtils.fluids.contains(candidates[1].getAtY(lowest + 1).getType())) continue;
            this.oneUnit(tw, random, candidates[0], candidates[1], (Boolean)boundaries.get(i));
        }
    }
}

