/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.biome.cavepopulators;

import java.util.Random;
import org.jetbrains.annotations.NotNull;
import org.terraform.biome.cavepopulators.AbstractCaveClusterPopulator;
import org.terraform.biome.cavepopulators.CaveFluidClusterPopulator;
import org.terraform.biome.cavepopulators.CrystallineClusterCavePopulator;
import org.terraform.biome.cavepopulators.DripstoneClusterCavePopulator;
import org.terraform.biome.cavepopulators.LushClusterCavePopulator;
import org.terraform.main.config.TConfig;
import org.terraform.utils.GenUtils;

public enum CaveClusterRegistry {
    LUSH(9527213, TConfig.c.BIOME_CAVE_LUSHCLUSTER_SEPARATION, (float)TConfig.c.BIOME_CAVE_LUSHCLUSTER_MAXPERTUB),
    DRIPSTONE(5902907, TConfig.c.BIOME_CAVE_DRIPSTONECLUSTER_SEPARATION, (float)TConfig.c.BIOME_CAVE_DRIPSTONECLUSTER_MAXPERTUB),
    CRYSTALLINE(4427781, TConfig.c.BIOME_CAVE_CRYSTALLINECLUSTER_SEPARATION, (float)TConfig.c.BIOME_CAVE_CRYSTALLINECLUSTER_MAXPERTUB),
    FLUID(79183628, 40, 0.2f);

    final int hashSeed;
    final int separation;
    final float pertub;

    private CaveClusterRegistry(int hashSeed, int separation, float pertub) {
        this.hashSeed = hashSeed;
        this.separation = separation;
        this.pertub = pertub;
    }

    @NotNull
    public AbstractCaveClusterPopulator getPopulator(@NotNull Random random) {
        return switch (this.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> new LushClusterCavePopulator(GenUtils.randInt(random, TConfig.c.BIOME_CAVE_LUSHCLUSTER_MINSIZE, TConfig.c.BIOME_CAVE_LUSHCLUSTER_MAXSIZE), false);
            case 1 -> new DripstoneClusterCavePopulator(GenUtils.randInt(random, TConfig.c.BIOME_CAVE_DRIPSTONECLUSTER_MINSIZE, TConfig.c.BIOME_CAVE_DRIPSTONECLUSTER_MAXSIZE));
            case 2 -> new CrystallineClusterCavePopulator(GenUtils.randInt(random, TConfig.c.BIOME_CAVE_CRYSTALLINECLUSTER_MINSIZE, TConfig.c.BIOME_CAVE_CRYSTALLINECLUSTER_MAXSIZE));
            case 3 -> new CaveFluidClusterPopulator(GenUtils.randInt(random, TConfig.c.BIOME_CAVE_CRYSTALLINECLUSTER_MINSIZE, TConfig.c.BIOME_CAVE_CRYSTALLINECLUSTER_MAXSIZE));
        };
    }

    public int getHashSeed() {
        return this.hashSeed;
    }

    public int getSeparation() {
        return this.separation;
    }

    public float getPertub() {
        return this.pertub;
    }
}

