/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.biome.cavepopulators;

import java.util.Random;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Biome;
import org.bukkit.block.BlockFace;
import org.jetbrains.annotations.NotNull;
import org.terraform.biome.cavepopulators.AbstractCaveClusterPopulator;
import org.terraform.coregen.populatordata.PopulatorDataICAAbstract;
import org.terraform.coregen.populatordata.PopulatorDataICABiomeWriterAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.TerraformWorld;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.main.config.TConfig;
import org.terraform.small_items.PlantBuilder;
import org.terraform.tree.TreeDB;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;
import org.terraform.utils.SphereBuilder;
import org.terraform.utils.blockdata.BisectedBuilder;
import org.terraform.utils.blockdata.DirectionalBuilder;
import org.terraform.utils.blockdata.MultipleFacingBuilder;
import org.terraform.utils.version.Version;

public class LushClusterCavePopulator
extends AbstractCaveClusterPopulator {
    private final boolean isForLargeCave;

    public LushClusterCavePopulator(float radius, boolean isForLargeCave) {
        super(radius);
        this.isForLargeCave = isForLargeCave;
    }

    @Override
    public void oneUnit(@NotNull TerraformWorld tw, @NotNull Random random, @NotNull SimpleBlock ceil, @NotNull SimpleBlock floor, boolean boundary) {
        PopulatorDataICAAbstract populatorDataICAAbstract;
        int caveHeight = ceil.getY() - floor.getY();
        if (!BlockUtils.isWet(ceil.getDown())) {
            SimpleBlock base;
            if (Tag.SLABS.isTagged((Keyed)floor.getType()) || Tag.WALLS.isTagged((Keyed)floor.getType())) {
                return;
            }
            if (GenUtils.chance(random, 1, 8)) {
                ceil.setType(Material.ROOTED_DIRT);
                if (random.nextBoolean()) {
                    PlantBuilder.HANGING_ROOTS.build(ceil.getDown());
                }
            } else {
                ceil.setType(Material.MOSS_BLOCK);
                for (BlockFace face : BlockUtils.sixBlockFaces) {
                    if (ceil.getRelative(face).getType() != Material.LAVA) continue;
                    ceil.getRelative(face).setType(Material.AIR);
                }
                if (GenUtils.chance(random, 1, 15)) {
                    PlantBuilder.SPORE_BLOSSOM.build(ceil.getDown());
                }
            }
            if (this.isForLargeCave && GenUtils.chance(random, 1, 300) && BlockUtils.isDirtLike((base = ceil.getGround()).getType()) && !BlockUtils.isWet(base.getUp())) {
                TreeDB.spawnAzalea(random, tw, base.getPopData(), base.getX(), base.getY() + 1, base.getZ());
            }
            int glowBerryChance = 5;
            if (this.isForLargeCave) {
                glowBerryChance = 7;
            }
            if (GenUtils.chance(random, 1, glowBerryChance)) {
                int h2 = caveHeight / 4;
                if (h2 < 1) {
                    h2 = 1;
                }
                if (h2 > 6) {
                    h2 = 6;
                }
                BlockUtils.downLCaveVines(h2, ceil.getDown());
            }
        }
        if (BlockUtils.isWet(floor.getUp())) {
            if (!this.isForLargeCave) {
                floor.setType(Material.CLAY);
            }
            return;
        }
        floor.setType(Material.MOSS_BLOCK);
        if (GenUtils.chance(random, 1, 15)) {
            if (random.nextBoolean()) {
                PlantBuilder.AZALEA.build(floor.getUp());
            } else {
                PlantBuilder.FLOWERING_AZALEA.build(floor.getUp());
            }
        } else if (Version.isAtLeast(17.0) && GenUtils.chance(random, 1, 7)) {
            if (TConfig.arePlantsEnabled()) {
                if (random.nextBoolean()) {
                    new DirectionalBuilder(Material.BIG_DRIPLEAF).setFacing(BlockUtils.getDirectBlockFace(random)).apply(floor.getUp());
                } else {
                    new BisectedBuilder(Material.SMALL_DRIPLEAF).placeBoth(floor.getUp());
                }
            }
        } else if (GenUtils.chance(random, 1, 6)) {
            PlantBuilder.GRASS.build(floor.getUp());
        } else if (GenUtils.chance(random, 1, 7)) {
            PlantBuilder.MOSS_CARPET.build(floor.getUp());
        }
        if (!this.isForLargeCave) {
            SimpleBlock target = floor;
            while (target.getY() != ceil.getY()) {
                if (target.getY() - floor.getY() < 3 && GenUtils.chance(1, 700)) {
                    new SphereBuilder(random, target, Material.WATER).setSphereType(SphereBuilder.SphereType.LOWER_SEMISPHERE).setCointainmentMaterials(Material.CLAY).setRX(3.0f).setRY(2.0f).setRZ(3.0f).setDoLiquidContainment(true).setHardReplace(true).build();
                }
                for (BlockFace face : BlockUtils.directBlockFaces) {
                    SimpleBlock rel = target.getRelative(face);
                    if (!BlockUtils.isStoneLike(rel.getType())) continue;
                    rel.setType(Material.MOSS_BLOCK);
                    if (!TConfig.arePlantsEnabled() || !BlockUtils.isAir(target.getType()) || !GenUtils.chance(random, 1, 5)) continue;
                    new MultipleFacingBuilder(Material.GLOW_LICHEN).setFace(face, true).apply(target);
                }
                target = target.getUp();
            }
        }
        if ((populatorDataICAAbstract = TerraformGeneratorPlugin.injector.getICAData(ceil.getPopData())) instanceof PopulatorDataICABiomeWriterAbstract) {
            PopulatorDataICABiomeWriterAbstract data = (PopulatorDataICABiomeWriterAbstract)populatorDataICAAbstract;
            while (floor.getY() < ceil.getY()) {
                data.setBiome(floor.getX(), floor.getY(), floor.getZ(), Biome.LUSH_CAVES);
                floor = floor.getUp();
            }
        }
    }
}

