/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.biome.flat;

import java.util.ArrayList;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Rotatable;
import org.jetbrains.annotations.NotNull;
import org.terraform.biome.BiomeBank;
import org.terraform.biome.BiomeHandler;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.SimpleLocation;
import org.terraform.data.TerraformWorld;
import org.terraform.main.config.TConfig;
import org.terraform.small_items.PlantBuilder;
import org.terraform.tree.FractalTypes;
import org.terraform.tree.MushroomBuilder;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;

public class DarkForestHandler
extends BiomeHandler {
    private static void spawnRock(Random rand, @NotNull PopulatorDataAbstract data, int x, int y, int z) {
        ArrayList<int[]> locations = new ArrayList<int[]>();
        locations.add(new int[]{x, y, z});
        locations.add(new int[]{x, y + 2, z});
        locations.add(new int[]{x, y + 1, z});
        locations.add(new int[]{x + 1, y + 1, z});
        locations.add(new int[]{x - 1, y + 1, z});
        locations.add(new int[]{x, y + 1, z + 1});
        locations.add(new int[]{x, y + 1, z - 1});
        locations.add(new int[]{x + 1, y, z});
        locations.add(new int[]{x - 1, y, z});
        locations.add(new int[]{x, y, z + 1});
        locations.add(new int[]{x, y, z - 1});
        locations.add(new int[]{x + 1, y, z});
        locations.add(new int[]{x - 1, y, z + 1});
        locations.add(new int[]{x + 1, y, z + 1});
        locations.add(new int[]{x - 1, y, z - 1});
        for (int[] coords : locations) {
            int Tz;
            int Ty;
            int Tx = coords[0];
            if (data.getType(Tx, Ty = coords[1], Tz = coords[2]).isSolid() && !data.getType(Tx, Ty, Tz).toString().contains("LEAVES")) continue;
            BlockUtils.setDownUntilSolid(Tx, Ty, Tz, data, Material.COBBLESTONE, Material.MOSSY_COBBLESTONE, Material.STONE, Material.CHISELED_STONE_BRICKS, Material.STONE_BRICKS, Material.CRACKED_STONE_BRICKS, Material.MOSSY_STONE_BRICKS);
        }
    }

    @Override
    public boolean isOcean() {
        return false;
    }

    @Override
    @NotNull
    public Biome getBiome() {
        return Biome.DARK_FOREST;
    }

    @Override
    public Material @NotNull [] getSurfaceCrust(@NotNull Random rand) {
        return new Material[]{Material.GRASS_BLOCK, Material.DIRT, Material.DIRT, GenUtils.randChoice(rand, new Material[]{Material.DIRT, Material.STONE}), GenUtils.randChoice(rand, new Material[]{Material.DIRT, Material.STONE})};
    }

    @Override
    public void populateSmallItems(TerraformWorld tw, @NotNull Random random, int rawX, int surfaceY, int rawZ, @NotNull PopulatorDataAbstract data) {
        boolean spawnHeads;
        boolean bl = spawnHeads = TConfig.c.BIOME_DARK_FOREST_SPAWN_HEADS && GenUtils.chance(random, 1, 100);
        if (data.getType(rawX, surfaceY, rawZ) == Material.GRASS_BLOCK && GenUtils.chance(random, 1, 10)) {
            if (data.getType(rawX, surfaceY + 1, rawZ) != Material.AIR) {
                return;
            }
            PlantBuilder.GRASS.build(data, rawX, surfaceY + 1, rawZ);
            if (random.nextInt(3) != 0) {
                PlantBuilder.TALL_GRASS.build(data, rawX, surfaceY + 1, rawZ);
            } else if (random.nextBoolean()) {
                PlantBuilder.BROWN_MUSHROOM.build(data, rawX, surfaceY + 1, rawZ);
            } else {
                PlantBuilder.RED_MUSHROOM.build(data, rawX, surfaceY + 1, rawZ);
            }
        }
        if (spawnHeads && TConfig.areDecorationsEnabled() && GenUtils.chance(random, 1, 50) && BlockUtils.isDirtLike(data.getType(rawX, surfaceY, rawZ))) {
            Rotatable skull = (Rotatable)Bukkit.createBlockData((Material)Material.PLAYER_HEAD);
            skull.setRotation(BlockUtils.getXZPlaneBlockFace(random));
            data.setBlockData(rawX, surfaceY + 1, rawZ, (BlockData)skull);
        }
    }

    @Override
    public void populateLargeItems(@NotNull TerraformWorld tw, @NotNull Random random, @NotNull PopulatorDataAbstract data) {
        int choice;
        int treeY;
        SimpleLocation[] bigTrees = GenUtils.randomObjectPositions(tw, data.getChunkX(), data.getChunkZ(), 20);
        SimpleLocation[] trees = GenUtils.randomObjectPositions(tw, data.getChunkX(), data.getChunkZ(), 10);
        SimpleLocation[] smallDecorations = GenUtils.randomObjectPositions(tw, data.getChunkX(), data.getChunkZ(), 7);
        for (SimpleLocation sLoc : bigTrees) {
            treeY = GenUtils.getHighestGround(data, sLoc.getX(), sLoc.getZ());
            if (data.getBiome((sLoc = sLoc.getAtY(treeY)).getX(), sLoc.getZ()) != this.getBiome() || !BlockUtils.isDirtLike(data.getType(sLoc.getX(), sLoc.getY(), sLoc.getZ()))) continue;
            if (GenUtils.chance(random, 2, 10)) {
                choice = random.nextInt(3);
                FractalTypes.Mushroom type = switch (choice) {
                    case 0 -> FractalTypes.Mushroom.GIANT_RED_MUSHROOM;
                    case 1 -> FractalTypes.Mushroom.GIANT_BROWN_MUSHROOM;
                    default -> FractalTypes.Mushroom.GIANT_BROWN_FUNNEL_MUSHROOM;
                };
                new MushroomBuilder(type).build(tw, data, sLoc.getX(), sLoc.getY(), sLoc.getZ());
                continue;
            }
            if (!TConfig.c.TREES_DARK_FOREST_BIG_ENABLED) continue;
            FractalTypes.Tree.DARK_OAK_BIG_TOP.build(tw, new SimpleBlock(data, sLoc));
        }
        for (SimpleLocation sLoc : trees) {
            treeY = GenUtils.getHighestGround(data, sLoc.getX(), sLoc.getZ());
            if (data.getBiome((sLoc = sLoc.getAtY(treeY)).getX(), sLoc.getZ()) != this.getBiome() || !BlockUtils.isDirtLike(data.getType(sLoc.getX(), sLoc.getY(), sLoc.getZ()))) continue;
            FractalTypes.Tree.DARK_OAK_SMALL.build(tw, new SimpleBlock(data, sLoc));
        }
        block12: for (SimpleLocation sLoc : smallDecorations) {
            treeY = GenUtils.getHighestGround(data, sLoc.getX(), sLoc.getZ());
            if (data.getBiome((sLoc = sLoc.getAtY(treeY)).getX(), sLoc.getZ()) != this.getBiome() || !BlockUtils.isDirtLike(data.getType(sLoc.getX(), sLoc.getY(), sLoc.getZ()))) continue;
            choice = random.nextInt(5);
            switch (choice) {
                case 0: {
                    new MushroomBuilder(FractalTypes.Mushroom.SMALL_POINTY_RED_MUSHROOM).build(tw, data, sLoc.getX(), sLoc.getY() + 1, sLoc.getZ());
                    continue block12;
                }
                case 1: {
                    new MushroomBuilder(FractalTypes.Mushroom.SMALL_BROWN_MUSHROOM).build(tw, data, sLoc.getX(), sLoc.getY() + 1, sLoc.getZ());
                    continue block12;
                }
                case 2: {
                    new MushroomBuilder(FractalTypes.Mushroom.SMALL_RED_MUSHROOM).build(tw, data, sLoc.getX(), sLoc.getY() + 1, sLoc.getZ());
                    continue block12;
                }
                case 3: {
                    for (int i = 0; i < GenUtils.randInt(3, 6); ++i) {
                        DarkForestHandler.spawnRock(random, data, sLoc.getX(), sLoc.getY() + i + 1, sLoc.getZ());
                    }
                    continue block12;
                }
                default: {
                    new MushroomBuilder(FractalTypes.Mushroom.TINY_RED_MUSHROOM).build(tw, data, sLoc.getX(), sLoc.getY() + 1, sLoc.getZ());
                }
            }
        }
    }

    @Override
    @NotNull
    public BiomeBank getBeachType() {
        return BiomeBank.DARK_FOREST_BEACH;
    }

    @Override
    @NotNull
    public BiomeBank getRiverType() {
        return BiomeBank.DARK_FOREST_RIVER;
    }
}

