/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.biome.flat;

import java.util.Random;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Snowable;
import org.jetbrains.annotations.NotNull;
import org.terraform.biome.BiomeBank;
import org.terraform.biome.BiomeHandler;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.SimpleLocation;
import org.terraform.data.TerraformWorld;
import org.terraform.main.config.TConfig;
import org.terraform.small_items.PlantBuilder;
import org.terraform.tree.FractalTypes;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;
import org.terraform.utils.noise.FastNoise;

public class SnowyTaigaHandler
extends BiomeHandler {
    public static void defrostAndReplacePodzol(int seed, float radius, @NotNull SimpleBlock base) {
        if (radius <= 0.0f) {
            return;
        }
        if ((double)radius <= 0.5) {
            base.setType(GenUtils.randChoice(new Random(seed), new Material[]{Material.PODZOL}));
            return;
        }
        FastNoise noise = new FastNoise(seed);
        noise.SetNoiseType(FastNoise.NoiseType.Simplex);
        noise.SetFrequency(0.13f);
        Random rand = new Random(seed);
        for (float x = -radius; x <= radius; x += 1.0f) {
            for (float z = -radius; z <= radius; z += 1.0f) {
                double noiseVal;
                double equationResult;
                SimpleBlock rel = base.getRelative(Math.round(x), 0, Math.round(z));
                if (!BlockUtils.isDirtLike((rel = rel.getGround()).getType()) || !((equationResult = Math.pow(x, 2.0) / Math.pow(radius, 2.0) + Math.pow(z, 2.0) / Math.pow(radius, 2.0)) <= 1.0 + (noiseVal = (double)Math.abs(noise.GetNoise(rel.getX(), rel.getZ()))))) continue;
                if (equationResult * 4.0 > 0.7 + noiseVal) {
                    if (!rand.nextBoolean()) continue;
                    rel.setType(Material.PODZOL);
                    rel.getUp().lsetType(Material.AIR);
                    continue;
                }
                rel.setType(Material.PODZOL);
                rel.getUp().lsetType(Material.AIR);
            }
        }
    }

    @Override
    public boolean isOcean() {
        return false;
    }

    @Override
    @NotNull
    public Biome getBiome() {
        return Biome.SNOWY_TAIGA;
    }

    @Override
    public Material @NotNull [] getSurfaceCrust(@NotNull Random rand) {
        return new Material[]{GenUtils.weightedRandomMaterial(rand, Material.GRASS_BLOCK, 35, Material.DIRT, 3, Material.PODZOL, 2), Material.DIRT, Material.DIRT, GenUtils.randChoice(rand, new Material[]{Material.DIRT, Material.STONE}), GenUtils.randChoice(rand, new Material[]{Material.DIRT, Material.STONE})};
    }

    @Override
    public void populateSmallItems(TerraformWorld world, @NotNull Random random, int rawX, int surfaceY, int rawZ, @NotNull PopulatorDataAbstract data) {
        if (data.getType(rawX, surfaceY, rawZ) == Material.DIRT && GenUtils.chance(random, 1, 20)) {
            PlantBuilder.DEAD_BUSH.build(data, rawX, surfaceY + 1, rawZ);
            if (random.nextBoolean()) {
                PlantBuilder.ALLIUM.build(data, rawX, surfaceY + 1, rawZ);
            }
        }
        if (data.getType(rawX, surfaceY + 1, rawZ) == Material.AIR && GenUtils.isGroundLike(data.getType(rawX, surfaceY, rawZ))) {
            data.setType(rawX, surfaceY + 1, rawZ, Material.SNOW);
            BlockData blockData = data.getBlockData(rawX, surfaceY, rawZ);
            if (blockData instanceof Snowable) {
                Snowable snowable = (Snowable)blockData;
                snowable.setSnowy(true);
                data.setBlockData(rawX, surfaceY, rawZ, (BlockData)snowable);
            }
        }
    }

    @Override
    public void populateLargeItems(@NotNull TerraformWorld tw, @NotNull Random random, @NotNull PopulatorDataAbstract data) {
        SimpleLocation[] trees;
        for (SimpleLocation sLoc : trees = GenUtils.randomObjectPositions(tw, data.getChunkX(), data.getChunkZ(), 11)) {
            if (data.getBiome(sLoc.getX(), sLoc.getZ()) != this.getBiome()) continue;
            int treeY = GenUtils.getHighestGround(data, sLoc.getX(), sLoc.getZ());
            sLoc = sLoc.getAtY(treeY);
            if (TConfig.c.TREES_TAIGA_BIG_ENABLED && GenUtils.chance(random, 1, 20)) {
                FractalTypes.Tree.TAIGA_BIG.build(tw, new SimpleBlock(data, sLoc.getX(), sLoc.getY(), sLoc.getZ()), b2 -> b2.getFractalLeaves().setSnowy(true));
                SnowyTaigaHandler.defrostAndReplacePodzol(tw.getHashedRand(sLoc.getX(), sLoc.getY(), sLoc.getZ()).nextInt(9999), 2.5f, new SimpleBlock(data, sLoc.getX(), sLoc.getY() - 1, sLoc.getZ()));
                continue;
            }
            FractalTypes.Tree.TAIGA_SMALL.build(tw, new SimpleBlock(data, sLoc.getX(), sLoc.getY(), sLoc.getZ()), b2 -> b2.getFractalLeaves().setSnowy(true));
            SnowyTaigaHandler.defrostAndReplacePodzol(tw.getHashedRand(sLoc.getX(), sLoc.getY(), sLoc.getZ()).nextInt(9999), 1.5f, new SimpleBlock(data, sLoc.getX(), sLoc.getY() - 1, sLoc.getZ()));
        }
    }

    @Override
    @NotNull
    public BiomeBank getBeachType() {
        return BiomeBank.ICY_BEACH;
    }

    @Override
    @NotNull
    public BiomeBank getRiverType() {
        return BiomeBank.FROZEN_RIVER;
    }
}

