/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.biome.mountainous;

import java.util.Random;
import org.bukkit.block.BlockFace;
import org.jetbrains.annotations.NotNull;
import org.terraform.biome.BiomeBank;
import org.terraform.biome.BiomeHandler;
import org.terraform.biome.BiomeSection;
import org.terraform.biome.BiomeType;
import org.terraform.coregen.HeightMap;
import org.terraform.data.SimpleLocation;
import org.terraform.data.TerraformWorld;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.main.config.TConfig;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;

public abstract class AbstractMountainHandler
extends BiomeHandler {
    protected double getPeakMultiplier(@NotNull BiomeSection section, @NotNull Random sectionRandom) {
        double upperBound;
        double lowerBound;
        boolean surroundedByMountains = true;
        block3: for (BlockFace face : BlockUtils.directBlockFaces) {
            switch (section.getRelative(face.getModX(), face.getModZ()).getBiomeBank().getType()) {
                case MOUNTAINOUS: 
                case HIGH_MOUNTAINOUS: {
                    continue block3;
                }
                default: {
                    surroundedByMountains = false;
                }
            }
        }
        if (surroundedByMountains) {
            lowerBound = TConfig.c.BIOME_MOUNTAINOUS_BESIDE_MOUNT_PEAK_MIN;
            upperBound = TConfig.c.BIOME_MOUNTAINOUS_BESIDE_MOUNT_PEAK_MAX;
        } else {
            lowerBound = TConfig.c.BIOME_MOUNTAINOUS_BESIDE_NORMAL_PEAK_MIN;
            upperBound = TConfig.c.BIOME_MOUNTAINOUS_BESIDE_NORMAL_PEAK_MAX;
        }
        return GenUtils.randDouble(sectionRandom, lowerBound, upperBound);
    }

    @Override
    public double calculateHeight(@NotNull TerraformWorld tw, int x, int z) {
        double height = HeightMap.CORE.getHeight(tw, x, z);
        double maxMountainRadius = BiomeSection.sectionWidth;
        height += HeightMap.ATTRITION.getHeight(tw, x, z);
        BiomeSection sect = BiomeBank.getBiomeSectionFromBlockCoords(tw, x, z);
        if (sect.getBiomeBank().getType() != BiomeType.MOUNTAINOUS) {
            sect = BiomeSection.getMostDominantSection(tw, x, z);
        }
        Random sectionRand = sect.getSectionRandom();
        double maxPeak = this.getPeakMultiplier(sect, sectionRand);
        SimpleLocation mountainPeak = sect.getCenter();
        double distFromPeak = 1.42 * maxMountainRadius - Math.sqrt(Math.pow(x - mountainPeak.getX(), 2.0) + Math.pow(z - mountainPeak.getZ(), 2.0));
        double heightMultiplier = maxPeak * (distFromPeak / maxMountainRadius);
        switch (sect.getRelative(sect.getSubSection(x, z)).getBiomeBank().getType()) {
            case OCEANIC: 
            case DEEP_OCEANIC: {
                heightMultiplier = Math.min(heightMultiplier, (double)TConfig.c.BIOME_MOUNTAINOUS_CONNECTOR_OCEAN_MULT);
                break;
            }
            case MOUNTAINOUS: 
            case HIGH_MOUNTAINOUS: {
                heightMultiplier = Math.max(heightMultiplier, (double)TConfig.c.BIOME_MOUNTAINOUS_CONNECTOR_MOUNT_MULT);
            }
        }
        height *= heightMultiplier;
        height = this.limitSigmoid(height, TerraformGeneratorPlugin.injector.getMaxY() - 20);
        return height;
    }

    private double limitSigmoid(double inputY, double limit) {
        if (inputY <= limit) {
            return inputY;
        }
        return limit + (inputY - limit) * Math.pow(1.0 + Math.exp(inputY - limit - 6.0), -1.0);
    }
}

