/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.biome.mountainous;

import java.util.Random;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.jetbrains.annotations.NotNull;
import org.terraform.biome.flat.JungleHandler;
import org.terraform.biome.mountainous.AbstractMountainHandler;
import org.terraform.coregen.HeightMap;
import org.terraform.coregen.bukkit.TerraformGenerator;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.SimpleLocation;
import org.terraform.data.TerraformWorld;
import org.terraform.main.config.TConfig;
import org.terraform.small_items.PlantBuilder;
import org.terraform.tree.FractalTreeBuilder;
import org.terraform.tree.FractalTypes;
import org.terraform.tree.TreeDB;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.CylinderBuilder;
import org.terraform.utils.GenUtils;
import org.terraform.utils.SphereBuilder;
import org.terraform.utils.noise.FastNoise;
import org.terraform.utils.noise.NoiseCacheHandler;

public class ForestedMountainsHandler
extends AbstractMountainHandler {
    private static void dirtStack(@NotNull PopulatorDataAbstract data, @NotNull Random rand, int x, int y, int z) {
        data.setType(x, y, z, Material.GRASS_BLOCK);
        if (GenUtils.chance(rand, 1, 10)) {
            PlantBuilder.GRASS.build(data, x, y + 1, z);
        }
        int depth = GenUtils.randInt(rand, 3, 7);
        for (int i = 1; i < depth && BlockUtils.isStoneLike(data.getType(x, y - i, z)); ++i) {
            data.setType(x, y - i, z, Material.DIRT);
            if (!BlockUtils.isExposedToNonSolid(new SimpleBlock(data, x, y - i, z))) continue;
            ++depth;
        }
    }

    @Override
    public boolean isOcean() {
        return false;
    }

    @Override
    @NotNull
    public Biome getBiome() {
        return Biome.JUNGLE;
    }

    @Override
    public Material @NotNull [] getSurfaceCrust(@NotNull Random rand) {
        return new Material[]{GenUtils.randChoice(rand, new Material[]{Material.STONE, Material.STONE, Material.STONE, Material.STONE, Material.COBBLESTONE}), GenUtils.randChoice(rand, new Material[]{Material.COBBLESTONE, Material.STONE, Material.STONE}), GenUtils.randChoice(rand, new Material[]{Material.COBBLESTONE, Material.STONE, Material.STONE}), GenUtils.randChoice(rand, new Material[]{Material.COBBLESTONE, Material.STONE, Material.STONE}), GenUtils.randChoice(rand, new Material[]{Material.COBBLESTONE, Material.STONE, Material.STONE})};
    }

    @Override
    public void populateSmallItems(TerraformWorld tw, @NotNull Random random, int rawX, int surfaceY, int rawZ, @NotNull PopulatorDataAbstract data) {
        if (rawX % 3 == 0 && rawZ % 3 == 0 && HeightMap.CORE.getHeight(tw, rawX, rawZ) - HeightMap.getRawRiverDepth(tw, rawX, rawZ) < (double)(TerraformGenerator.seaLevel - 4)) {
            new SphereBuilder(random, new SimpleBlock(data, rawX, TerraformGenerator.seaLevel, rawZ), Material.AIR).setRadius(5.0f).setStaticWaterLevel(TerraformGenerator.seaLevel).setHardReplace(true).build();
            if (GenUtils.chance(random, 1, 30)) {
                int cylY = TerraformGenerator.seaLevel + (surfaceY - TerraformGenerator.seaLevel) / 2 + 4;
                new CylinderBuilder(random, new SimpleBlock(data, rawX, cylY, rawZ), Material.AIR).setRadius(5.0f).setRY((float)(surfaceY - TerraformGenerator.seaLevel) / 2.0f + 2.0f).setHardReplace(true).build();
            }
        }
        if (surfaceY < TerraformGenerator.seaLevel) {
            return;
        }
        if (GenUtils.chance(random, 1, 25)) {
            ForestedMountainsHandler.dirtStack(data, random, rawX, surfaceY, rawZ);
            for (int nx = -2; nx <= 2; ++nx) {
                for (int nz = -2; nz <= 2; ++nz) {
                    if (GenUtils.chance(random, 1, 5) || (surfaceY = GenUtils.getHighestGround(data, rawX + nx, rawZ + nz)) < TerraformGenerator.seaLevel) continue;
                    ForestedMountainsHandler.dirtStack(data, random, rawX + nx, surfaceY, rawZ + nz);
                }
            }
        }
    }

    @Override
    public void populateLargeItems(@NotNull TerraformWorld tw, @NotNull Random random, @NotNull PopulatorDataAbstract data) {
        SimpleLocation[] trees;
        FastNoise groundWoodNoise = NoiseCacheHandler.getNoise(tw, NoiseCacheHandler.NoiseCacheEntry.BIOME_JUNGLE_GROUNDWOOD, world -> {
            FastNoise n = new FastNoise((int)(world.getSeed() * 12L));
            n.SetNoiseType(FastNoise.NoiseType.SimplexFractal);
            n.SetFractalOctaves(3);
            n.SetFrequency(0.07f);
            return n;
        });
        FastNoise groundLeavesNoise = NoiseCacheHandler.getNoise(tw, NoiseCacheHandler.NoiseCacheEntry.BIOME_JUNGLE_GROUNDLEAVES, world -> {
            FastNoise n = new FastNoise((int)(world.getSeed() * 2L));
            n.SetNoiseType(FastNoise.NoiseType.SimplexFractal);
            n.SetFrequency(0.07f);
            return n;
        });
        SimpleLocation[] bigTrees = GenUtils.randomObjectPositions(tw, data.getChunkX(), data.getChunkZ(), 20);
        if (TConfig.c.TREES_JUNGLE_BIG_ENABLED) {
            for (SimpleLocation sLoc : bigTrees) {
                int treeY = GenUtils.getHighestGround(data, sLoc.getX(), sLoc.getZ());
                if (data.getBiome((sLoc = sLoc.getAtY(treeY)).getX(), sLoc.getZ()) != this.getBiome() || !BlockUtils.isDirtLike(data.getType(sLoc.getX(), sLoc.getY(), sLoc.getZ()))) continue;
                new FractalTreeBuilder(FractalTypes.Tree.JUNGLE_BIG).skipGradientCheck().build(tw, data, sLoc.getX(), sLoc.getY(), sLoc.getZ());
            }
        }
        for (SimpleLocation sLoc : trees = GenUtils.randomObjectPositions(tw, data.getChunkX(), data.getChunkZ(), 9)) {
            int treeY = GenUtils.getHighestGround(data, sLoc.getX(), sLoc.getZ());
            if (data.getBiome((sLoc = sLoc.getAtY(treeY)).getX(), sLoc.getZ()) != this.getBiome() || !BlockUtils.isDirtLike(data.getType(sLoc.getX(), sLoc.getY(), sLoc.getZ()))) continue;
            TreeDB.spawnSmallJungleTree(true, tw, data, sLoc.getX(), sLoc.getY(), sLoc.getZ());
        }
        for (int x = data.getChunkX() * 16; x < data.getChunkX() * 16 + 16; ++x) {
            for (int z = data.getChunkZ() * 16; z < data.getChunkZ() * 16 + 16; ++z) {
                int y = GenUtils.getHighestGround(data, x, z);
                int distanceToSeaOrMountain = Math.min(y - TerraformGenerator.seaLevel, 80 - y);
                if (distanceToSeaOrMountain > 0) {
                    float leavesNoiseValue = groundLeavesNoise.GetNoise(x, z);
                    float groundWoodNoiseValue = groundWoodNoise.GetNoise(x, z);
                    if (distanceToSeaOrMountain <= 4) {
                        leavesNoiseValue -= -0.25f * (float)distanceToSeaOrMountain + 1.0f;
                        groundWoodNoiseValue -= -0.25f * (float)distanceToSeaOrMountain + 1.0f;
                    }
                    if ((double)leavesNoiseValue > -0.12 && Math.random() > 0.85) {
                        JungleHandler.createBush(data, leavesNoiseValue, x, y, z);
                    } else if (GenUtils.chance(random, 1, 10) && HeightMap.getTrueHeightGradient(data, x, z, 2) > 2.0) {
                        JungleHandler.createBush(data, 0.0f, x, y, z);
                    }
                    if ((double)groundWoodNoiseValue > 0.3) {
                        data.lsetType(x, y + 1, z, Material.JUNGLE_WOOD);
                    }
                }
                if (data.getBiome(x, z) != this.getBiome() || !BlockUtils.isDirtLike(data.getType(x, y, z)) || data.getType(x, y + 1, z) != Material.JUNGLE_WOOD || !BlockUtils.isAir(data.getType(x, y + 2, z)) || !GenUtils.chance(2, 9)) continue;
                PlantBuilder.build(data, x, y + 2, z, PlantBuilder.RED_MUSHROOM, PlantBuilder.BROWN_MUSHROOM);
            }
        }
    }
}

