/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.biome.ocean;

import java.util.Random;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.bukkit.block.BlockFace;
import org.jetbrains.annotations.NotNull;
import org.terraform.biome.BiomeBank;
import org.terraform.biome.BiomeSection;
import org.terraform.biome.BiomeType;
import org.terraform.biome.ocean.AbstractOceanHandler;
import org.terraform.coregen.bukkit.TerraformGenerator;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.SimpleLocation;
import org.terraform.data.TerraformWorld;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.CoralGenerator;
import org.terraform.utils.GenUtils;
import org.terraform.utils.noise.FastNoise;
import org.terraform.utils.noise.NoiseCacheHandler;

public class MushroomIslandHandler
extends AbstractOceanHandler {
    public MushroomIslandHandler() {
        super(BiomeType.DEEP_OCEANIC);
    }

    @Override
    public double calculateHeight(@NotNull TerraformWorld tw, int x, int z) {
        double noise;
        double height = super.calculateHeight(tw, x, z);
        BiomeSection currentSection = BiomeBank.getBiomeSectionFromBlockCoords(tw, x, z);
        if (currentSection.getBiomeBank() != BiomeBank.MUSHROOM_ISLANDS) {
            currentSection = BiomeSection.getMostDominantSection(tw, x, z);
        }
        float islandRadius = (float)BiomeSection.sectionWidth / 2.5f;
        for (BlockFace face : BlockUtils.directBlockFaces) {
            if (!currentSection.getRelative(face.getModX(), face.getModZ()).getBiomeBank().isDry()) continue;
            islandRadius *= 0.65f;
            break;
        }
        FastNoise circleNoise = NoiseCacheHandler.getNoise(tw, NoiseCacheHandler.NoiseCacheEntry.BIOME_MUSHROOMISLAND_CIRCLE, world -> {
            FastNoise n = new FastNoise((int)world.getSeed());
            n.SetNoiseType(FastNoise.NoiseType.SimplexFractal);
            n.SetFractalOctaves(3);
            n.SetFrequency(0.04f);
            return n;
        });
        SimpleLocation center = currentSection.getCenter();
        int relX = x - center.getX();
        int relZ = z - center.getZ();
        double equationResult = Math.pow(relX, 2.0) / Math.pow(islandRadius, 2.0) + Math.pow(relZ, 2.0) / Math.pow(islandRadius, 2.0);
        if (equationResult <= (noise = 1.0 + 0.7 * (double)circleNoise.GetNoise(relX, relZ))) {
            double supplement = (double)TerraformGenerator.seaLevel - height;
            if (equationResult >= noise * 0.9) {
                return height + supplement * 0.6;
            }
            if (equationResult >= noise * 0.7) {
                return height + supplement + 10.0;
            }
            if (equationResult >= noise * 0.6) {
                return height + supplement + 9.0;
            }
            if (equationResult >= noise * 0.5) {
                return height + supplement + 8.0;
            }
            if (equationResult >= noise * 0.4) {
                return height + supplement + 7.5;
            }
            return height + supplement + 7.0;
        }
        return height;
    }

    @Override
    public boolean isOcean() {
        return true;
    }

    @Override
    @NotNull
    public Biome getBiome() {
        return Biome.MUSHROOM_FIELDS;
    }

    @Override
    public Material @NotNull [] getSurfaceCrust(@NotNull Random rand) {
        return new Material[]{Material.GRAVEL, Material.GRAVEL, GenUtils.randChoice(rand, new Material[]{Material.STONE, Material.GRAVEL, Material.STONE}), GenUtils.randChoice(rand, new Material[]{Material.STONE}), GenUtils.randChoice(rand, new Material[]{Material.STONE})};
    }

    @Override
    public void populateSmallItems(TerraformWorld world, @NotNull Random random, int rawX, int surfaceY, int rawZ, @NotNull PopulatorDataAbstract data) {
        if (rawX >= TerraformGenerator.seaLevel) {
            return;
        }
        if (!BlockUtils.isStoneLike(data.getType(rawX, rawX, rawZ))) {
            return;
        }
        if (GenUtils.chance(random, 1, 150)) {
            CoralGenerator.generateKelpGrowth(data, rawX, rawX + 1, rawZ);
        }
    }

    @Override
    public void populateLargeItems(@NotNull TerraformWorld tw, @NotNull Random random, @NotNull PopulatorDataAbstract data) {
        SimpleLocation[] rocks;
        for (SimpleLocation sLoc : rocks = GenUtils.randomObjectPositions(tw, data.getChunkX(), data.getChunkZ(), 25, 0.4f)) {
            int rockY;
            if (data.getBiome(sLoc.getX(), sLoc.getZ()) != this.getBiome() || data.getType((sLoc = sLoc.getAtY(rockY = GenUtils.getHighestGround(data, sLoc.getX(), sLoc.getZ()))).getX(), sLoc.getY(), sLoc.getZ()) != Material.GRAVEL || rockY >= TerraformGenerator.seaLevel) continue;
            BlockUtils.replaceSphere(random.nextInt(9987), (float)GenUtils.randDouble(random, 3.0, 7.0), (float)GenUtils.randDouble(random, 2.0, 4.0), (float)GenUtils.randDouble(random, 3.0, 7.0), new SimpleBlock(data, sLoc), true, GenUtils.randChoice(Material.STONE, Material.GRANITE, Material.ANDESITE, Material.DIORITE));
        }
    }

    @Override
    @NotNull
    public BiomeBank getBeachType() {
        return BiomeBank.MUSHROOM_BEACH;
    }

    @Override
    public boolean forceDefaultToBeach() {
        return true;
    }
}

