/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.command.contants;

import java.util.ArrayList;
import java.util.Locale;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.terraform.command.contants.TerraCommandArgument;
import org.terraform.tree.FractalTypes;

public class MushroomTypeArgument
extends TerraCommandArgument<FractalTypes.Mushroom> {
    public MushroomTypeArgument(String name, boolean isOptional) {
        super(name, isOptional);
    }

    @Override
    public  @NotNull FractalTypes.Mushroom parse(CommandSender sender, @NotNull String value) {
        return FractalTypes.Mushroom.valueOf(value.toUpperCase(Locale.ENGLISH));
    }

    @Override
    @NotNull
    public String validate(CommandSender sender, @NotNull String value) {
        try {
            this.parse(sender, value);
        }
        catch (IllegalArgumentException e2) {
            return "Mushroom type does not exist!";
        }
        return "";
    }

    @Override
    @NotNull
    public ArrayList<String> getTabOptions(String @NotNull [] args) {
        if (args.length != 2) {
            return new ArrayList<String>();
        }
        ArrayList<String> values = new ArrayList<String>();
        for (FractalTypes.Mushroom type : FractalTypes.Mushroom.values()) {
            if (!type.toString().startsWith(args[1].toUpperCase(Locale.ENGLISH))) continue;
            values.add(type.toString());
        }
        return values;
    }
}

