/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.coregen;

import java.util.HashMap;
import org.terraform.biome.BiomeBank;
import org.terraform.biome.BiomeSection;
import org.terraform.coregen.ChunkCache;
import org.terraform.coregen.SectionBlurCache;
import org.terraform.coregen.bukkit.TerraformGenerator;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.CoordPair;
import org.terraform.data.TerraformWorld;
import org.terraform.main.config.TConfig;
import org.terraform.utils.GenUtils;
import org.terraform.utils.datastructs.ConcurrentLRUCache;
import org.terraform.utils.noise.FastNoise;
import org.terraform.utils.noise.NoiseCacheHandler;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum HeightMap {
    RIVER{

        @Override
        public double getHeight(TerraformWorld tw, int x, int z) {
            FastNoise noise = NoiseCacheHandler.getNoise(tw, NoiseCacheHandler.NoiseCacheEntry.HEIGHTMAP_RIVER, world -> {
                FastNoise n = new FastNoise((int)world.getSeed());
                n.SetNoiseType(FastNoise.NoiseType.PerlinFractal);
                n.SetFrequency(TConfig.c.HEIGHT_MAP_RIVER_FREQUENCY);
                n.SetFractalOctaves(5);
                return n;
            });
            return 15.0f - 200.0f * Math.abs(noise.GetNoise(x, z));
        }
    }
    ,
    CORE{

        @Override
        public double getHeight(TerraformWorld tw, int x, int z) {
            FastNoise noise = NoiseCacheHandler.getNoise(tw, NoiseCacheHandler.NoiseCacheEntry.HEIGHTMAP_CORE, world -> {
                FastNoise n = new FastNoise((int)world.getSeed());
                n.SetNoiseType(FastNoise.NoiseType.SimplexFractal);
                n.SetFractalOctaves(2);
                n.SetFrequency(TConfig.c.HEIGHT_MAP_CORE_FREQUENCY);
                return n;
            });
            double height = 10.0f * noise.GetNoise(x, z) + 7.0f + (float)TerraformGenerator.seaLevel;
            if (height > (double)(TerraformGenerator.seaLevel + 10)) {
                height = (height - (double)TerraformGenerator.seaLevel - 10.0) * 0.1 + (double)TerraformGenerator.seaLevel + 10.0;
            }
            return height;
        }
    }
    ,
    ATTRITION{

        @Override
        public double getHeight(TerraformWorld tw, int x, int z) {
            FastNoise perlin = NoiseCacheHandler.getNoise(tw, NoiseCacheHandler.NoiseCacheEntry.HEIGHTMAP_ATTRITION, world -> {
                FastNoise n = new FastNoise((int)world.getSeed() + 113);
                n.SetNoiseType(FastNoise.NoiseType.PerlinFractal);
                n.SetFractalOctaves(4);
                n.SetFrequency(0.02f);
                return n;
            });
            double height = perlin.GetNoise(x, z) * 2.0f * 7.0f;
            return Math.max(0.0, height);
        }
    };

    public static final int defaultSeaLevel = 62;
    public static final float heightAmplifier;
    public static final int MASK_RADIUS = 5;
    public static final int MASK_DIAMETER = 11;
    public static final int MASK_VOLUME = 121;
    private static final int upscaleSize = 3;
    public static int spawnFlatRadiusSquared;
    private static final ConcurrentLRUCache<BiomeSection, SectionBlurCache> BLUR_CACHE;

    public static double getNoiseGradient(TerraformWorld tw, int x, int z, int radius) {
        double totalChangeInGradient = 0.0;
        int count = 0;
        double centerNoise = HeightMap.getBlockHeight(tw, x, z);
        for (int nx = -radius; nx <= radius; ++nx) {
            for (int nz = -radius; nz <= radius; ++nz) {
                if (nx == 0 && nz == 0) continue;
                totalChangeInGradient += Math.abs((double)HeightMap.getBlockHeight(tw, x + nx, z + nz) - centerNoise);
                ++count;
            }
        }
        return totalChangeInGradient / (double)count;
    }

    public static double getTrueHeightGradient(PopulatorDataAbstract data, int x, int z, int radius) {
        double totalChangeInGradient = 0.0;
        int count = 0;
        double centerNoise = GenUtils.getHighestGround(data, x, z);
        for (int nx = -radius; nx <= radius; ++nx) {
            for (int nz = -radius; nz <= radius; ++nz) {
                if (nx == 0 && nz == 0) continue;
                totalChangeInGradient += Math.abs((double)GenUtils.getHighestGround(data, x + nx, z + nz) - centerNoise);
                ++count;
            }
        }
        return totalChangeInGradient / (double)count;
    }

    public static double getRawRiverDepth(TerraformWorld tw, int x, int z) {
        if (Math.pow(x, 2.0) + Math.pow(z, 2.0) < (double)spawnFlatRadiusSquared) {
            return 0.0;
        }
        double depth = RIVER.getHeight(tw, x, z);
        return Math.max(0.0, depth);
    }

    public static double getPreciseHeight(TerraformWorld tw, int x, int z) {
        double depth;
        ChunkCache cache = TerraformGenerator.getCache(tw, x >> 4, z >> 4);
        double cachedValue = cache.getHeightMapHeight(x, z);
        if (cachedValue != (double)ChunkCache.CHUNKCACHE_INVAL) {
            return cachedValue;
        }
        double height = HeightMap.getRiverlessHeight(tw, x, z);
        if (height - (depth = HeightMap.getRawRiverDepth(tw, x, z)) >= (double)(TerraformGenerator.seaLevel - 15)) {
            height -= depth;
        } else if (height > (double)(TerraformGenerator.seaLevel - 15) && height - depth < (double)(TerraformGenerator.seaLevel - 15)) {
            height = TerraformGenerator.seaLevel - 15;
        }
        if (heightAmplifier != 1.0f && height > (double)TerraformGenerator.seaLevel) {
            height += (double)heightAmplifier * (height - (double)TerraformGenerator.seaLevel);
        }
        cache.cacheHeightMap(x, z, height);
        return height;
    }

    static float getDominantBiomeHeight(TerraformWorld tw, int x, int z, HashMap<CoordPair, Float> dominantBiomeHeights) {
        CoordPair key = new CoordPair(x, z);
        Float h2 = dominantBiomeHeights.get(key);
        if (h2 == null) {
            if (x % 3 != 0 && z % 3 != 0) {
                h2 = Float.valueOf(HeightMap.getDominantBiomeHeight(tw, x - x % 3, z - z % 3, dominantBiomeHeights));
            } else {
                h2 = Float.valueOf((float)BiomeBank.calculateHeightIndependentBiome(tw, x, z).getHandler().calculateHeight(tw, x, z));
                if (Math.pow(x, 2.0) + Math.pow(z, 2.0) < (double)spawnFlatRadiusSquared) {
                    h2 = Float.valueOf((float)CORE.getHeight(tw, x, z));
                }
            }
            dominantBiomeHeights.put(key, h2);
        }
        return h2.floatValue();
    }

    public static double getRiverlessHeight(TerraformWorld tw, int x, int z) {
        BiomeSection sect = BiomeBank.getBiomeSectionFromBlockCoords(tw, x, z);
        double coreHeight = BLUR_CACHE.get(sect).getBlurredHeight(x, z);
        return coreHeight += ATTRITION.getHeight(tw, x, z);
    }

    public static int getBlockHeight(TerraformWorld tw, int x, int z) {
        return (int)HeightMap.getPreciseHeight(tw, x, z);
    }

    public abstract double getHeight(TerraformWorld var1, int var2, int var3);

    static {
        heightAmplifier = TConfig.c.HEIGHT_MAP_LAND_HEIGHT_AMPLIFIER;
        spawnFlatRadiusSquared = -324534;
        BLUR_CACHE = new ConcurrentLRUCache<BiomeSection, SectionBlurCache>("BLUR_CACHE", 64, sect -> {
            SectionBlurCache newCache = new SectionBlurCache((BiomeSection)sect, new float[BiomeSection.sectionWidth + 11][BiomeSection.sectionWidth + 11], new float[BiomeSection.sectionWidth + 11][BiomeSection.sectionWidth + 11]);
            newCache.fillCache();
            return newCache;
        });
    }
}

