/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.coregen.bukkit;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.event.Event;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.generator.LimitedRegion;
import org.bukkit.generator.WorldInfo;
import org.jetbrains.annotations.NotNull;
import org.terraform.biome.BiomeBank;
import org.terraform.coregen.populatordata.PopulatorDataPostGen;
import org.terraform.coregen.populatordata.PopulatorDataSpigotAPI;
import org.terraform.data.MegaChunk;
import org.terraform.data.SimpleBlock;
import org.terraform.data.TerraformWorld;
import org.terraform.data.Wall;
import org.terraform.event.TerraformStructureSpawnEvent;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.main.config.TConfig;
import org.terraform.structure.JigsawState;
import org.terraform.structure.JigsawStructurePopulator;
import org.terraform.structure.SingleMegaChunkStructurePopulator;
import org.terraform.structure.StructureRegistry;
import org.terraform.structure.room.CubeRoom;
import org.terraform.structure.room.PathPopulatorData;
import org.terraform.structure.room.RoomLayoutGenerator;
import org.terraform.structure.room.path.PathState;
import org.terraform.structure.stronghold.StrongholdPopulator;
import org.terraform.utils.datastructs.ConcurrentLRUCache;

public class TerraformStructurePopulator
extends BlockPopulator {
    private final ConcurrentLRUCache<MegaChunk, JigsawState> jigsawCache;
    private final TerraformWorld tw;

    public TerraformStructurePopulator(TerraformWorld tw) {
        this.tw = tw;
        this.jigsawCache = new ConcurrentLRUCache<MegaChunk, JigsawState>("jigsawCache", 20, mc -> {
            BiomeBank biome = mc.getCenterBiomeSection(tw).getBiomeBank();
            SingleMegaChunkStructurePopulator spop = this.getMegachunkStructure((MegaChunk)mc, tw, biome);
            if (spop == null) {
                return null;
            }
            if (!(spop instanceof JigsawStructurePopulator)) {
                return null;
            }
            JigsawStructurePopulator jsp = (JigsawStructurePopulator)spop;
            return jsp.calculateRoomPopulators(tw, (MegaChunk)mc);
        });
    }

    public void populate(@NotNull WorldInfo worldInfo, @NotNull Random random, int chunkX, int chunkZ, @NotNull LimitedRegion lr) {
        MegaChunk mc = new MegaChunk(chunkX, chunkZ);
        JigsawState state = this.jigsawCache.get(mc);
        if (state == null) {
            return;
        }
        if (!state.isInRange(chunkX, chunkZ)) {
            return;
        }
        PopulatorDataSpigotAPI data = new PopulatorDataSpigotAPI(lr, this.tw, chunkX, chunkZ);
        ArrayList<HashSet> seenNodes = new ArrayList<HashSet>();
        for (int i = 0; i < state.roomPopulatorStates.size(); ++i) {
            RoomLayoutGenerator roomLayoutGenerator2 = state.roomPopulatorStates.get(i);
            HashSet nodes2 = new HashSet();
            PathState pathState = roomLayoutGenerator2.getOrCalculatePathState(this.tw);
            pathState.nodes.stream().filter(node -> node.center.getX() >> 4 == chunkX && node.center.getZ() >> 4 == chunkZ).forEach(node -> {
                pathState.writer.apply(data, this.tw, (PathState.PathNode)node);
                nodes2.add(node);
            });
            seenNodes.add(nodes2);
        }
        ArrayList seenRooms = new ArrayList();
        state.roomPopulatorStates.forEach(roomLayoutGenerator -> roomLayoutGenerator.getRooms().stream().filter(room -> room.canLRCarve(chunkX, chunkZ, lr)).forEach(room -> {
            seenRooms.add(room);
            if (roomLayoutGenerator.roomCarver != null) {
                roomLayoutGenerator.roomCarver.carveRoom(data, (CubeRoom)room, roomLayoutGenerator.wallMaterials);
            }
        }));
        seenNodes.forEach(nodes -> nodes.forEach(node -> {
            if (node.populator != null) {
                node.populator.populate(new PathPopulatorData(new Wall(new SimpleBlock(data, node.center), node.connected.size() == 1 ? (BlockFace)node.connected.stream().findAny().get() : BlockFace.UP), node.pathRadius));
            }
        }));
        seenRooms.stream().filter(room -> room.getPop() != null).forEach(room -> room.getPop().populate(data, (CubeRoom)room));
    }

    public void populate(@NotNull World world, @NotNull Random random, @NotNull Chunk chunk) {
        int[] chunkCoords;
        TerraformGeneratorPlugin.watchdogSuppressant.tickWatchdog();
        if (!TerraformGeneratorPlugin.INJECTED_WORLDS.contains(world.getName())) {
            return;
        }
        PopulatorDataPostGen data = new PopulatorDataPostGen(chunk);
        MegaChunk mc = new MegaChunk(chunk.getX(), chunk.getZ());
        BiomeBank biome = mc.getCenterBiomeSection(this.tw).getBiomeBank();
        if (TConfig.areStructuresEnabled() && new StrongholdPopulator().canSpawn(this.tw, data.getChunkX(), data.getChunkZ(), biome)) {
            TerraformGeneratorPlugin.logger.info("Generating Stronghold at chunk: " + data.getChunkX() + "," + data.getChunkZ());
            new StrongholdPopulator().populate(this.tw, data);
        }
        if ((chunkCoords = mc.getCenterBiomeSectionChunkCoords())[0] == data.getChunkX() && chunkCoords[1] == data.getChunkZ()) {
            int[] blockCoords = mc.getCenterBiomeSectionBlockCoords();
            for (SingleMegaChunkStructurePopulator spop : StructureRegistry.getLargeStructureForMegaChunk(this.tw, mc)) {
                if (spop == null || !spop.isEnabled() || spop instanceof StrongholdPopulator || !TConfig.areStructuresEnabled() || !spop.canSpawn(this.tw, data.getChunkX(), data.getChunkZ(), biome)) continue;
                TerraformGeneratorPlugin.logger.info("Generating " + spop.getClass().getName() + " at chunk: " + data.getChunkX() + "," + data.getChunkZ());
                Bukkit.getPluginManager().callEvent((Event)new TerraformStructureSpawnEvent(blockCoords[0], blockCoords[1], spop.getClass().getName()));
                spop.populate(this.tw, data);
                break;
            }
        }
    }

    @Nullable
    public SingleMegaChunkStructurePopulator getMegachunkStructure(@NotNull MegaChunk mc, @NotNull TerraformWorld tw, BiomeBank biome) {
        int[] chunkCoords = mc.getCenterBiomeSectionChunkCoords();
        for (SingleMegaChunkStructurePopulator spop : StructureRegistry.getLargeStructureForMegaChunk(tw, mc)) {
            if (spop == null || !spop.isEnabled() || spop instanceof StrongholdPopulator || !TConfig.areStructuresEnabled() || !spop.canSpawn(tw, chunkCoords[0], chunkCoords[1], biome)) continue;
            return spop;
        }
        return null;
    }
}

