/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.populators;

import java.util.Random;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;
import org.jetbrains.annotations.NotNull;
import org.terraform.biome.BiomeBank;
import org.terraform.coregen.bukkit.TerraformGenerator;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.TerraformWorld;
import org.terraform.main.config.TConfig;
import org.terraform.utils.GenUtils;

public class AnimalPopulator {
    private final EntityType animalType;
    private final int chance;
    private final int minNum;
    private final int maxNum;
    private BiomeBank[] whitelistedBiomes;
    private BiomeBank[] blacklistedBiomes;
    private boolean isAquatic = false;

    public AnimalPopulator(EntityType animalType, int minNum, int maxNum, int chance, boolean useWhitelist, BiomeBank ... biomes) {
        this.animalType = animalType;
        this.chance = chance;
        if (useWhitelist) {
            this.whitelistedBiomes = biomes;
        } else {
            this.blacklistedBiomes = biomes;
        }
        this.minNum = minNum;
        this.maxNum = maxNum;
    }

    public boolean canSpawn(@NotNull Random rand) {
        return TConfig.areAnimalsEnabled() && !GenUtils.chance(rand, 100 - this.chance, 100);
    }

    private boolean canSpawnInBiome(BiomeBank b2) {
        if (!TConfig.areAnimalsEnabled()) {
            return false;
        }
        if (this.whitelistedBiomes != null) {
            for (BiomeBank entr : this.whitelistedBiomes) {
                if (entr != b2) continue;
                return true;
            }
            return false;
        }
        if (this.blacklistedBiomes != null) {
            for (BiomeBank entr : this.blacklistedBiomes) {
                if (entr != b2) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void populate(@NotNull TerraformWorld world, @NotNull Random random, @NotNull PopulatorDataAbstract data) {
        if (!TConfig.areAnimalsEnabled()) {
            return;
        }
        for (int i = 0; i < GenUtils.randInt(random, this.minNum, this.maxNum); ++i) {
            int z;
            int height;
            int x = (data.getChunkX() << 4) + GenUtils.randInt(random, 5, 7);
            if (data.getType(x, height = GenUtils.getTransformedHeight(world, x, z = (data.getChunkZ() << 4) + GenUtils.randInt(random, 5, 7)) + 1, z).isSolid()) {
                height = GenUtils.getHighestGround(data, x, z) + 1;
            }
            if (!this.canSpawnInBiome(world.getBiomeBank(x, z))) continue;
            if (!this.isAquatic && height > TerraformGenerator.seaLevel) {
                if (data.getType(x, height, z).isSolid()) continue;
                data.addEntity(x, height, z, this.animalType);
                continue;
            }
            if (!this.isAquatic || height > TerraformGenerator.seaLevel || data.getType(x, height, z) != Material.WATER) continue;
            data.addEntity(x, height, z, this.animalType);
        }
    }

    @NotNull
    public AnimalPopulator setAquatic(boolean aquatic) {
        this.isAquatic = aquatic;
        return this;
    }
}

