/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.terraform.biome.BiomeBank;
import org.terraform.data.MegaChunk;
import org.terraform.data.TerraformWorld;
import org.terraform.main.config.TConfig;
import org.terraform.structure.MultiMegaChunkStructurePopulator;
import org.terraform.structure.SingleMegaChunkStructurePopulator;
import org.terraform.structure.StructurePopulator;
import org.terraform.structure.StructureRegistry;

public class StructureLocator {
    private static final int[] TIMEDOUT = new int[]{-7, 13};
    private static final LoadingCache<StructureLocatorKey, int[]> STRUCTURELOCATION_CACHE = CacheBuilder.newBuilder().maximumSize(300L).build((CacheLoader)new StructureLocatorCacheLoader());

    public static int[] locateMultiMegaChunkStructure(TerraformWorld tw, @NotNull MegaChunk center, @NotNull MultiMegaChunkStructurePopulator populator, int timeoutMillis) {
        int[] coords;
        if (!populator.isEnabled()) {
            return null;
        }
        StructureLocatorKey cacheKey = new StructureLocatorKey(center, tw, populator);
        if (timeoutMillis != -1 && (coords = (int[])STRUCTURELOCATION_CACHE.getIfPresent((Object)cacheKey)) != null) {
            if (coords[0] == TIMEDOUT[0] && coords[1] == TIMEDOUT[1]) {
                return null;
            }
            return coords;
        }
        long currentTimeMillis = System.currentTimeMillis();
        int blockX = -1;
        int blockZ = -1;
        int radius = 0;
        boolean found = false;
        while (!found) {
            for (MegaChunk mc : StructureLocator.getSurroundingChunks(center, radius)) {
                if (timeoutMillis != -1 && System.currentTimeMillis() - currentTimeMillis > (long)timeoutMillis) {
                    STRUCTURELOCATION_CACHE.put((Object)cacheKey, (Object)TIMEDOUT);
                    break;
                }
                for (int[] coords2 : populator.getCoordsFromMegaChunk(tw, mc)) {
                    if (coords2 == null || !TConfig.areStructuresEnabled() || !populator.canSpawn(tw, coords2[0] >> 4, coords2[1] >> 4)) continue;
                    found = true;
                    blockX = coords2[0];
                    blockZ = coords2[1];
                    break;
                }
                if (!found) continue;
                break;
            }
            ++radius;
        }
        STRUCTURELOCATION_CACHE.put((Object)cacheKey, (Object)new int[]{blockX, blockZ});
        return new int[]{blockX, blockZ};
    }

    public static int[] locateSingleMegaChunkStructure(@NotNull TerraformWorld tw, int rawX, int rawZ, @NotNull SingleMegaChunkStructurePopulator populator, int timeoutMillis) {
        MegaChunk center = new MegaChunk(rawX, 0, rawZ);
        return StructureLocator.locateSingleMegaChunkStructure(tw, center, populator, timeoutMillis);
    }

    public static int[] locateSingleMegaChunkStructure(@NotNull TerraformWorld tw, @NotNull MegaChunk center, @NotNull SingleMegaChunkStructurePopulator populator, int timeoutMillis) {
        int[] coords;
        if (!populator.isEnabled()) {
            return null;
        }
        StructureLocatorKey cacheKey = new StructureLocatorKey(center, tw, populator);
        if (timeoutMillis != -1 && (coords = (int[])STRUCTURELOCATION_CACHE.getIfPresent((Object)cacheKey)) != null) {
            if (coords[0] == TIMEDOUT[0] && coords[1] == TIMEDOUT[1]) {
                return null;
            }
            return coords;
        }
        long currentTimeMillis = System.currentTimeMillis();
        MegaChunk lowerBound = null;
        MegaChunk upperBound = null;
        int blockX = -1;
        int blockZ = -1;
        int radius = 0;
        boolean found = false;
        while (!found) {
            for (MegaChunk mc : StructureLocator.getSurroundingChunks(center, radius)) {
                int[] coords2;
                if (timeoutMillis != -1 && System.currentTimeMillis() - currentTimeMillis > (long)timeoutMillis) {
                    STRUCTURELOCATION_CACHE.put((Object)cacheKey, (Object)TIMEDOUT);
                    break;
                }
                if (lowerBound == null) {
                    lowerBound = mc;
                }
                if (upperBound == null) {
                    upperBound = mc;
                }
                if (mc.getX() < lowerBound.getX() || mc.getZ() < lowerBound.getZ()) {
                    lowerBound = mc;
                }
                if (mc.getX() > upperBound.getX() || mc.getZ() > upperBound.getZ()) {
                    upperBound = mc;
                }
                if ((coords2 = mc.getCenterBiomeSectionBlockCoords()) == null) continue;
                BiomeBank biome = mc.getCenterBiomeSection(tw).getBiomeBank();
                if (!TConfig.areStructuresEnabled() || !populator.canSpawn(tw, coords2[0] >> 4, coords2[1] >> 4, biome)) continue;
                for (SingleMegaChunkStructurePopulator availablePops : StructureRegistry.getLargeStructureForMegaChunk(tw, mc)) {
                    if (availablePops == null || !TConfig.areStructuresEnabled() || !availablePops.canSpawn(tw, coords2[0] >> 4, coords2[1] >> 4, biome)) continue;
                    if (!availablePops.getClass().equals(populator.getClass())) break;
                    found = true;
                    blockX = coords2[0];
                    blockZ = coords2[1];
                    break;
                }
                if (!found) continue;
                break;
            }
            ++radius;
        }
        STRUCTURELOCATION_CACHE.put((Object)cacheKey, (Object)new int[]{blockX, blockZ});
        return new int[]{blockX, blockZ};
    }

    @NotNull
    private static Collection<MegaChunk> getSurroundingChunks(@NotNull MegaChunk center, int radius) {
        if (radius == 0) {
            return List.of(center);
        }
        ArrayList<MegaChunk> candidates = new ArrayList<MegaChunk>();
        for (int rx : new int[]{-radius, radius}) {
            for (int rz = -radius; rz <= radius; ++rz) {
                candidates.add(center.getRelative(rx, rz));
            }
        }
        for (int rz : new int[]{-radius, radius}) {
            for (int rx = 1 - radius; rx <= radius - 1; ++rx) {
                candidates.add(center.getRelative(rx, rz));
            }
        }
        return candidates;
    }

    private static class StructureLocatorKey {
        private final MegaChunk mc;
        private final TerraformWorld tw;
        private final StructurePopulator pop;

        public StructureLocatorKey(MegaChunk mc, TerraformWorld tw, StructurePopulator pop) {
            this.mc = mc;
            this.tw = tw;
            this.pop = pop;
        }

        public boolean equals(Object obj) {
            if (obj instanceof StructureLocatorKey) {
                StructureLocatorKey other = (StructureLocatorKey)obj;
                if (other.mc.equals(this.mc) && other.tw.getName().equals(this.tw.getName())) {
                    return this.pop.getClass().isInstance(other.pop);
                }
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.mc, this.tw, this.pop.getClass());
        }
    }

    public static class StructureLocatorCacheLoader
    extends CacheLoader<StructureLocatorKey, int[]> {
        public int @NotNull [] load(@NotNull StructureLocatorKey key) {
            return null;
        }
    }
}

