/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.ancientcity;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.coregen.populatordata.PopulatorDataICABiomeWriterAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.SimpleLocation;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.structure.room.CubeRoom;
import org.terraform.structure.room.carver.RoomCarver;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;
import org.terraform.utils.noise.FastNoise;
import org.terraform.utils.noise.NoiseCacheHandler;
import org.terraform.utils.version.V_1_19;

public class AncientCityBFSCarver
extends RoomCarver {
    private static final int PADDING = 7;
    private final SimpleLocation generatorCenter;

    public AncientCityBFSCarver(SimpleLocation generatorCenter) {
        this.generatorCenter = generatorCenter;
    }

    @Override
    public void carveRoom(PopulatorDataAbstract data, CubeRoom room, Material ... wallMaterial) {
        Random rand = data.getTerraformWorld().getHashedRand(room.getX(), room.getY(), room.getZ());
        PopulatorDataICABiomeWriterAbstract ica = (PopulatorDataICABiomeWriterAbstract)TerraformGeneratorPlugin.injector.getICAData(data);
        assert (ica != null);
        FastNoise circleNoise = NoiseCacheHandler.getNoise(data.getTerraformWorld(), NoiseCacheHandler.NoiseCacheEntry.STRUCTURE_ANCIENTCITY_HOLE, world -> {
            FastNoise n = new FastNoise((int)(world.getSeed() ^ 0xDC150FL));
            n.SetNoiseType(FastNoise.NoiseType.Simplex);
            n.SetFrequency(0.02f);
            return n;
        });
        SimpleBlock chunkCent = room.getCenterSimpleBlock(data);
        SimpleBlock bfsStart = null;
        for (int nx = -7; nx < 23; ++nx) {
            block1: for (int nz = -7; nz < 23; ++nz) {
                for (int ny = -40; ny <= 40; ++ny) {
                    SimpleBlock rel = new SimpleBlock(data, chunkCent.getChunkX() * 16 + nx, chunkCent.getY() + ny, chunkCent.getChunkZ() * 16 + nz);
                    if (this.rollCriteria(circleNoise, rel)) continue;
                    bfsStart = rel;
                    continue block1;
                }
            }
        }
        if (bfsStart == null) {
            return;
        }
        HashSet<SimpleLocation> seen = new HashSet<SimpleLocation>();
        LinkedList<SimpleBlock> bfsQueue = new LinkedList<SimpleBlock>();
        bfsQueue.add(bfsStart);
        seen.add(bfsStart.getLoc());
        while (!bfsQueue.isEmpty()) {
            SimpleBlock target = (SimpleBlock)bfsQueue.remove();
            ica.setBiome(target.getX(), target.getY(), target.getZ(), V_1_19.DEEP_DARK);
            boolean hasCorner = false;
            for (BlockFace face : BlockUtils.sixBlockFaces) {
                SimpleBlock rel = target.getRelative(face);
                if (seen.contains(rel.getLoc()) || rel.getX() < chunkCent.getChunkX() * 16 - 7 || rel.getX() > chunkCent.getChunkX() * 16 + 16 + 7 || rel.getZ() < chunkCent.getChunkZ() * 16 - 7 || rel.getZ() > chunkCent.getChunkZ() * 16 + 16 + 7) continue;
                if (this.rollCriteria(circleNoise, rel)) {
                    hasCorner = true;
                    if (face != BlockFace.DOWN || target.getUp().isSolid() || !target.isSolid()) continue;
                    if (GenUtils.chance(rand, 1, 230)) {
                        assert (V_1_19.SCULK_CATALYST != null);
                        target.getUp().setType(V_1_19.SCULK_CATALYST);
                        continue;
                    }
                    if (GenUtils.chance(rand, 1, 150)) {
                        assert (V_1_19.SCULK_SENSOR != null);
                        target.getUp().setType(V_1_19.SCULK_SENSOR);
                        continue;
                    }
                    if (!GenUtils.chance(rand, 1, 600)) continue;
                    target.getUp().setBlockData(V_1_19.getActiveSculkShrieker());
                    continue;
                }
                seen.add(rel.getLoc());
                bfsQueue.add(rel);
            }
            if (BlockUtils.isWet(target) || target.getType() == Material.LAVA || hasCorner && target.isSolid()) {
                assert (V_1_19.SCULK != null);
                target.setType(V_1_19.SCULK);
                continue;
            }
            if (!BlockUtils.caveCarveReplace.contains(target.getType())) continue;
            target.setType(Material.CAVE_AIR);
        }
    }

    boolean rollCriteria(FastNoise circleNoise, SimpleBlock rel) {
        float noiseVal;
        double equationResult = Math.pow(rel.getX() - this.generatorCenter.getX(), 2.0) / Math.pow(50.0, 2.0) + Math.pow(rel.getZ() - this.generatorCenter.getZ(), 2.0) / Math.pow(50.0, 2.0) + Math.pow(rel.getY() - this.generatorCenter.getY() - 20, 2.0) / Math.pow(40.0, 2.0);
        return equationResult > 1.7 + 0.7 * (double)(noiseVal = circleNoise.GetNoise(rel.getX(), rel.getY(), rel.getZ()));
    }
}

