/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.ancientcity;

import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Candle;
import org.jetbrains.annotations.NotNull;
import org.terraform.coregen.TerraLootTable;
import org.terraform.data.SimpleBlock;
import org.terraform.schematic.SchematicParser;
import org.terraform.utils.GenUtils;

public class AncientCitySchematicParser
extends SchematicParser {
    @Override
    public void applyData(@NotNull SimpleBlock block, @NotNull BlockData data) {
        Random rand = new Random();
        if (data.getMaterial() == Material.DEEPSLATE_TILES) {
            if (rand.nextBoolean()) {
                data = Bukkit.createBlockData((Material)Material.CRACKED_DEEPSLATE_TILES);
            }
        } else if (data.getMaterial() == Material.DEEPSLATE_BRICKS) {
            if (rand.nextBoolean()) {
                data = Bukkit.createBlockData((Material)Material.CRACKED_DEEPSLATE_BRICKS);
            }
        } else if (data.getMaterial() == Material.DARK_OAK_PLANKS || data.getMaterial() == Material.DARK_OAK_SLAB) {
            if (rand.nextBoolean()) {
                data = Bukkit.createBlockData((Material)Material.AIR);
            }
        } else if (data.getMaterial() == Material.CANDLE) {
            Candle candle = (Candle)Bukkit.createBlockData((Material)Material.CANDLE);
            candle.setLit(true);
            candle.setCandles(1 + rand.nextInt(4));
            data = candle;
        } else if (data.getMaterial() == Material.CHEST) {
            if (GenUtils.chance(rand, 2, 5)) {
                block.setType(Material.AIR);
                return;
            }
            super.applyData(block, data);
            block.getPopData().lootTableChest(block.getX(), block.getY(), block.getZ(), TerraLootTable.ANCIENT_CITY);
            return;
        }
        super.applyData(block, data);
    }
}

