/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.monument;

import java.util.Map;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Stairs;
import org.jetbrains.annotations.NotNull;
import org.terraform.coregen.bukkit.TerraformGenerator;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.Wall;
import org.terraform.structure.monument.MonumentDesign;
import org.terraform.structure.monument.MonumentPopulator;
import org.terraform.structure.monument.MonumentWallPattern;
import org.terraform.structure.room.CubeRoom;
import org.terraform.structure.room.RoomPopulatorAbstract;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;

public class MonumentRoomPopulator
extends RoomPopulatorAbstract {
    final MonumentDesign design;

    public MonumentRoomPopulator(Random rand, MonumentDesign design, boolean forceSpawn, boolean unique) {
        super(rand, forceSpawn, unique);
        this.design = design;
    }

    protected static void setThickPillar(@NotNull Random rand, @NotNull MonumentDesign design, @NotNull SimpleBlock base) {
        Wall w = new Wall(base, BlockFace.NORTH);
        w.downUntilSolid(rand, Material.PRISMARINE);
        block8: for (BlockFace face : BlockUtils.directBlockFaces) {
            switch (design) {
                case DARK_LIGHTLESS: {
                    w.getRelative(face).downUntilSolid(rand, Material.PRISMARINE_BRICKS);
                    continue block8;
                }
                case DARK_PRISMARINE_CORNERS: 
                case PRISMARINE_LANTERNS: {
                    w.getRelative(face).downUntilSolid(rand, Material.PRISMARINE_BRICKS, Material.SEA_LANTERN);
                }
            }
        }
        block9: for (BlockFace face : BlockUtils.xzDiagonalPlaneBlockFaces) {
            switch (design) {
                case DARK_LIGHTLESS: 
                case DARK_PRISMARINE_CORNERS: {
                    w.getRelative(face).downUntilSolid(rand, Material.DARK_PRISMARINE);
                    continue block9;
                }
                case PRISMARINE_LANTERNS: {
                    w.getRelative(face).downUntilSolid(rand, Material.PRISMARINE_BRICKS);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void populate(@NotNull PopulatorDataAbstract data, @NotNull CubeRoom room) {
        void var5_6;
        int[] upperBounds = room.getUpperCorner();
        int[] lowerBounds = room.getLowerCorner();
        int n = lowerBounds[0] + 1;
        while (var5_6 <= upperBounds[0] - 1) {
            for (int z = lowerBounds[1] + 1; z <= upperBounds[1] - 1; ++z) {
                for (int y = room.getY() + 1; y < room.getY() + room.getHeight(); ++y) {
                    data.setType((int)var5_6, y, z, Material.WATER);
                }
            }
            ++var5_6;
        }
        if (room.getHeight() < 7) {
            return;
        }
        for (int[] corner : room.getAllCorners()) {
            for (int i = 1; i < room.getHeight(); ++i) {
                if (!data.getType(corner[0], i + room.getY(), corner[1]).isSolid()) continue;
                data.setType(corner[0], i + room.getY(), corner[1], Material.DARK_PRISMARINE);
            }
        }
        for (Map.Entry<Wall, Integer> walls : room.getFourWalls(data, 0).entrySet()) {
            Wall w = walls.getKey().getRelative(0, room.getHeight() - 1, 0);
            int length = walls.getValue();
            for (int j = 0; j < length; ++j) {
                if (!w.getUp().isSolid()) {
                    Stairs stair = (Stairs)Bukkit.createBlockData((Material)this.design.stairs());
                    stair.setFacing(w.getDirection());
                    if (w.get().getY() < TerraformGenerator.seaLevel) {
                        stair.setWaterlogged(true);
                    }
                    w.setBlockData((BlockData)stair);
                }
                if (j == length / 2 && room.getHeight() >= 16 && room.getWidthX() >= 10 && room.getWidthZ() >= 10) {
                    MonumentWallPattern.values()[this.rand.nextInt(MonumentWallPattern.values().length)].apply(w.getDown(4));
                }
                w = w.getLeft();
            }
        }
        for (int[] corner : room.getAllCorners()) {
            if (data.getType(corner[0], room.getY() + room.getHeight() + 1, corner[1]).isSolid()) continue;
            data.setType(corner[0], room.getY() + room.getHeight(), corner[1], Material.SEA_LANTERN);
        }
        if (!data.getType(room.getX(), room.getY() + room.getHeight() + 1, room.getZ()).isSolid()) {
            int n2 = GenUtils.randInt(1, 3);
            if (n2 == 1) {
                for (int[] pos : room.getAllCorners(1)) {
                    int x2 = pos[0];
                    int z = pos[1];
                    this.design.spire(new Wall(new SimpleBlock(data, x2, room.getY() + room.getHeight() + 1, z), BlockFace.NORTH), this.rand);
                }
                MonumentPopulator.arch(new Wall(new SimpleBlock(data, room.getX(), room.getY() + room.getHeight(), room.getZ()), BlockFace.NORTH), this.design, this.rand, (room.getWidthX() - 4) / 2, 6);
                MonumentPopulator.arch(new Wall(new SimpleBlock(data, room.getX(), room.getY() + room.getHeight(), room.getZ()), BlockFace.EAST), this.design, this.rand, (room.getWidthX() - 4) / 2, 6);
            } else if (n2 == 2) {
                for (Map.Entry<Wall, Integer> walls : room.getFourWalls(data, 1).entrySet()) {
                    Wall w = walls.getKey().getRelative(0, room.getHeight(), 0);
                    length = walls.getValue();
                    for (int j = 0; j < length; ++j) {
                        if (j % 2 == 0) {
                            w.RPillar(4, this.rand, Material.PRISMARINE_WALL);
                        }
                        w.getUp(4).setType(this.design.slab());
                        w = w.getLeft();
                    }
                }
                for (int x3 = lowerBounds[0] + 2; x3 <= upperBounds[0] - 2; ++x3) {
                    for (int z = lowerBounds[1] + 2; z <= upperBounds[1] - 2; ++z) {
                        data.setType(x3, room.getY() + room.getHeight() + 5, z, this.design.mat(this.rand));
                    }
                }
            } else if (n2 == 3) {
                for (Map.Entry<Wall, Integer> walls : room.getFourWalls(data, 1).entrySet()) {
                    Wall w = walls.getKey().getRelative(0, room.getHeight(), 0);
                    length = walls.getValue();
                    for (int j = 0; j < length; ++j) {
                        if (j % 2 == 0) {
                            w.setType(this.design.mat(this.rand));
                            w.getUp().setType(Material.PRISMARINE_WALL);
                            w.getUp(2).setType(this.design.slab());
                        } else {
                            w.setType(this.design.slab());
                        }
                        w = w.getLeft();
                    }
                }
                this.design.spawnLargeLight(data, room.getX(), room.getY() + room.getHeight() + 1, room.getZ());
            }
        }
        MonumentRoomPopulator.setThickPillar(this.rand, this.design, new SimpleBlock(data, lowerBounds[0] + 1, room.getY() - 1, lowerBounds[1] + 1));
        MonumentRoomPopulator.setThickPillar(this.rand, this.design, new SimpleBlock(data, upperBounds[0] - 1, room.getY() - 1, lowerBounds[1]));
        MonumentRoomPopulator.setThickPillar(this.rand, this.design, new SimpleBlock(data, upperBounds[0] - 1, room.getY() - 1, upperBounds[1] - 1));
        MonumentRoomPopulator.setThickPillar(this.rand, this.design, new SimpleBlock(data, lowerBounds[0], room.getY() - 1, upperBounds[1] - 1));
    }

    @Override
    public boolean canPopulate(CubeRoom room) {
        return true;
    }
}

