/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.stronghold;

import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Slab;
import org.jetbrains.annotations.NotNull;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.structure.room.CubeRoom;
import org.terraform.structure.room.RoomPopulatorAbstract;
import org.terraform.utils.BlockUtils;

public class StairwayRoomPopulator
extends RoomPopulatorAbstract {
    public StairwayRoomPopulator(Random rand, boolean forceSpawn, boolean unique) {
        super(rand, forceSpawn, unique);
    }

    @Override
    public void populate(@NotNull PopulatorDataAbstract data, @NotNull CubeRoom room) {
        int bfIndex = 0;
        for (int i = 1; i < room.getHeight(); ++i) {
            data.setType(room.getX(), room.getY() + i, room.getZ(), BlockUtils.stoneBrick(this.rand));
            BlockFace face = BlockUtils.xzPlaneBlockFaces[bfIndex];
            Slab bottom = (Slab)Bukkit.createBlockData((Material)BlockUtils.stoneBrickSlab(this.rand));
            bottom.setType(Slab.Type.BOTTOM);
            data.setBlockData(room.getX() + face.getModX(), room.getY() + i, room.getZ() + face.getModZ(), (BlockData)bottom);
            bfIndex = StairwayRoomPopulator.getNextIndex(bfIndex);
            face = BlockUtils.xzPlaneBlockFaces[bfIndex];
            Slab top = (Slab)Bukkit.createBlockData((Material)BlockUtils.stoneBrickSlab(this.rand));
            top.setType(Slab.Type.TOP);
            data.setBlockData(room.getX() + face.getModX(), room.getY() + i, room.getZ() + face.getModZ(), (BlockData)top);
            bfIndex = StairwayRoomPopulator.getNextIndex(bfIndex);
        }
    }

    @Override
    public boolean canPopulate(CubeRoom room) {
        return false;
    }
}

