/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.stronghold;

import java.util.ArrayList;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Chest;
import org.bukkit.block.data.type.Slab;
import org.bukkit.block.data.type.Stairs;
import org.jetbrains.annotations.NotNull;
import org.terraform.coregen.TerraLootTable;
import org.terraform.data.SimpleBlock;
import org.terraform.data.Wall;
import org.terraform.structure.room.PathPopulatorAbstract;
import org.terraform.structure.room.PathPopulatorData;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.CoralGenerator;
import org.terraform.utils.GenUtils;
import org.terraform.utils.blockdata.SlabBuilder;
import org.terraform.utils.blockdata.StairBuilder;

public class StrongholdPathPopulator
extends PathPopulatorAbstract {
    private final Random rand;

    public StrongholdPathPopulator(Random rand) {
        this.rand = rand;
    }

    @Override
    public void populate(@NotNull PathPopulatorData ppd) {
        SimpleBlock ceil = ppd.base.getUp();
        int depth = 0;
        while (!ceil.isSolid()) {
            ceil = ceil.getUp();
            if (++depth <= 10) continue;
            return;
        }
        if (ppd.dir == BlockFace.UP) {
            this.decorateCrossroads(ppd.base, Bisected.Half.BOTTOM);
            boolean isCrossroad = true;
            ArrayList<Wall> walls = new ArrayList<Wall>();
            for (Object face : BlockUtils.directBlockFaces) {
                if (!ppd.base.getRelative(face.getModX() * 2, 2, face.getModZ() * 2).isSolid()) continue;
                isCrossroad = false;
                walls.add(new Wall(ppd.base.getRelative(face.getModX() * 2, 1, face.getModZ() * 2), face.getOppositeFace()));
            }
            this.decorateCrossroads(ceil, Bisected.Half.TOP);
            if (isCrossroad) {
                for (Object face : BlockUtils.xzDiagonalPlaneBlockFaces) {
                    new Wall(ppd.base.getUp().getRelative((BlockFace)face)).LPillar(10, this.rand, Material.COBBLESTONE_WALL, Material.ANDESITE_WALL, Material.STONE_BRICK_WALL);
                }
            } else {
                for (Wall wall : walls) {
                    wall.setType(Material.STONE, Material.SMOOTH_STONE, Material.ANDESITE);
                    wall.getUp().setType(Material.CHISELED_STONE_BRICKS, Material.COBBLESTONE);
                    wall.getUp(2).setType(Material.STONE, Material.SMOOTH_STONE, Material.ANDESITE);
                    wall.getUp().getLeft().setType(Material.STONE, Material.SMOOTH_STONE, Material.ANDESITE);
                    wall.getUp().getRight().setType(Material.STONE, Material.SMOOTH_STONE, Material.ANDESITE);
                    new StairBuilder(Material.ANDESITE_STAIRS, Material.POLISHED_ANDESITE_STAIRS, Material.MOSSY_STONE_BRICK_STAIRS).setFacing(BlockUtils.getLeft(wall.getDirection())).setHalf(Bisected.Half.TOP).apply(wall.getRight());
                    new StairBuilder(Material.STONE_BRICK_STAIRS, Material.POLISHED_ANDESITE_STAIRS, Material.MOSSY_STONE_BRICK_STAIRS).setFacing(BlockUtils.getRight(wall.getDirection())).setHalf(Bisected.Half.TOP).apply(wall.getLeft());
                    new StairBuilder(Material.STONE_BRICK_STAIRS, Material.POLISHED_ANDESITE_STAIRS, Material.MOSSY_STONE_BRICK_STAIRS).setFacing(BlockUtils.getLeft(wall.getDirection())).setHalf(Bisected.Half.BOTTOM).apply(wall.getRight().getUp(2));
                    new StairBuilder(Material.STONE_BRICK_STAIRS, Material.POLISHED_ANDESITE_STAIRS, Material.MOSSY_STONE_BRICK_STAIRS).setFacing(BlockUtils.getRight(wall.getDirection())).setHalf(Bisected.Half.BOTTOM).apply(wall.getLeft().getUp(2));
                }
            }
        } else {
            if (!this.verifyPathway(new Wall(ppd.base, ppd.dir))) {
                return;
            }
            if (ppd.calcRemainder(2) == 0) {
                this.decoratePathways(ppd.base, ppd.dir);
                Wall base = new Wall(ppd.base, ppd.dir);
                base.getUp().getLeft(2).setType(Material.SMOOTH_STONE, Material.POLISHED_ANDESITE);
                base.getUp().getRight(2).setType(Material.SMOOTH_STONE, Material.POLISHED_ANDESITE);
                base.getUp(2).getLeft(2).setType(Material.CHISELED_STONE_BRICKS, Material.CHISELED_STONE_BRICKS, Material.COBBLESTONE);
                base.getUp(2).getRight(2).setType(Material.CHISELED_STONE_BRICKS, Material.CHISELED_STONE_BRICKS, Material.COBBLESTONE);
                base.getUp(3).getLeft(2).setType(Material.SMOOTH_STONE, Material.POLISHED_ANDESITE);
                base.getUp(4).getRight(2).setType(Material.SMOOTH_STONE, Material.POLISHED_ANDESITE);
                new StairBuilder(Material.STONE_BRICK_STAIRS, Material.COBBLESTONE_STAIRS, Material.MOSSY_STONE_BRICK_STAIRS, Material.ANDESITE_STAIRS).setFacing(BlockUtils.getLeft(ppd.dir)).setHalf(Bisected.Half.TOP).apply(base.getUp(4).getLeft());
                new StairBuilder(Material.STONE_BRICK_STAIRS, Material.COBBLESTONE_STAIRS, Material.MOSSY_STONE_BRICK_STAIRS, Material.ANDESITE_STAIRS).setFacing(BlockUtils.getRight(ppd.dir)).setHalf(Bisected.Half.TOP).apply(base.getUp(4).getRight());
                ceil.setType(Material.CHISELED_STONE_BRICKS);
            } else {
                Wall base = new Wall(ppd.base, ppd.dir);
                new SlabBuilder(BlockUtils.stoneBrickSlabs).setType(Slab.Type.TOP).apply(base.getUp(4).getLeft());
                new SlabBuilder(BlockUtils.stoneBrickSlabs).setType(Slab.Type.TOP).apply(base.getUp(4).getRight());
                if (GenUtils.chance(this.rand, 1, 50)) {
                    int i = GenUtils.randInt(this.rand, 0, 1);
                    Wall w = base.getUp();
                    for (depth = 0; !w.get().isSolid() && depth < 10; ++depth) {
                        if (i == 0) {
                            w = w.getLeft();
                        }
                        if (i != 1) continue;
                        w = w.getRight();
                    }
                    if (i == 1) {
                        w = w.getLeft();
                    }
                    if (i == 0) {
                        w = w.getRight();
                    }
                    SimpleBlock cBlock = w.get();
                    cBlock.setType(Material.CHEST);
                    Chest chest = (Chest)Bukkit.createBlockData((Material)Material.CHEST);
                    if (i == 0) {
                        chest.setFacing(BlockUtils.getAdjacentFaces(ppd.dir)[1]);
                    }
                    if (i == 1) {
                        chest.setFacing(BlockUtils.getAdjacentFaces(ppd.dir)[0]);
                    }
                    cBlock.setBlockData((BlockData)chest);
                    cBlock.getPopData().lootTableChest(cBlock.getX(), cBlock.getY(), cBlock.getZ(), TerraLootTable.STRONGHOLD_CORRIDOR);
                } else if (GenUtils.chance(this.rand, 4, 25)) {
                    this.setIronBars(ppd);
                }
            }
        }
        ceil = new Wall(ppd.base.getUp(), ppd.dir).findCeiling(10).get();
        if (GenUtils.chance(this.rand, 3, 25)) {
            for (int i = 0; i < GenUtils.randInt(this.rand, 1, 5); ++i) {
                this.dropDownBlock(ceil.getRelative(GenUtils.randInt(this.rand, -1, 1), 0, GenUtils.randInt(this.rand, -1, 1)));
            }
        }
        if (GenUtils.chance(this.rand, 1, 25)) {
            SimpleBlock webBase = ceil.getDown();
            webBase.setType(Material.COBWEB);
            for (int i = 0; i < GenUtils.randInt(this.rand, 0, 3); ++i) {
                BlockFace face = CoralGenerator.getRandomBlockFace();
                if (face == BlockFace.UP) {
                    face = BlockFace.SELF;
                }
                webBase.getRelative(face).setType(Material.COBWEB);
            }
        }
    }

    private boolean verifyPathway(@NotNull Wall base) {
        for (int h2 = 0; h2 <= 5; ++h2) {
            for (int width = -2; width <= 2; ++width) {
                Wall rel = base.getRelative(0, h2, 0);
                if (h2 == 0 || h2 == 5 || width == -2 || width == 2) {
                    if (!rel.getLeft(width).isSolid()) {
                        return false;
                    }
                    if (rel.getRight(width).isSolid()) continue;
                    return false;
                }
                if (rel.getLeft(width).isSolid()) {
                    return false;
                }
                if (!rel.getRight(width).isSolid()) continue;
                return false;
            }
        }
        return true;
    }

    private void decorateCrossroads(@NotNull SimpleBlock core, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Bisected.Half isCeil) {
        core.RSolSetType(Material.CHISELED_STONE_BRICKS);
        for (BlockFace face : BlockUtils.directBlockFaces) {
            core.getRelative(face).RSolSetBlockData((BlockData)new StairBuilder(Material.STONE_BRICK_STAIRS, Material.COBBLESTONE_STAIRS, Material.MOSSY_STONE_BRICK_STAIRS, Material.ANDESITE_STAIRS).setFacing(face).setHalf(isCeil).get());
        }
    }

    private void decoratePathways(@NotNull SimpleBlock core, @NotNull BlockFace dir) {
        core.RSolSetType(Material.CHISELED_STONE_BRICKS);
        for (BlockFace face : BlockUtils.getAdjacentFaces(dir)) {
            core.getRelative(face).RSolSetBlockData((BlockData)new StairBuilder(Material.STONE_BRICK_STAIRS, Material.COBBLESTONE_STAIRS, Material.MOSSY_STONE_BRICK_STAIRS, Material.ANDESITE_STAIRS).setFacing(face).setHalf(Bisected.Half.BOTTOM).get());
        }
    }

    private void setIronBars(@NotNull PathPopulatorData ppd) {
        Wall wall = new Wall(ppd.base, ppd.dir).getUp(4);
        wall.setType(Material.IRON_BARS);
        wall.getLeft().setType(Material.IRON_BARS);
        wall.getRight().setType(Material.IRON_BARS);
        wall.getLeft().downRPillar(new Random(), 4, Material.IRON_BARS);
        wall.getRight().downRPillar(new Random(), 4, Material.IRON_BARS);
        for (int h2 = 3; h2 >= 0; --h2) {
            Wall temp = wall.getRelative(0, -h2, 0);
            BlockUtils.correctSurroundingMultifacingData(temp.get());
            BlockUtils.correctSurroundingMultifacingData(temp.getLeft().get());
            BlockUtils.correctSurroundingMultifacingData(temp.getRight().get());
        }
    }

    private void dropDownBlock(@NotNull SimpleBlock block) {
        if (block.isSolid()) {
            BlockData type = block.getBlockData();
            block.setType(Material.CAVE_AIR);
            int depth = 0;
            while (!block.isSolid()) {
                block = block.getDown();
                if (++depth <= 50) continue;
                return;
            }
            if (type instanceof Slab) {
                ((Slab)type).setType(Slab.Type.BOTTOM);
            } else if (type instanceof Stairs) {
                ((Stairs)type).setHalf(Bisected.Half.BOTTOM);
            }
            if (GenUtils.chance(1, 3)) {
                block.getUp().setBlockData(BlockUtils.infestStone(type));
            } else {
                block.getUp().setBlockData(type);
            }
        }
    }
}

