/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.village;

import java.util.Random;
import org.jetbrains.annotations.NotNull;
import org.terraform.biome.BiomeBank;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.TerraformWorld;
import org.terraform.main.config.TConfig;
import org.terraform.structure.SingleMegaChunkStructurePopulator;
import org.terraform.structure.village.plains.PlainsVillagePopulator;
import org.terraform.utils.GenUtils;

public class VillagePopulator
extends SingleMegaChunkStructurePopulator {
    @Override
    @NotNull
    public Random getHashedRandom(@NotNull TerraformWorld tw, int chunkX, int chunkZ) {
        return tw.getHashedRand(11111199L, chunkX, chunkZ);
    }

    private boolean rollSpawnRatio(@NotNull TerraformWorld tw, int chunkX, int chunkZ) {
        return GenUtils.chance(tw.getHashedRand(chunkX, chunkZ, 12422), (int)(TConfig.c.STRUCTURES_VILLAGE_SPAWNRATIO * 10000.0), 10000);
    }

    @Override
    public boolean canSpawn(@NotNull TerraformWorld tw, int chunkX, int chunkZ, BiomeBank biome) {
        if (!this.isEnabled()) {
            return false;
        }
        if (biome == BiomeBank.PLAINS || biome == BiomeBank.FOREST || biome == BiomeBank.SAVANNA || biome == BiomeBank.TAIGA || biome == BiomeBank.SCARLET_FOREST || biome == BiomeBank.CHERRY_GROVE) {
            return this.rollSpawnRatio(tw, chunkX, chunkZ);
        }
        return false;
    }

    @Override
    public void populate(@NotNull TerraformWorld tw, @NotNull PopulatorDataAbstract data) {
        if (!this.isEnabled()) {
            return;
        }
        new PlainsVillagePopulator().populate(tw, data);
    }

    @Override
    public int getChunkBufferDistance() {
        return TConfig.c.STRUCTURES_VILLAGE_CHUNK_EXCLUSION_ZONE;
    }

    @Override
    public boolean isEnabled() {
        return TConfig.areStructuresEnabled() && (BiomeBank.isBiomeEnabled(BiomeBank.PLAINS) || BiomeBank.isBiomeEnabled(BiomeBank.FOREST) || BiomeBank.isBiomeEnabled(BiomeBank.SAVANNA) || BiomeBank.isBiomeEnabled(BiomeBank.TAIGA) || BiomeBank.isBiomeEnabled(BiomeBank.SCARLET_FOREST) || BiomeBank.isBiomeEnabled(BiomeBank.CHERRY_GROVE)) && TConfig.c.STRUCTURES_PLAINSVILLAGE_ENABLED;
    }
}

