/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.village.plains;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.type.Slab;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.terraform.coregen.bukkit.TerraformGenerator;
import org.terraform.data.SimpleBlock;
import org.terraform.data.SimpleLocation;
import org.terraform.data.Wall;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.structure.room.CubeRoom;
import org.terraform.structure.room.PathPopulatorAbstract;
import org.terraform.structure.room.PathPopulatorData;
import org.terraform.structure.room.RoomPopulatorAbstract;
import org.terraform.structure.village.plains.DirectionalCubeRoom;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;
import org.terraform.utils.blockdata.SlabBuilder;

public class PlainsPathRecursiveSpawner {
    private static final int minPathLength = 25;
    private static final int maxPathLength = 35;
    private final int range;
    private final ArrayList<RoomPopulatorAbstract> validRooms = new ArrayList();
    @NotNull
    private final SimpleBlock core;
    private final HashMap<SimpleLocation, DirectionalCubeRoom> rooms = new HashMap();
    private final HashMap<SimpleLocation, BlockFace> path = new HashMap();
    private final HashMap<SimpleLocation, CrossRoad> crossRoads = new HashMap();
    private int minRoomWidth = 15;
    private int maxRoomWidth = 20;
    private double villageDensity = 1.0;
    private PathPopulatorAbstract pathPop;

    public PlainsPathRecursiveSpawner(@NotNull SimpleBlock core, int range, BlockFace ... faces) {
        SimpleLocation start = new SimpleLocation(core.getX(), 0, core.getZ());
        this.crossRoads.put(start, new CrossRoad(start, faces));
        this.range = range;
        this.core = core;
    }

    private void advanceCrossRoad(@NotNull Random random, @NotNull CrossRoad target, @NotNull BlockFace direction) {
        target.satisfiedFaces.add(direction);
        boolean cull = false;
        SimpleLocation loc = new SimpleLocation(target.loc).getRelative(direction);
        int lastCrossroad = 0;
        int edgeTurns = 0;
        while (!cull) {
            for (int i = 0; i < GenUtils.randInt(random, 25, 35); ++i) {
                if (this.isLocationValid(loc)) {
                    this.path.put(loc, direction);
                    if (GenUtils.chance(random, (int)(this.villageDensity * 10000.0), 10000)) {
                        BlockFace adjDir = BlockUtils.getAdjacentFaces(direction)[random.nextInt(2)];
                        SimpleLocation adj = loc.getRelative(adjDir);
                        if (this.isLocationValid(adj)) {
                            int roomWidthZ;
                            int roomWidthX;
                            DirectionalCubeRoom room;
                            BlockFace rF = adjDir.getOppositeFace();
                            int minRoomWidth = this.minRoomWidth;
                            int maxRoomWidth = this.maxRoomWidth;
                            int smallRoomChance = 10;
                            if (GenUtils.chance(random, smallRoomChance, 100)) {
                                minRoomWidth = 7;
                                maxRoomWidth = 10;
                            }
                            if (!this.registerRoom(room = new DirectionalCubeRoom(rF, roomWidthX = GenUtils.randInt(minRoomWidth, maxRoomWidth), roomWidthZ = GenUtils.randInt(minRoomWidth, maxRoomWidth), 20, loc.getX() + adjDir.getModX() * (2 + roomWidthX / 2), loc.getY(), loc.getZ() + adjDir.getModZ() * (2 + roomWidthZ / 2))) && GenUtils.chance(random, lastCrossroad, 20)) {
                                this.crossRoads.put(loc, new CrossRoad(loc, BlockUtils.getAdjacentFaces(direction)));
                                lastCrossroad = 0;
                            }
                        }
                    } else if (GenUtils.chance(random, lastCrossroad, 20)) {
                        this.crossRoads.put(loc, new CrossRoad(loc, BlockUtils.getAdjacentFaces(direction)));
                        lastCrossroad = 0;
                    }
                    loc = loc.getRelative(direction);
                    continue;
                }
                if ((double)loc.distanceSqr(this.core.getX(), this.core.getY(), this.core.getZ()) > Math.pow(this.range, 2.0)) {
                    loc = loc.getRelative(direction.getOppositeFace());
                    direction = BlockUtils.getTurnBlockFace(random, direction);
                    loc = loc.getRelative(direction);
                    if (++edgeTurns <= 3) continue;
                    cull = true;
                    continue;
                }
                cull = true;
            }
            edgeTurns = 0;
            direction = BlockUtils.getTurnBlockFace(random, direction);
            loc = loc.getRelative(direction);
        }
    }

    public void registerRoomPopulator(RoomPopulatorAbstract roomPop) {
        this.validRooms.add(roomPop);
    }

    private boolean isLocationValid(@NotNull SimpleLocation loc) {
        for (DirectionalCubeRoom room : this.rooms.values()) {
            if (!room.isPointInside(loc)) continue;
            return false;
        }
        if ((double)loc.distanceSqr(this.core.getX(), this.core.getY(), this.core.getZ()) > Math.pow(this.range, 2.0)) {
            return false;
        }
        return !this.path.containsKey(loc);
    }

    public boolean registerRoom(@NotNull DirectionalCubeRoom room) {
        if (this.core.getPopData().getType(room.getX(), GenUtils.getHighestGround(this.core.getPopData(), room.getX(), room.getZ()) + 1, room.getZ()) == Material.WATER) {
            return false;
        }
        for (DirectionalCubeRoom other : this.rooms.values()) {
            if (!other.isOverlapping(room)) continue;
            return false;
        }
        for (SimpleLocation loc : this.path.keySet()) {
            if (!room.isPointInside(loc)) continue;
            return false;
        }
        this.rooms.put(new SimpleLocation(room.getX(), 0, room.getZ()), room);
        return true;
    }

    public void forceRegisterRoom(@NotNull DirectionalCubeRoom room) {
        this.rooms.put(new SimpleLocation(room.getX(), 0, room.getZ()), room);
    }

    public void generate(@NotNull Random random) {
        while (this.getFirstUnsatisfiedCrossRoad() != null) {
            CrossRoad target = this.getFirstUnsatisfiedCrossRoad();
            BlockFace direction = target.getFirstUnsatisfiedDirection();
            this.advanceCrossRoad(random, target, direction);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void build(@NotNull Random random) {
        for (SimpleLocation loc : this.path.keySet()) {
            Wall wall2 = new Wall(new SimpleBlock(this.core.getPopData(), loc.getX(), loc.getY(), loc.getZ()), this.path.get(loc));
            wall2 = wall2.getGround();
            if (BlockUtils.isWet(wall2.getUp().get())) {
                void var4_9;
                if (BlockUtils.isWet(wall2.getAtY(TerraformGenerator.seaLevel))) {
                    Wall wall3 = wall2.getAtY(TerraformGenerator.seaLevel);
                } else {
                    Wall wall4 = wall2.getGroundOrDry().getDown();
                }
                new SlabBuilder(Material.OAK_SLAB).setWaterlogged(true).setType(Slab.Type.TOP).apply((Wall)var4_9).lapply(var4_9.getRelative(0, 0, 1)).lapply(var4_9.getRelative(0, 0, -1)).lapply(var4_9.getRelative(1, 0, 1)).lapply(var4_9.getRelative(1, 0, -1)).lapply(var4_9.getRelative(-1, 0, 1)).lapply(var4_9.getRelative(-1, 0, -1)).lapply(var4_9.getRelative(1, 0, 0)).lapply(var4_9.getRelative(-1, 0, 0));
                continue;
            }
            if (!wall2.getUp(2).isSolid() && wall2.getUp(2).getType() != Material.AIR) {
                wall2.getUp(2).setType(Material.AIR);
            }
            if (!wall2.getUp().isSolid() && wall2.getUp().getType() != Material.AIR) {
                wall2.getUp().setType(Material.AIR);
            }
            wall2.setType(Material.DIRT_PATH);
            for (BlockFace face : BlockUtils.xzPlaneBlockFaces) {
                Wall target = wall2.getRelative(face).getGround();
                if (random.nextInt(3) == 0) continue;
                if (!target.getUp(2).isSolid() && target.getUp(2).getType() != Material.AIR) {
                    target.getUp(2).setType(Material.AIR);
                }
                if (!target.getUp().isSolid() && target.getUp().getType() != Material.AIR) {
                    target.getUp().setType(Material.AIR);
                }
                target.setType(Material.DIRT_PATH);
            }
        }
        if (this.validRooms.isEmpty()) {
            return;
        }
        Iterator<RoomPopulatorAbstract> it = this.validRooms.iterator();
        block2: while (it.hasNext()) {
            RoomPopulatorAbstract pops = it.next();
            if (!pops.isForceSpawn()) continue;
            for (CubeRoom cubeRoom : this.rooms.values()) {
                if (cubeRoom.getPop() != null || !pops.canPopulate(cubeRoom)) continue;
                cubeRoom.setRoomPopulator(pops);
                if (!pops.isUnique()) continue block2;
                it.remove();
                continue block2;
            }
        }
        if (this.validRooms.isEmpty()) {
            return;
        }
        for (CubeRoom cubeRoom : this.rooms.values()) {
            if (cubeRoom.getPop() == null) {
                List list = (List)this.validRooms.clone();
                Collections.shuffle(list, random);
                for (RoomPopulatorAbstract roomPop : list) {
                    if (!roomPop.canPopulate(cubeRoom)) continue;
                    cubeRoom.setRoomPopulator(roomPop);
                    if (!roomPop.isUnique()) break;
                    this.validRooms.remove(roomPop);
                    break;
                }
            }
            if (cubeRoom.getPop() == null) continue;
            TerraformGeneratorPlugin.logger.info("Registered: " + cubeRoom.getPop().getClass().getName() + " at " + cubeRoom.getX() + " " + cubeRoom.getY() + " " + cubeRoom.getZ() + " in a room of size " + cubeRoom.getWidthX() + "x" + cubeRoom.getWidthZ());
            cubeRoom.populate(this.core.getPopData());
        }
        for (SimpleLocation simpleLocation : this.path.keySet()) {
            if (this.pathPop == null) continue;
            this.pathPop.populate(new PathPopulatorData(new SimpleBlock(this.core.getPopData(), simpleLocation.getX(), simpleLocation.getY(), simpleLocation.getZ()), this.path.get(simpleLocation), 3, false));
        }
    }

    @Nullable
    private CrossRoad getFirstUnsatisfiedCrossRoad() {
        for (CrossRoad road : this.crossRoads.values()) {
            if (road.isSatisfied()) continue;
            return road;
        }
        return null;
    }

    public int getMinRoomWidth() {
        return this.minRoomWidth;
    }

    public void setMinRoomWidth(int minRoomWidth) {
        this.minRoomWidth = minRoomWidth;
    }

    public int getMaxRoomWidth() {
        return this.maxRoomWidth;
    }

    public void setMaxRoomWidth(int maxRoomWidth) {
        this.maxRoomWidth = maxRoomWidth;
    }

    public PathPopulatorAbstract getPathPop() {
        return this.pathPop;
    }

    public void setPathPop(PathPopulatorAbstract pathPop) {
        this.pathPop = pathPop;
    }

    @NotNull
    public HashMap<SimpleLocation, DirectionalCubeRoom> getRooms() {
        return this.rooms;
    }

    public double getVillageDensity() {
        return this.villageDensity;
    }

    public void setVillageDensity(double villageDensity) {
        this.villageDensity = villageDensity;
    }

    private static class CrossRoad {
        public final SimpleLocation loc;
        public final BlockFace[] faces;
        @NotNull
        public final ArrayList<BlockFace> satisfiedFaces = new ArrayList();

        public CrossRoad(SimpleLocation loc, BlockFace[] faces) {
            this.loc = loc;
            this.faces = faces;
        }

        public boolean isSatisfied() {
            return this.getFirstUnsatisfiedDirection() == null;
        }

        @Nullable
        public BlockFace getFirstUnsatisfiedDirection() {
            for (BlockFace face : this.faces) {
                if (this.satisfiedFaces.contains(face)) continue;
                return face;
            }
            return null;
        }
    }
}

