/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.tree;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Leaves;
import org.jetbrains.annotations.NotNull;
import org.terraform.data.SimpleBlock;
import org.terraform.data.TerraformWorld;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.CoralGenerator;
import org.terraform.utils.GenUtils;
import org.terraform.utils.noise.FastNoise;
import org.terraform.utils.noise.NoiseCacheHandler;
import org.terraform.utils.version.V_1_19;
import org.terraform.utils.version.V_1_21_4;
import org.terraform.utils.version.Version;

public class FractalLeaves
implements Cloneable {
    @NotNull
    final Random rand = new Random();
    private final HashSet<SimpleBlock> occupiedLeaves = new HashSet();
    public float radiusX = 4.0f;
    public float radiusY = 2.0f;
    public int numYSegments = 5;
    public float radiusZ = 4.0f;
    public int offsetY = 0;
    public Material[] material = new Material[]{Material.OAK_LEAVES};
    int oriY;
    int maxHeight;
    TerraformWorld tw;
    boolean semiSphereLeaves = false;
    float leafNoiseMultiplier = 0.7f;
    float leafNoiseFrequency = 0.09f;
    double hollowLeaves = 0.0;
    boolean coneLeaves = false;
    boolean snowy = false;
    float weepingLeavesChance = 0.0f;
    int weepingLeavesLength = 0;
    float paleVinesChance = 0.0f;
    int paleVinesLength = 0;
    boolean coralDecoration = false;
    boolean mangrovePropagules = false;
    int unitLeafSize = 0;
    float unitLeafChance = 0.0f;

    public void purgeOccupiedLeavesCache() {
        this.occupiedLeaves.clear();
    }

    public void placeLeaves(@NotNull SimpleBlock centre) {
        this.placeLeaves(centre.getPopData().getTerraformWorld(), -999, 999, centre);
    }

    public void placeLeaves(TerraformWorld tw, int oriY, int maxHeight, @NotNull SimpleBlock centre) {
        this.tw = tw;
        this.oriY = oriY;
        this.maxHeight = maxHeight;
        FastNoise noiseGen = NoiseCacheHandler.getNoise(tw, NoiseCacheHandler.NoiseCacheEntry.FRACTALTREES_LEAVES_NOISE, world -> {
            FastNoise n = new FastNoise((int)world.getSeed());
            n.SetFractalOctaves(5);
            n.SetNoiseType(FastNoise.NoiseType.SimplexFractal);
            return n;
        });
        noiseGen.SetFrequency(this.leafNoiseFrequency);
        if (this.radiusX <= 0.0f && this.radiusY <= 0.0f && this.radiusZ <= 0.0f) {
            return;
        }
        if ((double)this.radiusX <= 0.5 && (double)this.radiusY <= 0.5 && (double)this.radiusZ <= 0.5) {
            centre.setType(this.material);
            return;
        }
        float noiseMultiplier = this.leafNoiseMultiplier;
        int minRadiusY = -Math.round(this.radiusY);
        if (this.semiSphereLeaves) {
            minRadiusY = 0;
        }
        ArrayList<SimpleBlock> changed = new ArrayList<SimpleBlock>();
        int y = minRadiusY;
        while ((float)y <= this.radiusY) {
            int x = -Math.round(this.radiusX);
            while ((float)x <= this.radiusX) {
                int z = -Math.round(this.radiusZ);
                while ((float)z <= this.radiusZ) {
                    double equationResult;
                    Material material = this.material[this.rand.nextInt(this.material.length)];
                    SimpleBlock relativeBlock = centre.getRelative(x, y + this.offsetY, z);
                    if (relativeBlock.getY() - oriY > maxHeight) {
                        return;
                    }
                    if (relativeBlock.getY() - oriY == maxHeight && this.rand.nextBoolean()) {
                        return;
                    }
                    float effectiveY = y;
                    if (this.coneLeaves) {
                        if ((effectiveY += this.radiusY / 2.0f) < 0.0f) {
                            effectiveY *= 2.0f;
                        }
                        if (effectiveY > 0.0f) {
                            effectiveY *= 0.6666667f;
                            if ((effectiveY = (float)Math.pow(effectiveY, 1.3)) > this.radiusY) {
                                effectiveY = this.radiusY;
                            }
                        }
                        relativeBlock = relativeBlock.getRelative(0, (int)(this.radiusY / 2.0f), 0);
                    }
                    if (!this.occupiedLeaves.contains(relativeBlock) && (equationResult = Math.pow(x, 2.0) / Math.pow(this.radiusX, 2.0) + Math.pow(effectiveY, 2.0) / Math.pow(this.radiusY, 2.0) + Math.pow(z, 2.0) / Math.pow(this.radiusZ, 2.0)) <= (double)(1.0f + noiseMultiplier * noiseGen.GetNoise(relativeBlock.getX(), relativeBlock.getY(), relativeBlock.getZ())) && !(equationResult < this.hollowLeaves)) {
                        this.occupiedLeaves.add(relativeBlock);
                        if (this.mangrovePropagules && Version.isAtLeast(19.0) && !BlockUtils.isWet(relativeBlock.getDown()) && GenUtils.chance(1, 50)) {
                            relativeBlock.getDown().rsetBlockData(BlockUtils.replacableByTrees, V_1_19.getHangingMangrovePropagule());
                        }
                        if (Tag.CORALS.isTagged((Keyed)material) && !changed.contains(relativeBlock)) {
                            changed.add(relativeBlock);
                        }
                        if (this.coralDecoration) {
                            CoralGenerator.generateSingleCoral(relativeBlock.getPopData(), relativeBlock.getX(), relativeBlock.getY(), relativeBlock.getZ(), this.material[0].toString());
                        }
                        if (!relativeBlock.isSolid()) {
                            this.unitSet(relativeBlock, material);
                            if (this.unitLeafSize > 0 && this.unitLeafChance > 0.0f && GenUtils.chance(this.rand, (int)(this.unitLeafChance * 100.0f), 100)) {
                                for (int scaleX = -this.unitLeafSize; scaleX < this.unitLeafSize; ++scaleX) {
                                    for (int scaleZ = -this.unitLeafSize; scaleZ < this.unitLeafSize; ++scaleZ) {
                                        for (int scaleY = -this.unitLeafSize; scaleY < this.unitLeafSize; ++scaleY) {
                                            this.unitSet(relativeBlock.getRelative(scaleX, scaleY, scaleZ), material);
                                        }
                                    }
                                }
                            }
                        }
                        if (this.snowy && !relativeBlock.getUp().isSolid()) {
                            relativeBlock.getUp().setType(Material.SNOW);
                        }
                        if (this.weepingLeavesChance > 0.0f && Math.random() < (double)this.weepingLeavesChance) {
                            this.weepingLeaves(relativeBlock, Math.round(this.weepingLeavesChance * (float)this.weepingLeavesLength), this.weepingLeavesLength);
                        }
                        if (Version.isAtLeast(21.4) && this.paleVinesChance > 0.0f && Math.random() < (double)this.paleVinesChance) {
                            this.paleVines(relativeBlock, Math.round(this.paleVinesChance * (float)this.paleVinesLength), this.paleVinesLength);
                        }
                    }
                    ++z;
                }
                ++x;
            }
            ++y;
        }
        while (!changed.isEmpty()) {
            SimpleBlock sb = (SimpleBlock)changed.remove(new Random().nextInt(changed.size()));
            if (!CoralGenerator.isSaturatedCoral(sb)) {
                for (BlockFace face : BlockUtils.directBlockFaces) {
                    if (!Tag.WALL_CORALS.isTagged((Keyed)sb.getRelative(face).getType())) continue;
                    sb.getRelative(face).setType(Material.WATER);
                }
                if (sb.getUp().getType() == Material.SEA_PICKLE || Tag.CORAL_PLANTS.isTagged((Keyed)sb.getUp().getType())) {
                    sb.getUp().setType(Material.WATER);
                }
                sb.setType(Material.WATER);
                continue;
            }
            sb.setType(this.material);
        }
    }

    private void unitSet(@NotNull SimpleBlock relativeBlock, @NotNull Material material) {
        if (Tag.LEAVES.isTagged((Keyed)material)) {
            Leaves leaf = (Leaves)Bukkit.createBlockData((Material)material);
            leaf.setDistance(1);
            relativeBlock.rsetBlockData(BlockUtils.replacableByTrees, (BlockData)leaf);
        } else {
            relativeBlock.rsetType(BlockUtils.replacableByTrees, material);
        }
    }

    private void paleVines(@NotNull SimpleBlock base, int minDist, int maxDist) {
        int lowest = 0;
        for (int i = 1; i <= GenUtils.randInt(minDist, maxDist) && BlockUtils.isAir(base.getRelative(0, -i, 0).getType()); ++i) {
            base.getRelative(0, -i, 0).rsetBlockData(BlockUtils.replacableByTrees, V_1_21_4.PALE_HANGING_MOSS);
            ++lowest;
        }
        if (lowest > 0) {
            base.getDown(lowest).setBlockData(V_1_21_4.PALE_HANGING_MOSS_TIP);
        }
    }

    private void weepingLeaves(@NotNull SimpleBlock base, int minDist, int maxDist) {
        Material material = this.material[this.rand.nextInt(this.material.length)];
        BlockData type = Bukkit.createBlockData((Material)material);
        if (Tag.LEAVES.isTagged((Keyed)material)) {
            Leaves leaf = (Leaves)type;
            leaf.setDistance(1);
        }
        for (int i = 1; i <= GenUtils.randInt(minDist, maxDist) && BlockUtils.isAir(base.getRelative(0, -i, 0).getType()); ++i) {
            base.getRelative(0, -i, 0).rsetBlockData(BlockUtils.replacableByTrees, type);
        }
    }

    @NotNull
    public FractalLeaves setMaterial(Material ... material) {
        this.material = material;
        return this;
    }

    @NotNull
    public FractalLeaves setOffsetY(int offsetY) {
        this.offsetY = offsetY;
        return this;
    }

    @NotNull
    public FractalLeaves setRadiusX(float radiusX) {
        this.radiusX = radiusX;
        return this;
    }

    @NotNull
    public FractalLeaves setRadiusY(float radiusY) {
        this.radiusY = radiusY;
        this.numYSegments = (int)Math.ceil(radiusY * 2.0f + 1.0f);
        return this;
    }

    @NotNull
    public FractalLeaves setRadiusZ(float radiusZ) {
        this.radiusZ = radiusZ;
        return this;
    }

    @NotNull
    public FractalLeaves setRadius(float radius) {
        this.radiusX = radius;
        this.setRadiusY(radius);
        this.radiusZ = radius;
        return this;
    }

    @NotNull
    public FractalLeaves setRadius(float x, float y, float z) {
        this.radiusX = x;
        this.setRadiusY(y);
        this.radiusZ = z;
        return this;
    }

    @NotNull
    public FractalLeaves setHollowLeaves(double hollow) {
        this.hollowLeaves = hollow;
        return this;
    }

    @NotNull
    public FractalLeaves setConeLeaves(boolean coneLeaves) {
        this.coneLeaves = coneLeaves;
        return this;
    }

    @NotNull
    public FractalLeaves setLeafNoiseMultiplier(float multiplier) {
        this.leafNoiseMultiplier = multiplier;
        return this;
    }

    @NotNull
    public FractalLeaves setLeafNoiseFrequency(float freq) {
        this.leafNoiseFrequency = freq;
        return this;
    }

    @NotNull
    public FractalLeaves setSnowy(boolean snowy) {
        this.snowy = snowy;
        return this;
    }

    @NotNull
    public FractalLeaves setMangrovePropagules(boolean mangrovePropagules) {
        this.mangrovePropagules = mangrovePropagules;
        return this;
    }

    @NotNull
    public FractalLeaves setPaleMossVines(float chance, int maxLength) {
        this.paleVinesChance = chance;
        this.paleVinesLength = maxLength;
        return this;
    }

    @NotNull
    public FractalLeaves setWeepingLeaves(float chance, int maxLength) {
        this.weepingLeavesChance = chance;
        this.weepingLeavesLength = maxLength;
        return this;
    }

    @NotNull
    public FractalLeaves setUnitLeafChance(float unitLeafChance) {
        this.unitLeafChance = unitLeafChance;
        return this;
    }

    @NotNull
    public FractalLeaves setUnitLeafSize(int unitSize) {
        this.unitLeafSize = unitSize;
        return this;
    }

    @NotNull
    public FractalLeaves setSemiSphereLeaves(boolean semiSphereLeaves) {
        this.semiSphereLeaves = semiSphereLeaves;
        return this;
    }

    public int getOriY() {
        return this.oriY;
    }

    public void setOriY(int oriY) {
        this.oriY = oriY;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public void setMaxHeight(int maxHeight) {
        this.maxHeight = maxHeight;
    }

    public TerraformWorld getTw() {
        return this.tw;
    }

    public void setTw(TerraformWorld tw) {
        this.tw = tw;
    }

    public FractalLeaves clone() throws CloneNotSupportedException {
        return (FractalLeaves)super.clone();
    }
}

