/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.utils;

import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.jetbrains.annotations.NotNull;
import org.terraform.data.SimpleBlock;
import org.terraform.data.Wall;
import org.terraform.main.config.TConfig;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;

public class StalactiteBuilder {
    private Material[] solidBlockType;
    private Material[] wallType;
    private boolean isFacingUp;
    private int verticalSpace;
    private float minRadius = 0.0f;

    public StalactiteBuilder(Material ... wallType) {
        this.wallType = wallType;
    }

    public void build(@NotNull Random rand, @NotNull Wall w) {
        if (!TConfig.areDecorationsEnabled()) {
            return;
        }
        if (this.verticalSpace < 6) {
            return;
        }
        int stalactiteHeight = this.verticalSpace > 60 ? GenUtils.randInt(rand, 6, 25) : (this.verticalSpace > 30 ? GenUtils.randInt(rand, 5, 17) : (this.verticalSpace > 15 ? GenUtils.randInt(rand, 3, 10) : GenUtils.randInt(rand, 1, 2)));
        if (stalactiteHeight < 4) {
            if (this.isFacingUp) {
                w.LPillar(stalactiteHeight, rand, this.wallType);
            } else {
                w.downLPillar(rand, stalactiteHeight, this.wallType);
            }
        } else if (stalactiteHeight < 7) {
            if (this.isFacingUp) {
                w.LPillar(stalactiteHeight, rand, this.wallType);
                w.Pillar(GenUtils.randInt(rand, 2, 3), rand, this.solidBlockType);
            } else {
                w.downLPillar(rand, stalactiteHeight, this.wallType);
                w.downPillar(GenUtils.randInt(rand, 2, 3), this.solidBlockType);
            }
        } else if (this.isFacingUp) {
            this.makeSpike(w.getDown(), GenUtils.randDouble(rand, (double)stalactiteHeight / 6.0, (double)stalactiteHeight / 4.0), stalactiteHeight, true);
        } else {
            this.makeSpike(w.getUp(), GenUtils.randDouble(rand, (double)stalactiteHeight / 6.0, (double)stalactiteHeight / 4.0), stalactiteHeight, false);
        }
    }

    @NotNull
    public StalactiteBuilder setSolidBlockType(Material ... solidBlockType) {
        this.solidBlockType = solidBlockType;
        return this;
    }

    @NotNull
    public StalactiteBuilder setWallType(Material ... wallType) {
        this.wallType = wallType;
        return this;
    }

    @NotNull
    public StalactiteBuilder setFacingUp(boolean isFacingUp) {
        this.isFacingUp = isFacingUp;
        return this;
    }

    @NotNull
    public StalactiteBuilder setMinRadius(int minRadius) {
        this.minRadius = minRadius;
        return this;
    }

    @NotNull
    public StalactiteBuilder setVerticalSpace(int verticalSpace) {
        this.verticalSpace = verticalSpace;
        return this;
    }

    public void makeSpike(@NotNull SimpleBlock root, double baseRadius, int height, boolean facingUp) {
        if (height < 8) {
            return;
        }
        float maxRadius = 3.0f;
        baseRadius = Math.min((double)maxRadius, Math.max(baseRadius, (double)this.minRadius));
        ArrayDeque<SimpleBlock> queue = new ArrayDeque<SimpleBlock>((int)(Math.PI * Math.pow(baseRadius, 2.0) * ((double)height / 2.5)));
        queue.add(root);
        HashSet<SimpleBlock> seen = new HashSet<SimpleBlock>();
        seen.add(root);
        while (!queue.isEmpty()) {
            SimpleBlock v = (SimpleBlock)queue.remove();
            v.setType(this.solidBlockType);
            for (BlockFace rel : BlockUtils.sixBlockFaces) {
                double coneEqn;
                SimpleBlock neighbour = v.getRelative(rel);
                if (seen.contains(neighbour)) continue;
                int yOffset = neighbour.getY() - root.getY();
                if (facingUp && (yOffset > height || yOffset < 0) || !facingUp && (yOffset < -height || yOffset > 0)) continue;
                double d = coneEqn = facingUp ? Math.pow(neighbour.getX() - root.getX(), 2.0) + Math.pow(neighbour.getZ() - root.getZ(), 2.0) - Math.pow((double)(yOffset - height) / ((double)height / baseRadius), 2.0) : Math.pow(neighbour.getX() - root.getX(), 2.0) + Math.pow(neighbour.getZ() - root.getZ(), 2.0) - Math.pow((double)(yOffset + height) / ((double)height / baseRadius), 2.0);
                if (coneEqn > 0.0) continue;
                queue.add(neighbour);
                seen.add(neighbour);
            }
        }
    }
}

