/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.utils;

import java.util.Objects;
import org.bukkit.Material;
import org.jetbrains.annotations.NotNull;
import org.terraform.biome.BiomeBank;

public class WoodUtils {
    @NotNull
    public static Material getWoodForBiome(@NotNull BiomeBank biome, @NotNull WoodType wood) {
        return switch (biome) {
            case BiomeBank.BADLANDS, BiomeBank.BADLANDS_RIVER, BiomeBank.SAVANNA, BiomeBank.DESERT_MOUNTAINS, BiomeBank.DESERT, BiomeBank.DESERT_RIVER, BiomeBank.BADLANDS_BEACH, BiomeBank.BADLANDS_CANYON -> wood.getWood(WoodSpecies.ACACIA);
            case BiomeBank.BIRCH_MOUNTAINS, BiomeBank.SCARLET_FOREST -> wood.getWood(WoodSpecies.BIRCH);
            case BiomeBank.COLD_OCEAN, BiomeBank.WARM_OCEAN, BiomeBank.SWAMP, BiomeBank.PLAINS, BiomeBank.OCEAN, BiomeBank.MUDFLATS, BiomeBank.CORAL_REEF_OCEAN, BiomeBank.DEEP_LUKEWARM_OCEAN, BiomeBank.DEEP_OCEAN, BiomeBank.DEEP_WARM_OCEAN, BiomeBank.DEEP_DRY_OCEAN, BiomeBank.DEEP_HUMID_OCEAN, BiomeBank.DRY_OCEAN, BiomeBank.HUMID_OCEAN, BiomeBank.RIVER, BiomeBank.ERODED_PLAINS, BiomeBank.FOREST -> wood.getWood(WoodSpecies.OAK);
            case BiomeBank.FROZEN_OCEAN, BiomeBank.TAIGA, BiomeBank.SNOWY_WASTELAND, BiomeBank.SNOWY_TAIGA, BiomeBank.SNOWY_MOUNTAINS, BiomeBank.ROCKY_MOUNTAINS, BiomeBank.ROCKY_BEACH, BiomeBank.FROZEN_RIVER, BiomeBank.DEEP_COLD_OCEAN, BiomeBank.DEEP_FROZEN_OCEAN, BiomeBank.ICY_BEACH, BiomeBank.ICE_SPIKES -> wood.getWood(WoodSpecies.SPRUCE);
            case BiomeBank.SANDY_BEACH, BiomeBank.JUNGLE, BiomeBank.JUNGLE_RIVER, BiomeBank.BAMBOO_FOREST -> wood.getWood(WoodSpecies.JUNGLE);
            case BiomeBank.BLACK_OCEAN, BiomeBank.DEEP_BLACK_OCEAN, BiomeBank.CHERRY_GROVE, BiomeBank.DARK_FOREST, BiomeBank.DARK_FOREST_RIVER, BiomeBank.DARK_FOREST_BEACH -> wood.getWood(WoodSpecies.DARK_OAK);
            default -> wood.getWood(WoodSpecies.OAK);
        };
    }

    public static enum WoodSpecies {
        OAK,
        SPRUCE,
        BIRCH,
        JUNGLE,
        ACACIA,
        DARK_OAK;

    }

    public static enum WoodType {
        PLANKS("%WOOD%_PLANKS"),
        SAPLING("%WOOD%_SAPLING"),
        POTTED_SAPLING("POTTED_%WOOD%_SAPLING"),
        LOG("%WOOD%_LOG"),
        STRIPPED_LOG("STRIPPED_%WOOD%_LOG"),
        WOOD("%WOOD%_WOOD"),
        STRIPPED_WOOD("STRIPPED_%WOOD%_WOOD"),
        LEAVES("%WOOD%_LEAVES"),
        SLAB("%WOOD%_SLAB"),
        PRESSURE_PLATE("%WOOD%_PRESSURE_PLATE"),
        FENCE("%WOOD%_FENCE"),
        TRAPDOOR("%WOOD%_TRAPDOOR"),
        FENCE_GATE("%WOOD%_FENCE_GATE"),
        STAIRS("%WOOD%_STAIRS"),
        BUTTON("%WOOD%_BUTTON"),
        DOOR("%WOOD%_DOOR"),
        SIGN("%WOOD%_SIGN"),
        WALL_SIGN("%WOOD%_WALL_SIGN"),
        BOAT("%WOOD%_BOAT");

        final String template;

        private WoodType(String template) {
            this.template = template;
        }

        @NotNull
        public static WoodType parse(@NotNull Material oak) {
            return WoodType.valueOf(oak.toString().replace("DARK_OAK", "OAK").replace("OAK_", ""));
        }

        @NotNull
        public Material getWood(@NotNull WoodSpecies species) {
            return Objects.requireNonNull(Material.getMaterial((String)this.template.replace("%WOOD%", species.toString())));
        }
    }
}

