/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.v1_21_R3;

import java.util.HashMap;
import java.util.Locale;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPosition;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BrushableBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityBeehive;
import net.minecraft.world.level.block.entity.TileEntityLootable;
import net.minecraft.world.level.block.entity.TileEntityMobSpawner;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.IChunkAccess;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_21_R3.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R3.generator.CraftLimitedRegion;
import org.bukkit.craftbukkit.v1_21_R3.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_21_R3.util.RandomSourceWrapper;
import org.bukkit.entity.EntityType;
import org.jetbrains.annotations.NotNull;
import org.terraform.coregen.TerraLootTable;
import org.terraform.coregen.bukkit.NativeGeneratorPatcherPopulator;
import org.terraform.coregen.populatordata.IPopulatorDataBaseHeightAccess;
import org.terraform.coregen.populatordata.IPopulatorDataBeehiveEditor;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.TerraformWorld;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.main.config.TConfig;
import org.terraform.utils.GenUtils;
import org.terraform.v1_21_R3.LootTableTranslator;
import org.terraform.v1_21_R3.NMSChunkGenerator;

public class PopulatorData
extends PopulatorDataAbstract
implements IPopulatorDataBaseHeightAccess,
IPopulatorDataBeehiveEditor {
    private static final HashMap<EntityType, EntityTypes<?>> entityTypesDict = new HashMap();
    final GeneratorAccessSeed rlwa;
    final IChunkAccess ica;
    private final int chunkX;
    private final int chunkZ;
    private final NMSChunkGenerator gen;
    private int radius = 1;

    public PopulatorData(GeneratorAccessSeed rlwa, IChunkAccess ica, NMSChunkGenerator gen, int chunkX, int chunkZ) {
        this.rlwa = rlwa;
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
        this.gen = gen;
        this.ica = ica;
        if (entityTypesDict.isEmpty()) {
            for (EntityType type : EntityType.values()) {
                if (type == EntityType.UNKNOWN) continue;
                try {
                    Optional et = EntityTypes.a((String)("minecraft:" + type.toString().toLowerCase(Locale.ENGLISH)));
                    et.ifPresent(entityTypes -> entityTypesDict.put(type, (EntityTypes<?>)entityTypes));
                }
                catch (IllegalArgumentException e2) {
                    TerraformGeneratorPlugin.logger.stackTrace(e2);
                }
            }
        }
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }

    @Override
    @NotNull
    public Material getType(int x, int y, int z) {
        try {
            return CraftMagicNumbers.getMaterial((Block)this.rlwa.a_(new BlockPosition(x, y, z)).b());
        }
        catch (Exception e2) {
            Bukkit.getLogger().info("Error chunk: " + this.chunkX + "," + this.chunkZ + "--- Block Coords: " + 16 * this.chunkX + "," + 16 * this.chunkZ + " for coords " + x + "," + y + "," + z);
            TerraformGeneratorPlugin.logger.stackTrace(e2);
            return null;
        }
    }

    @Override
    public BlockData getBlockData(int x, int y, int z) {
        return CraftBlockData.fromData((IBlockData)this.rlwa.a_(new BlockPosition(x, y, z)));
    }

    @Override
    public void setType(int x, int y, int z, @NotNull Material type) {
        if (Math.abs((x >> 4) - this.chunkX) > this.radius || Math.abs((z >> 4) - this.chunkZ) > this.radius) {
            if (this.radius > 0) {
                NativeGeneratorPatcherPopulator.pushChange(this.rlwa.getMinecraftWorld().getWorld().getName(), x, y, z, Bukkit.createBlockData((Material)type));
            } else {
                TerraformGeneratorPlugin.logger.stackTrace(new Exception("Tried to call adjacent chunk with populator radius 0: (" + x + "," + y + "," + z + ") for chunk (" + this.chunkX + "," + this.chunkZ + ")"));
            }
        } else {
            this.rlwa.a(new BlockPosition(x, y, z), ((CraftBlockData)Bukkit.createBlockData((Material)type)).getState(), 0);
        }
    }

    @Override
    public void setBlockData(int x, int y, int z, @NotNull BlockData data) {
        if (Math.abs((x >> 4) - this.chunkX) > this.radius || Math.abs((z >> 4) - this.chunkZ) > this.radius) {
            if (this.radius > 0) {
                NativeGeneratorPatcherPopulator.pushChange(this.rlwa.getMinecraftWorld().getWorld().getName(), x, y, z, data);
            } else {
                TerraformGeneratorPlugin.logger.stackTrace(new Exception("Tried to call adjacent chunk with populator radius 0: (" + x + "," + y + "," + z + ") for chunk (" + this.chunkX + "," + this.chunkZ + ")"));
            }
        } else {
            this.rlwa.a(new BlockPosition(x, y, z), ((CraftBlockData)data).getState(), 0);
        }
    }

    @Override
    public Biome getBiome(int rawX, int rawZ) {
        TerraformWorld tw = this.gen.getTerraformWorld();
        return tw.getBiomeBank(rawX, rawZ).getHandler().getBiome();
    }

    @Override
    public int getChunkX() {
        return this.chunkX;
    }

    @Override
    public int getChunkZ() {
        return this.chunkZ;
    }

    @Override
    public void addEntity(int rawX, int rawY, int rawZ, @NotNull EntityType type) {
        if (Math.abs((rawX >> 4) - this.chunkX) > 1 || Math.abs((rawZ >> 4) - this.chunkZ) > 1) {
            TerraformGeneratorPlugin.logger.info("Failed to spawn " + String.valueOf(type) + " as it was out of bounds.");
            return;
        }
        CraftLimitedRegion clr = new CraftLimitedRegion(this.rlwa, this.ica.f());
        Entity e2 = clr.createEntity(new Location(this.gen.getTerraformWorld().getWorld(), (double)rawX, (double)rawY, (double)rawZ), type.getEntityClass(), true);
        if (e2 instanceof EntityInsentient) {
            ((EntityInsentient)e2).fF();
        }
        this.rlwa.b(e2);
    }

    @Override
    public void setSpawner(int rawX, int rawY, int rawZ, EntityType type) {
        if (!TConfig.c.FEATURE_SPAWNERS_ENABLED) {
            return;
        }
        BlockPosition pos = new BlockPosition(rawX, rawY, rawZ);
        this.setType(rawX, rawY, rawZ, Material.SPAWNER);
        Optional opt = this.rlwa.a(pos, TileEntityTypes.j);
        if (opt.isPresent()) {
            TileEntityMobSpawner tileentity = (TileEntityMobSpawner)opt.get();
            try {
                EntityTypes<?> nmsEntity = entityTypesDict.get(type);
                if (nmsEntity == null) {
                    TerraformGeneratorPlugin.logger.error(String.valueOf(type) + " was not present in the entityTypesDict.");
                }
                tileentity.a(nmsEntity, (RandomSource)new RandomSourceWrapper(new Random()));
            }
            catch (IllegalArgumentException | SecurityException e2) {
                TerraformGeneratorPlugin.logger.stackTrace(e2);
            }
        } else {
            TerraformGeneratorPlugin.logger.error("Failed to fetch mob spawner entity at (," + rawX + "," + rawY + "," + rawZ + ")");
        }
    }

    @Override
    public void lootTableChest(int x, int y, int z, TerraLootTable table) {
        BlockPosition pos = new BlockPosition(x, y, z);
        TileEntity te = this.rlwa.c_(pos);
        if (te instanceof TileEntityLootable) {
            ((TileEntityLootable)te).a(LootTableTranslator.translationMap.get((Object)table));
        } else if (te instanceof BrushableBlockEntity) {
            ((BrushableBlockEntity)te).a(LootTableTranslator.translationMap.get((Object)table), this.gen.getTerraformWorld().getHashedRand(x, y, z).nextLong());
        }
    }

    @Override
    @NotNull
    public TerraformWorld getTerraformWorld() {
        return this.gen.getTerraformWorld();
    }

    @Override
    public int getBaseHeight(int rawX, int rawZ) {
        return 100;
    }

    @Override
    public void setBeehiveWithBee(int rawX, int rawY, int rawZ) {
        BlockPosition pos = new BlockPosition(rawX, rawY, rawZ);
        this.setType(rawX, rawY, rawZ, Material.BEE_NEST);
        try {
            TileEntityBeehive tileentity = (TileEntityBeehive)this.rlwa.c_(pos);
            if (tileentity == null) {
                this.setType(rawX, rawY, rawZ, Material.BEE_NEST);
                tileentity = (TileEntityBeehive)this.rlwa.c_(pos);
            }
            tileentity.a(TileEntityBeehive.c.a((int)GenUtils.RANDOMIZER.nextInt(599)));
        }
        catch (IllegalArgumentException | NullPointerException | SecurityException e2) {
            TerraformGeneratorPlugin.logger.stackTrace(e2);
        }
    }
}

