/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.randomizerUltimate;

import de.scholle.randomizerUltimate.RandomizerManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class RandomizerCommand
implements CommandExecutor,
TabCompleter {
    private final RandomizerManager manager;

    public RandomizerCommand(RandomizerManager manager) {
        this.manager = manager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length < 1) {
            sender.sendMessage("\u00a7cVerwendung: /randomizer <player> [stop|copy <player>|reload]");
            return true;
        }
        Player target = Bukkit.getPlayer((String)args[0]);
        if (target == null) {
            sender.sendMessage("\u00a7cSpieler nicht gefunden!");
            return true;
        }
        if (args.length == 1) {
            this.manager.startRandomizer(target);
            sender.sendMessage("\u00a7aRandomizer gestartet f\u00fcr " + target.getName());
            return true;
        }
        switch (args[1].toLowerCase()) {
            case "start": {
                this.manager.startNewRandomizer(target);
                sender.sendMessage("\u00a7aNeuer Randomizer f\u00fcr " + target.getName() + " erstellt.");
                return true;
            }
            case "stop": {
                this.manager.stopRandomizer(target);
                sender.sendMessage("\u00a7cRandomizer gestoppt f\u00fcr " + target.getName());
                return true;
            }
            case "copy": {
                if (args.length != 3) {
                    sender.sendMessage("\u00a7cVerwendung: /randomizer <player> copy <player>");
                    return true;
                }
                Player to = Bukkit.getPlayer((String)args[2]);
                if (to == null) {
                    sender.sendMessage("\u00a7cZielspieler nicht gefunden!");
                    return true;
                }
                this.manager.copyRandomizer(target, to);
                sender.sendMessage("\u00a7aRandomizer von " + target.getName() + " zu " + to.getName() + " kopiert.");
                return true;
            }
            case "reload": {
                this.manager.reloadProfile(target);
                sender.sendMessage("\u00a7aRandomizer f\u00fcr " + target.getName() + " neu geladen.");
                return true;
            }
        }
        sender.sendMessage("\u00a7cVerwendung: /randomizer <player> [start|stop|copy <player>|reload]");
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!player.getName().toLowerCase().startsWith(args[0].toLowerCase())) continue;
                completions.add(player.getName());
            }
        } else if (args.length == 2) {
            List<String> subs = List.of("stop", "copy", "reload");
            for (String s : subs) {
                if (!s.startsWith(args[1].toLowerCase())) continue;
                completions.add(s);
            }
        } else if (args.length == 3 && args[1].equalsIgnoreCase("copy")) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!player.getName().toLowerCase().startsWith(args[2].toLowerCase())) continue;
                completions.add(player.getName());
            }
        }
        Collections.sort(completions);
        return completions;
    }
}

