/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.randomizerUltimate;

import de.scholle.randomizerUltimate.RandomizerManager;
import de.scholle.randomizerUltimate.RandomizerProfile;
import org.bukkit.Material;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.ItemStack;

public class RandomizerListener
implements Listener {
    private final RandomizerManager manager;

    public RandomizerListener(RandomizerManager manager) {
        this.manager = manager;
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        RandomizerProfile profile = this.manager.getProfile(event.getPlayer().getUniqueId());
        if (profile != null) {
            Material original = event.getBlock().getType();
            ItemStack drop = profile.getDrop(original);
            event.setDropItems(false);
            event.getBlock().getWorld().dropItemNaturally(event.getBlock().getLocation(), drop);
        }
    }

    @EventHandler
    public void onEntityDeath(EntityDeathEvent event) {
        RandomizerProfile profile;
        if (event.getEntity().getKiller() != null && (profile = this.manager.getProfile(event.getEntity().getKiller().getUniqueId())) != null) {
            event.getDrops().replaceAll(item -> profile.getDrop(item.getType()));
        }
    }
}

