/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.randomizerUltimate;

import de.scholle.randomizerUltimate.RandomizerProfile;
import de.scholle.randomizerUltimate.RandomizerUltimate;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class RandomizerManager {
    private final RandomizerUltimate plugin;
    private final Map<UUID, RandomizerProfile> activeProfiles = new HashMap<UUID, RandomizerProfile>();

    public RandomizerManager(RandomizerUltimate plugin) {
        this.plugin = plugin;
    }

    public void startRandomizer(Player player) {
        UUID uuid = player.getUniqueId();
        if (!this.activeProfiles.containsKey(uuid)) {
            RandomizerProfile profile = this.loadOrCreateProfile(player.getName());
            this.activeProfiles.put(uuid, profile);
            this.plugin.getLogger().info("Randomizer gestartet f\u00fcr " + player.getName());
        }
    }

    public void startNewRandomizer(Player player) {
        UUID uuid = player.getUniqueId();
        RandomizerProfile profile = this.createNewProfile(player.getName());
        this.activeProfiles.put(uuid, profile);
        this.saveProfile(profile);
    }

    private RandomizerProfile createNewProfile(String playerName) {
        File file = new File(this.plugin.getDataFolder(), playerName + ".yml");
        YamlConfiguration cfg = YamlConfiguration.loadConfiguration((File)file);
        HashMap<String, String> drops = new HashMap<String, String>();
        Material[] allMaterials = Material.values();
        Random random = new Random();
        for (Material original : allMaterials) {
            Material randomMaterial = allMaterials[random.nextInt(allMaterials.length)];
            drops.put(original.name(), randomMaterial.name());
        }
        cfg.createSection("drops", drops);
        try {
            file.getParentFile().mkdirs();
            cfg.save(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new RandomizerProfile(playerName, file, (FileConfiguration)cfg);
    }

    public void stopRandomizer(Player player) {
        UUID uuid = player.getUniqueId();
        if (this.activeProfiles.containsKey(uuid)) {
            this.saveProfile(this.activeProfiles.get(uuid));
            this.activeProfiles.remove(uuid);
            this.plugin.getLogger().info("Randomizer gestoppt f\u00fcr " + player.getName());
        }
    }

    public void copyRandomizer(Player from, Player to) {
        RandomizerProfile original = this.activeProfiles.get(from.getUniqueId());
        if (original != null) {
            RandomizerProfile copy = original.clone(to.getName());
            this.activeProfiles.put(to.getUniqueId(), copy);
            this.saveProfile(copy);
            this.plugin.getLogger().info("Randomizer von " + from.getName() + " zu " + to.getName() + " kopiert.");
        }
    }

    public void reloadProfile(Player player) {
        UUID uuid = player.getUniqueId();
        RandomizerProfile profile = this.loadOrCreateProfile(player.getName());
        this.activeProfiles.put(uuid, profile);
    }

    public RandomizerProfile getProfile(UUID uuid) {
        return this.activeProfiles.get(uuid);
    }

    public void saveAll() {
        for (RandomizerProfile profile : this.activeProfiles.values()) {
            this.saveProfile(profile);
        }
    }

    private RandomizerProfile loadOrCreateProfile(String playerName) {
        File file = new File(this.plugin.getDataFolder(), playerName + ".yml");
        YamlConfiguration cfg = YamlConfiguration.loadConfiguration((File)file);
        boolean needsSave = false;
        if (!file.exists() || !cfg.contains("drops")) {
            HashMap<String, String> drops = new HashMap<String, String>();
            Material[] allMaterials = Material.values();
            Random random = new Random();
            for (Material original : allMaterials) {
                Material randomMaterial = allMaterials[random.nextInt(allMaterials.length)];
                drops.put(original.name(), randomMaterial.name());
            }
            cfg.createSection("drops", drops);
            needsSave = true;
        }
        if (needsSave) {
            try {
                cfg.save(file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return new RandomizerProfile(playerName, file, (FileConfiguration)cfg);
    }

    private void saveProfile(RandomizerProfile profile) {
        try {
            profile.getConfig().save(profile.getFile());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

