/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.randomizerUltimate;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.inventory.ItemStack;

public class RandomizerProfile
implements Cloneable {
    private final String playerName;
    private final File file;
    private final FileConfiguration config;
    private final Map<Material, Material> drops = new HashMap<Material, Material>();

    public RandomizerProfile(String playerName, File file, FileConfiguration config) {
        this.playerName = playerName;
        this.file = file;
        this.config = config;
        this.loadDrops();
    }

    private void loadDrops() {
        if (this.config.contains("drops")) {
            for (String key : this.config.getConfigurationSection("drops").getKeys(false)) {
                this.drops.put(Material.valueOf((String)key), Material.valueOf((String)this.config.getString("drops." + key)));
            }
        }
    }

    public ItemStack getDrop(Material original) {
        Material replacement = this.drops.getOrDefault(original, original);
        return new ItemStack(replacement);
    }

    public File getFile() {
        return this.file;
    }

    public FileConfiguration getConfig() {
        return this.config;
    }

    public RandomizerProfile clone(String newPlayerName) {
        File newFile = new File(this.file.getParentFile(), newPlayerName + ".yml");
        RandomizerProfile clone = new RandomizerProfile(newPlayerName, newFile, this.config);
        clone.drops.putAll(this.drops);
        return clone;
    }
}

