/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.iconexporter.client.gui;

import com.google.common.collect.Queues;
import java.io.File;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Map;
import java.util.Queue;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import org.apache.commons.codec.digest.DigestUtils;
import org.cyclops.cyclopscore.datastructure.Wrapper;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.init.IModBase;
import org.cyclops.iconexporter.GeneralConfig;
import org.cyclops.iconexporter.client.gui.IExportTask;
import org.cyclops.iconexporter.client.gui.ImageExportUtil;
import org.cyclops.iconexporter.client.gui.ItemRenderUtil;
import org.cyclops.iconexporter.helpers.IIconExporterHelpers;

public class ScreenIconExporter
extends Screen {
    private static final int BACKGROUND_COLOR = IModHelpers.get().getBaseHelpers().RGBAToInt(254, 255, 255, 255);
    private static final int BACKGROUND_COLOR_SHIFTED = -2;
    private final HolderLookup.Provider lookupProvider;
    private final int scaleImage;
    private final double scaleGui;
    @Nullable
    private final String modId;
    private final boolean modIdRegex;
    private final IModBase mod;
    private final IIconExporterHelpers helpers;
    private final Queue<IExportTask> exportTasks;

    public ScreenIconExporter(HolderLookup.Provider lookupProvider, int scaleImage, double scaleGui, @Nullable String modId, boolean modIdRegex, IModBase mod, IIconExporterHelpers helpers) {
        super((Component)Component.translatable((String)"gui.itemexporter.name"));
        this.lookupProvider = lookupProvider;
        this.scaleImage = scaleImage;
        this.scaleGui = scaleGui;
        this.modId = modId;
        this.modIdRegex = modIdRegex;
        this.mod = mod;
        this.helpers = helpers;
        this.exportTasks = this.createExportTasks();
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.exportTasks.isEmpty()) {
            Minecraft.getInstance().setScreen(null);
            Minecraft.getInstance().player.sendSystemMessage((Component)Component.translatable((String)"gui.itemexporter.finished"));
        } else {
            IExportTask task = this.exportTasks.poll();
            try {
                task.run(guiGraphics);
            }
            catch (IOException e) {
                Minecraft.getInstance().player.sendSystemMessage((Component)Component.translatable((String)"gui.itemexporter.error"));
                e.printStackTrace();
            }
        }
    }

    protected void renderBlurredBackground(float p_330683_) {
    }

    public String serializeNbtTag(Tag tag) {
        if (GeneralConfig.fileNameHashComponents) {
            return DigestUtils.md5Hex((String)tag.toString());
        }
        return tag.toString();
    }

    protected boolean shouldExport(ResourceLocation resourceLocation) {
        return this.modId == null || (this.modIdRegex ? resourceLocation.getNamespace().matches(this.modId) : resourceLocation.getNamespace().equals(this.modId));
    }

    public Queue<IExportTask> createExportTasks() {
        float scaleModified = (float)((double)this.scaleImage / this.scaleGui);
        int scaleModifiedRounded = (int)Math.ceil(scaleModified);
        File baseDir = new File(Minecraft.getInstance().gameDirectory, "icon-exports-x" + this.scaleImage);
        baseDir.mkdir();
        Wrapper tasks = new Wrapper((Object)0);
        Wrapper taskProcessed = new Wrapper((Object)0);
        ArrayDeque exportTasks = Queues.newArrayDeque();
        for (Map.Entry fluidEntry : BuiltInRegistries.FLUID.entrySet()) {
            if (!this.shouldExport(((ResourceKey)fluidEntry.getKey()).location())) continue;
            tasks.set((Object)((Integer)tasks.get() + 1));
            String baseFilename = ImageExportUtil.genBaseFilenameFromFluid((ResourceKey<Fluid>)((ResourceKey)fluidEntry.getKey()));
            exportTasks.add(guiGraphics -> {
                taskProcessed.set((Object)((Integer)taskProcessed.get() + 1));
                this.signalStatus((Wrapper<Integer>)tasks, (Wrapper<Integer>)taskProcessed);
                guiGraphics.fill(0, 0, scaleModifiedRounded, scaleModifiedRounded, BACKGROUND_COLOR);
                ItemRenderUtil.renderFluid(guiGraphics, (Fluid)fluidEntry.getValue(), scaleModified, this.helpers);
                ImageExportUtil.exportImageFromScreenshot(baseDir, baseFilename, this.scaleImage, -2, this.mod);
            });
        }
        CreativeModeTabs.tryRebuildTabContents((FeatureFlagSet)Minecraft.getInstance().player.connection.enabledFeatures(), (boolean)((Boolean)Minecraft.getInstance().options.operatorItemsTab().get()), (HolderLookup.Provider)Minecraft.getInstance().level.registryAccess());
        for (CreativeModeTab creativeModeTab : this.helpers.getCreativeTabs()) {
            for (ItemStack itemStack : creativeModeTab.getDisplayItems()) {
                if (!this.shouldExport(BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem()))) continue;
                tasks.set((Object)((Integer)tasks.get() + 1));
                String baseFilename = ImageExportUtil.genBaseFilenameFromItem(this.lookupProvider, itemStack, this.mod, this.helpers);
                exportTasks.add(guiGraphics -> {
                    taskProcessed.set((Object)((Integer)taskProcessed.get() + 1));
                    this.signalStatus((Wrapper<Integer>)tasks, (Wrapper<Integer>)taskProcessed);
                    guiGraphics.fill(0, 0, scaleModifiedRounded, scaleModifiedRounded, BACKGROUND_COLOR);
                    ItemRenderUtil.renderItem(guiGraphics, itemStack, scaleModified);
                    ImageExportUtil.exportImageFromScreenshot(baseDir, baseFilename, this.scaleImage, -2, this.mod);
                    if (!itemStack.getComponents().isEmpty() && GeneralConfig.fileNameHashComponents) {
                        ImageExportUtil.exportNbtFile(this.lookupProvider, baseDir, baseFilename, itemStack.getComponentsPatch(), this.mod, this.helpers);
                    }
                });
            }
        }
        return exportTasks;
    }

    protected void signalStatus(Wrapper<Integer> tasks, Wrapper<Integer> taskProcessed) {
        Minecraft.getInstance().player.displayClientMessage((Component)Component.translatable((String)"gui.itemexporter.status", (Object[])new Object[]{taskProcessed.get(), tasks.get()}), true);
    }
}

