/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.iconexporter.helpers;

import com.mojang.brigadier.arguments.ArgumentType;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.common.CreativeModeTabRegistry;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.server.command.ModIdArgument;
import org.cyclops.cyclopscore.helper.IModHelpersNeoForge;
import org.cyclops.iconexporter.helpers.IconExporterHelpersCommon;

public class IconExporterHelpersNeoForge
extends IconExporterHelpersCommon {
    @Override
    public List<CreativeModeTab> getCreativeTabs() {
        return CreativeModeTabRegistry.getSortedCreativeModeTabs();
    }

    @Override
    public String getFluidLocalName(Fluid fluid) {
        return fluid.getFluidType().getDescription().getString();
    }

    @Override
    public void renderFluidSlot(GuiGraphics gui, Fluid fluid) {
        IModHelpersNeoForge.get().getGuiHelpers().renderFluidSlot(gui, new FluidStack(fluid, 1000), 0, 0);
    }

    @Override
    public String getModName(String modId) {
        Optional mod = ModList.get().getModContainerById(modId);
        return mod.map(modContainer -> modContainer.getModInfo().getDisplayName()).orElse("Minecraft");
    }

    @Override
    public ArgumentType<String> getModIdArgumentType() {
        return ModIdArgument.modIdArgument();
    }
}

