/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.iconexporter.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.HolderLookup;
import org.cyclops.cyclopscore.init.IModBase;
import org.cyclops.iconexporter.GeneralConfig;
import org.cyclops.iconexporter.client.gui.ScreenIconExporter;
import org.cyclops.iconexporter.helpers.IIconExporterHelpers;

public class CommandExport
implements Command<CommandSourceStack> {
    private final CommandBuildContext context;
    private final boolean paramScale;
    private final ModIdFilter paramModId;
    private final IModBase mod;
    private final IIconExporterHelpers helpers;

    public CommandExport(CommandBuildContext context, boolean paramScale, ModIdFilter paramModId, IModBase mod, IIconExporterHelpers helpers) {
        this.context = context;
        this.paramScale = paramScale;
        this.paramModId = paramModId;
        this.mod = mod;
        this.helpers = helpers;
    }

    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        int scale = GeneralConfig.defaultScale;
        String modId = null;
        boolean modIdRegex = false;
        if (this.paramScale) {
            scale = (Integer)context.getArgument("scale", Integer.class);
        }
        if (this.paramModId == ModIdFilter.EXACT) {
            modId = (String)context.getArgument("mod", String.class);
        } else if (this.paramModId == ModIdFilter.REGEX) {
            modId = (String)context.getArgument("pattern", String.class);
            modIdRegex = true;
        }
        ScreenIconExporter exporter = new ScreenIconExporter((HolderLookup.Provider)this.context, scale, Minecraft.getInstance().getWindow().getGuiScale(), modId, modIdRegex, this.mod, this.helpers);
        Minecraft.getInstance().submitAsync(() -> Minecraft.getInstance().setScreen((Screen)exporter));
        return 0;
    }

    public static LiteralArgumentBuilder<CommandSourceStack> make(CommandBuildContext context, IModBase mod, IIconExporterHelpers helpers) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"export").executes((Command)new CommandExport(context, false, ModIdFilter.NONE, mod, helpers))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"scale", (ArgumentType)IntegerArgumentType.integer((int)1)).executes((Command)new CommandExport(context, true, ModIdFilter.NONE, mod, helpers))).then(Commands.literal((String)"mod").then(Commands.argument((String)"mod", helpers.getModIdArgumentType()).executes((Command)new CommandExport(context, true, ModIdFilter.EXACT, mod, helpers))))).then(Commands.literal((String)"modRegex").then(Commands.argument((String)"pattern", (ArgumentType)StringArgumentType.greedyString()).executes((Command)new CommandExport(context, true, ModIdFilter.REGEX, mod, helpers)))));
    }

    public static enum ModIdFilter {
        NONE,
        EXACT,
        REGEX;

    }
}

