/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.iconexporter.command;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3611;
import net.minecraft.class_5321;
import net.minecraft.class_7157;
import net.minecraft.class_7225;
import net.minecraft.class_7699;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import org.cyclops.cyclopscore.init.IModBase;
import org.cyclops.iconexporter.client.gui.ImageExportUtil;
import org.cyclops.iconexporter.helpers.IIconExporterHelpers;

public class CommandExportMetadata
implements Command<class_2168> {
    private final class_7157 context;
    private final IModBase mod;
    private final IIconExporterHelpers helpers;

    public CommandExportMetadata(class_7157 context, IModBase mod, IIconExporterHelpers helpers) {
        this.context = context;
        this.mod = mod;
        this.helpers = helpers;
    }

    private JsonObject itemToJson(class_7225.class_7874 lookupProvider, class_1799 itemStack) {
        JsonObject obj = new JsonObject();
        obj.addProperty("image_file", ImageExportUtil.genBaseFilenameFromItem(lookupProvider, itemStack, this.mod, this.helpers) + ".png");
        obj.addProperty("local_name", itemStack.method_7964().getString());
        class_2960 id = class_7923.field_41178.method_10221((Object)itemStack.method_7909());
        obj.addProperty("mod_name", this.helpers.getModName(id.method_12836()));
        obj.addProperty("id", class_7923.field_41178.method_10221((Object)itemStack.method_7909()).toString());
        String componentsString = "{}";
        try {
            componentsString = this.helpers.componentsToString(lookupProvider, itemStack.method_57380());
        }
        catch (IllegalStateException e) {
            this.mod.log(e.getMessage());
        }
        if (!"{}".equals(componentsString)) {
            obj.add("components", JsonParser.parseString((String)componentsString));
        }
        obj.addProperty("type", "item");
        return obj;
    }

    private JsonObject fluidToJson(Map.Entry<class_5321<class_3611>, class_3611> fluidEntry) {
        JsonObject obj = new JsonObject();
        obj.addProperty("image_file", ImageExportUtil.genBaseFilenameFromFluid(fluidEntry.getKey()) + ".png");
        obj.addProperty("local_name", this.helpers.getFluidLocalName(fluidEntry.getValue()));
        obj.addProperty("mod_name", this.helpers.getModName(fluidEntry.getKey().method_29177().method_12836()));
        obj.addProperty("id", fluidEntry.getKey().method_29177().toString());
        obj.addProperty("type", "fluid");
        return obj;
    }

    public int run(CommandContext<class_2168> context) throws CommandSyntaxException {
        Gson gson = new Gson();
        JsonArray jsonMeta = new JsonArray();
        class_7706.method_47330((class_7699)class_310.method_1551().field_1724.field_3944.method_45735(), (boolean)((Boolean)class_310.method_1551().field_1690.method_47395().method_41753()), (class_7225.class_7874)class_310.method_1551().field_1687.method_30349());
        for (class_1761 creativeModeTab : this.helpers.getCreativeTabs()) {
            for (class_1799 itemStack : creativeModeTab.method_47313()) {
                try {
                    jsonMeta.add((JsonElement)this.itemToJson((class_7225.class_7874)this.context, itemStack));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    class_310.method_1551().field_1724.method_43496((class_2561)class_2561.method_43471((String)"gui.itemexporter.error"));
                }
            }
        }
        for (Map.Entry fluidEntry : class_7923.field_41173.method_29722()) {
            try {
                jsonMeta.add((JsonElement)this.fluidToJson(fluidEntry));
            }
            catch (Exception e) {
                e.printStackTrace();
                class_310.method_1551().field_1724.method_43496((class_2561)class_2561.method_43471((String)"gui.itemexporter.error"));
            }
        }
        JsonObject json = new JsonObject();
        json.add("meta", (JsonElement)jsonMeta);
        String jsonString = gson.toJson((JsonElement)json);
        File f = new File(class_310.method_1551().field_1697, "icon-exports-metadata.json");
        try {
            FileWriter writer = new FileWriter(f);
            writer.write(jsonString);
            writer.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        class_310.method_1551().field_1724.method_43496((class_2561)class_2561.method_43469((String)"gui.itemexporter.metadata_export.success", (Object[])new Object[]{f.getAbsolutePath()}));
        return 0;
    }

    public static LiteralArgumentBuilder<class_2168> make(class_7157 context, IModBase mod, IIconExporterHelpers helpers) {
        return (LiteralArgumentBuilder)class_2170.method_9247((String)"exportmetadata").executes((Command)new CommandExportMetadata(context, mod, helpers));
    }
}

