/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.iconexporter.client.gui;

import com.google.common.collect.Queues;
import java.io.File;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Map;
import java.util.Queue;
import javax.annotation.Nullable;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3611;
import net.minecraft.class_437;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_758;
import net.minecraft.class_7699;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import org.apache.commons.codec.digest.DigestUtils;
import org.cyclops.cyclopscore.datastructure.Wrapper;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.init.IModBase;
import org.cyclops.iconexporter.GeneralConfig;
import org.cyclops.iconexporter.client.gui.IExportTask;
import org.cyclops.iconexporter.client.gui.ImageExportUtil;
import org.cyclops.iconexporter.client.gui.ItemRenderUtil;
import org.cyclops.iconexporter.helpers.IIconExporterHelpers;

public class ScreenIconExporter
extends class_437 {
    private static final int BACKGROUND_COLOR = IModHelpers.get().getBaseHelpers().RGBAToInt(254, 255, 255, 255);
    private final class_7225.class_7874 lookupProvider;
    private final int scaleImage;
    private final double scaleGui;
    @Nullable
    private final String modId;
    private final boolean modIdRegex;
    private final IModBase mod;
    private final IIconExporterHelpers helpers;
    private final Queue<IExportTask> exportTasks;

    public ScreenIconExporter(class_7225.class_7874 lookupProvider, int scaleImage, double scaleGui, @Nullable String modId, boolean modIdRegex, IModBase mod, IIconExporterHelpers helpers) {
        super((class_2561)class_2561.method_43471((String)"gui.itemexporter.name"));
        this.lookupProvider = lookupProvider;
        this.scaleImage = scaleImage;
        this.scaleGui = scaleGui;
        this.modId = modId;
        this.modIdRegex = modIdRegex;
        this.mod = mod;
        this.helpers = helpers;
        this.exportTasks = this.createExportTasks();
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.exportTasks.isEmpty()) {
            class_310.method_1551().method_1507(null);
            class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43471((String)"gui.itemexporter.finished"), false);
        } else {
            IExportTask task = this.exportTasks.poll();
            try {
                task.run(guiGraphics);
            }
            catch (IOException e) {
                class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43471((String)"gui.itemexporter.error"), false);
                e.printStackTrace();
            }
        }
    }

    protected void method_57734(class_332 guiGraphics) {
    }

    public String serializeNbtTag(class_2520 tag) {
        if (GeneralConfig.fileNameHashComponents) {
            return DigestUtils.md5Hex((String)tag.toString());
        }
        return tag.toString();
    }

    protected boolean shouldExport(class_2960 resourceLocation) {
        return this.modId == null || (this.modIdRegex ? resourceLocation.method_12836().matches(this.modId) : resourceLocation.method_12836().equals(this.modId));
    }

    public Queue<IExportTask> createExportTasks() {
        float scaleModified = (float)((double)this.scaleImage / this.scaleGui);
        int scaleModifiedRounded = (int)Math.ceil(scaleModified);
        File baseDir = new File(class_310.method_1551().field_1697, "icon-exports-x" + this.scaleImage);
        baseDir.mkdir();
        Wrapper tasks = new Wrapper((Object)0);
        Wrapper taskProcessed = new Wrapper((Object)0);
        ArrayDeque exportTasks = Queues.newArrayDeque();
        for (Map.Entry fluidEntry : class_7923.field_41173.method_29722()) {
            if (!this.shouldExport(((class_5321)fluidEntry.getKey()).method_29177())) continue;
            tasks.set((Object)((Integer)tasks.get() + 1));
            String baseFilename = ImageExportUtil.genBaseFilenameFromFluid((class_5321<class_3611>)((class_5321)fluidEntry.getKey()));
            exportTasks.add(guiGraphics -> {
                taskProcessed.set((Object)((Integer)taskProcessed.get() + 1));
                this.signalStatus((Wrapper<Integer>)tasks, (Wrapper<Integer>)taskProcessed);
                guiGraphics.method_25294(0, 0, scaleModifiedRounded, scaleModifiedRounded, BACKGROUND_COLOR);
                ItemRenderUtil.renderFluid(guiGraphics, (class_3611)fluidEntry.getValue(), scaleModified, this.helpers);
                this.flushRenderBuffer();
                ImageExportUtil.exportImageFromScreenshot(baseDir, baseFilename, this.scaleImage, BACKGROUND_COLOR, this.mod);
            });
        }
        class_7706.method_47330((class_7699)class_310.method_1551().field_1724.field_3944.method_45735(), (boolean)((Boolean)class_310.method_1551().field_1690.method_47395().method_41753()), (class_7225.class_7874)class_310.method_1551().field_1687.method_30349());
        for (class_1761 creativeModeTab : this.helpers.getCreativeTabs()) {
            for (class_1799 itemStack : creativeModeTab.method_47313()) {
                if (!this.shouldExport(class_7923.field_41178.method_10221((Object)itemStack.method_7909()))) continue;
                tasks.set((Object)((Integer)tasks.get() + 1));
                String baseFilename = ImageExportUtil.genBaseFilenameFromItem(this.lookupProvider, itemStack, this.mod, this.helpers);
                exportTasks.add(guiGraphics -> {
                    taskProcessed.set((Object)((Integer)taskProcessed.get() + 1));
                    this.signalStatus((Wrapper<Integer>)tasks, (Wrapper<Integer>)taskProcessed);
                    guiGraphics.method_25294(0, 0, scaleModifiedRounded, scaleModifiedRounded, BACKGROUND_COLOR);
                    ItemRenderUtil.renderItem(guiGraphics, itemStack, scaleModified);
                    this.flushRenderBuffer();
                    ImageExportUtil.exportImageFromScreenshot(baseDir, baseFilename, this.scaleImage, BACKGROUND_COLOR, this.mod);
                    if (!itemStack.method_57353().method_57837() && GeneralConfig.fileNameHashComponents) {
                        ImageExportUtil.exportNbtFile(this.lookupProvider, baseDir, baseFilename, itemStack.method_57380(), this.mod, this.helpers);
                    }
                });
            }
        }
        return exportTasks;
    }

    private void flushRenderBuffer() {
        class_310.method_1551().field_1773.field_59965.method_70890(class_310.method_1551().field_1773.field_60793.method_71109(class_758.class_4596.field_60101));
    }

    protected void signalStatus(Wrapper<Integer> tasks, Wrapper<Integer> taskProcessed) {
        class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43469((String)"gui.itemexporter.status", (Object[])new Object[]{taskProcessed.get(), tasks.get()}), true);
    }
}

