/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.iconexporter.client.gui;

import com.google.common.base.Charsets;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import net.minecraft.class_1011;
import net.minecraft.class_1799;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_318;
import net.minecraft.class_3611;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_9326;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.init.IModBase;
import org.cyclops.iconexporter.GeneralConfig;
import org.cyclops.iconexporter.helpers.IIconExporterHelpers;
import org.lwjgl.system.MemoryUtil;

public class ImageExportUtil {
    public static String escapeKey(String key) {
        return key.replaceAll(":", "__").replaceAll("\"", "'").replaceAll("/", "___");
    }

    public static String genBaseFilenameFromFluid(class_5321<class_3611> fluid) {
        return ImageExportUtil.escapeKey("fluid__" + String.valueOf(fluid.method_29177()));
    }

    public static String genBaseFilenameFromItem(class_7225.class_7874 lookupProvider, class_1799 itemStack, IModBase mod, IIconExporterHelpers helpers) {
        StringBuilder sb = new StringBuilder();
        sb.append(class_7923.field_41178.method_10221((Object)itemStack.method_7909()));
        String componentsString = "{}";
        try {
            componentsString = helpers.componentsToString(lookupProvider, itemStack.method_57380());
        }
        catch (IllegalStateException e) {
            mod.log(e.getMessage());
        }
        if (!"{}".equals(componentsString)) {
            sb.append("__");
            if (GeneralConfig.fileNameHashComponents) {
                sb.append(DigestUtils.md5Hex((String)componentsString));
            } else {
                sb.append(componentsString);
            }
        }
        return ImageExportUtil.escapeKey(sb.toString());
    }

    public static void exportImageFromScreenshot(File dir, String baseFilename, int scaleImage, int backgroundColor, IModBase mod) {
        class_318.method_1663((class_276)class_310.method_1551().method_1522(), imageFull -> {
            class_1011 image = ImageExportUtil.getSubImage(imageFull, scaleImage, scaleImage);
            imageFull.close();
            int alpha = 0;
            alpha = (byte)(alpha % 255);
            for (int cx = 0; cx < image.method_4307(); ++cx) {
                for (int cy = 0; cy < image.method_4323(); ++cy) {
                    int color = image.method_61940(cx, cy);
                    if (color != backgroundColor) continue;
                    color = 0;
                    int mc = alpha << 24 | 0xFFFFFF;
                    int newcolor = color & mc;
                    image.method_61941(cx, cy, newcolor);
                }
            }
            try {
                File file = new File(dir, baseFilename + ".png").getCanonicalFile();
                try {
                    image.method_4325(file);
                }
                catch (NullPointerException e) {
                    e.printStackTrace();
                    throw new IOException("Error while writing the PNG image " + String.valueOf(file));
                }
            }
            catch (IOException e) {
                mod.log(Level.ERROR, "Error while writing the PNG image for name " + baseFilename);
            }
            finally {
                image.close();
            }
        });
    }

    public static void exportNbtFile(class_7225.class_7874 lookupProvider, File dir, String baseFilename, class_9326 components, IModBase mod, IIconExporterHelpers helpers) throws IOException {
        try {
            File file = new File(dir, baseFilename + ".txt").getCanonicalFile();
            try {
                FileUtils.writeStringToFile((File)file, (String)helpers.componentsToString(lookupProvider, components), (Charset)Charsets.UTF_8);
            }
            catch (NullPointerException e) {
                e.printStackTrace();
                throw new IOException("Error while writing the TXT image " + String.valueOf(file));
            }
        }
        catch (IOException e) {
            mod.log(Level.ERROR, "Error while writing the TXT image for name " + baseFilename);
            throw e;
        }
    }

    public static class_1011 getSubImage(class_1011 image, int width, int height) {
        class_1011 imageNew = new class_1011(width, height, false);
        for (int y = 0; y < imageNew.method_4323(); ++y) {
            int pointerOffset = y * image.method_4307() * image.method_4318().method_4335();
            int pointerOffsetNew = y * imageNew.method_4307() * imageNew.method_4318().method_4335();
            MemoryUtil.memCopy((long)(image.field_4988 + (long)pointerOffset), (long)(imageNew.field_4988 + (long)pointerOffsetNew), (long)((long)imageNew.method_4307() * (long)image.method_4318().method_4335()));
        }
        return imageNew;
    }
}

