/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.rusticengineer.entity;

import io.netty.buffer.Unpooled;
import net.mcreator.rusticengineer.procedures.TickSubmarineAbyssalProcedure;
import net.mcreator.rusticengineer.world.inventory.AbyssalSubmarineGuiMenu;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;
import net.neoforged.neoforge.items.wrapper.EntityArmorInvWrapper;
import net.neoforged.neoforge.items.wrapper.EntityHandsInvWrapper;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SubmarineAbyssalEntity
extends PathfinderMob
implements GeoEntity {
    public static final EntityDataAccessor<Boolean> SHOOT = SynchedEntityData.defineId(SubmarineAbyssalEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<String> ANIMATION = SynchedEntityData.defineId(SubmarineAbyssalEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<String> TEXTURE = SynchedEntityData.defineId(SubmarineAbyssalEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<Integer> DATA_fuel = SynchedEntityData.defineId(SubmarineAbyssalEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_water = SynchedEntityData.defineId(SubmarineAbyssalEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean swinging;
    private boolean lastloop;
    private long lastSwing;
    public String animationprocedure = "empty";
    private final ItemStackHandler inventory = new ItemStackHandler(this, 12){

        public int getSlotLimit(int slot) {
            return 64;
        }
    };
    private final CombinedInvWrapper combined = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inventory, new EntityHandsInvWrapper((LivingEntity)this), new EntityArmorInvWrapper((LivingEntity)this)});
    String prevAnim = "empty";

    public SubmarineAbyssalEntity(EntityType<SubmarineAbyssalEntity> type, Level world) {
        super(type, world);
        this.xpReward = 0;
        this.setNoAi(false);
        this.setPersistenceRequired();
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.moveControl = new MoveControl((Mob)this){

            public void tick() {
                if (SubmarineAbyssalEntity.this.isInWater()) {
                    SubmarineAbyssalEntity.this.setDeltaMovement(SubmarineAbyssalEntity.this.getDeltaMovement().add(0.0, 0.005, 0.0));
                }
                if (this.operation == MoveControl.Operation.MOVE_TO && !SubmarineAbyssalEntity.this.getNavigation().isDone()) {
                    double dx = this.wantedX - SubmarineAbyssalEntity.this.getX();
                    double dy = this.wantedY - SubmarineAbyssalEntity.this.getY();
                    double dz = this.wantedZ - SubmarineAbyssalEntity.this.getZ();
                    float f = (float)(Mth.atan2((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
                    float f1 = (float)(this.speedModifier * SubmarineAbyssalEntity.this.getAttribute(Attributes.MOVEMENT_SPEED).getValue());
                    SubmarineAbyssalEntity.this.setYRot(this.rotlerp(SubmarineAbyssalEntity.this.getYRot(), f, 10.0f));
                    SubmarineAbyssalEntity.this.yBodyRot = SubmarineAbyssalEntity.this.getYRot();
                    SubmarineAbyssalEntity.this.yHeadRot = SubmarineAbyssalEntity.this.getYRot();
                    if (SubmarineAbyssalEntity.this.isInWater()) {
                        SubmarineAbyssalEntity.this.setSpeed((float)SubmarineAbyssalEntity.this.getAttribute(Attributes.MOVEMENT_SPEED).getValue());
                        float f2 = -((float)(Mth.atan2((double)dy, (double)((float)Math.sqrt(dx * dx + dz * dz))) * 57.29577951308232));
                        f2 = Mth.clamp((float)Mth.wrapDegrees((float)f2), (float)-85.0f, (float)85.0f);
                        SubmarineAbyssalEntity.this.setXRot(this.rotlerp(SubmarineAbyssalEntity.this.getXRot(), f2, 5.0f));
                        float f3 = Mth.cos((float)(SubmarineAbyssalEntity.this.getXRot() * ((float)Math.PI / 180)));
                        SubmarineAbyssalEntity.this.setZza(f3 * f1);
                        SubmarineAbyssalEntity.this.setYya((float)((double)f1 * dy));
                    } else {
                        SubmarineAbyssalEntity.this.setSpeed(f1 * 0.05f);
                    }
                } else {
                    SubmarineAbyssalEntity.this.setSpeed(0.0f);
                    SubmarineAbyssalEntity.this.setYya(0.0f);
                    SubmarineAbyssalEntity.this.setZza(0.0f);
                }
            }
        };
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SHOOT, (Object)false);
        builder.define(ANIMATION, (Object)"undefined");
        builder.define(TEXTURE, (Object)"submarine-texture");
        builder.define(DATA_fuel, (Object)0);
        builder.define(DATA_water, (Object)0);
    }

    public void setTexture(String texture) {
        this.entityData.set(TEXTURE, (Object)texture);
    }

    public String getTexture() {
        return (String)this.entityData.get(TEXTURE);
    }

    protected PathNavigation createNavigation(Level world) {
        return new WaterBoundPathNavigation((Mob)this, world);
    }

    protected void registerGoals() {
        super.registerGoals();
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    protected Vec3 getPassengerAttachmentPoint(Entity entity, EntityDimensions dimensions, float f) {
        return super.getPassengerAttachmentPoint(entity, dimensions, f).add(0.0, (double)-1.1f, 0.0);
    }

    public boolean hurt(DamageSource source, float amount) {
        if (source.getDirectEntity() instanceof AbstractArrow) {
            return false;
        }
        if (source.getDirectEntity() instanceof Player) {
            return false;
        }
        if (source.getDirectEntity() instanceof ThrownPotion || source.getDirectEntity() instanceof AreaEffectCloud || source.typeHolder().is(NeoForgeMod.POISON_DAMAGE)) {
            return false;
        }
        if (source.is(DamageTypes.FALL)) {
            return false;
        }
        if (source.is(DamageTypes.CACTUS)) {
            return false;
        }
        if (source.is(DamageTypes.DROWN)) {
            return false;
        }
        if (source.is(DamageTypes.LIGHTNING_BOLT)) {
            return false;
        }
        if (source.is(DamageTypes.TRIDENT)) {
            return false;
        }
        if (source.is(DamageTypes.FALLING_ANVIL)) {
            return false;
        }
        if (source.is(DamageTypes.DRAGON_BREATH)) {
            return false;
        }
        if (source.is(DamageTypes.WITHER) || source.is(DamageTypes.WITHER_SKULL)) {
            return false;
        }
        return super.hurt(source, amount);
    }

    public CombinedInvWrapper getInventory() {
        return this.combined;
    }

    protected void dropEquipment() {
        super.dropEquipment();
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack itemstack = this.inventory.getStackInSlot(i);
            if (itemstack.isEmpty() || EnchantmentHelper.has((ItemStack)itemstack, (DataComponentType)EnchantmentEffectComponents.PREVENT_EQUIPMENT_DROP)) continue;
            this.spawnAtLocation(itemstack);
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.put("InventoryCustom", (Tag)this.inventory.serializeNBT((HolderLookup.Provider)this.registryAccess()));
        compound.putString("Texture", this.getTexture());
        compound.putInt("Datafuel", ((Integer)this.entityData.get(DATA_fuel)).intValue());
        compound.putInt("Datawater", ((Integer)this.entityData.get(DATA_water)).intValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        Tag inventoryCustom = compound.get("InventoryCustom");
        if (inventoryCustom instanceof CompoundTag) {
            CompoundTag inventoryTag = (CompoundTag)inventoryCustom;
            this.inventory.deserializeNBT((HolderLookup.Provider)this.registryAccess(), inventoryTag);
        }
        if (compound.contains("Texture")) {
            this.setTexture(compound.getString("Texture"));
        }
        if (compound.contains("Datafuel")) {
            this.entityData.set(DATA_fuel, (Object)compound.getInt("Datafuel"));
        }
        if (compound.contains("Datawater")) {
            this.entityData.set(DATA_water, (Object)compound.getInt("Datawater"));
        }
    }

    public InteractionResult mobInteract(final Player sourceentity, InteractionHand hand) {
        ItemStack itemstack = sourceentity.getItemInHand(hand);
        InteractionResult retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        if (sourceentity.isSecondaryUseActive()) {
            if (sourceentity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)sourceentity;
                serverPlayer.openMenu(new MenuProvider(){

                    public Component getDisplayName() {
                        return Component.literal((String)"Submarine");
                    }

                    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
                        FriendlyByteBuf packetBuffer = new FriendlyByteBuf(Unpooled.buffer());
                        packetBuffer.writeBlockPos(sourceentity.blockPosition());
                        packetBuffer.writeByte(0);
                        packetBuffer.writeVarInt(SubmarineAbyssalEntity.this.getId());
                        return new AbyssalSubmarineGuiMenu(id, inventory, packetBuffer);
                    }
                }, buf -> {
                    buf.writeBlockPos(sourceentity.blockPosition());
                    buf.writeByte(0);
                    buf.writeVarInt(this.getId());
                });
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        }
        super.mobInteract(sourceentity, hand);
        sourceentity.startRiding((Entity)this);
        return retval;
    }

    public void baseTick() {
        super.baseTick();
        TickSubmarineAbyssalProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
        this.refreshDimensions();
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        return super.getDefaultDimensions(pose).scale(1.0f);
    }

    public boolean canDrownInFluidType(FluidType type) {
        return false;
    }

    public boolean checkSpawnObstruction(LevelReader world) {
        return world.isUnobstructed((Entity)this);
    }

    public boolean isPushedByFluid() {
        return false;
    }

    public void travel(Vec3 dir) {
        Entity entity;
        Entity entity2 = entity = this.getPassengers().isEmpty() ? null : (Entity)this.getPassengers().get(0);
        if (this.isVehicle()) {
            double d0;
            double d1;
            float f1;
            this.setYRot(entity.getYRot());
            this.yRotO = this.getYRot();
            this.setXRot(entity.getXRot() * 0.5f);
            this.setRot(this.getYRot(), this.getXRot());
            this.yBodyRot = entity.getYRot();
            this.yHeadRot = entity.getYRot();
            if (entity instanceof LivingEntity) {
                LivingEntity passenger = (LivingEntity)entity;
                this.setSpeed((float)this.getAttributeValue(Attributes.MOVEMENT_SPEED));
                float forward = passenger.zza;
                float strafe = passenger.xxa;
                super.travel(new Vec3((double)strafe, 0.0, (double)forward));
            }
            if ((f1 = (float)Math.sqrt((d1 = this.getX() - this.xo) * d1 + (d0 = this.getZ() - this.zo) * d0) * 4.0f) > 1.0f) {
                f1 = 1.0f;
            }
            this.walkAnimation.setSpeed(this.walkAnimation.speed() + (f1 - this.walkAnimation.speed()) * 0.4f);
            this.walkAnimation.position(this.walkAnimation.position() + this.walkAnimation.speed());
            this.calculateEntityAnimation(true);
            return;
        }
        super.travel(dir);
    }

    public void aiStep() {
        super.aiStep();
        this.updateSwingTime();
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.01);
        builder = builder.add(Attributes.MAX_HEALTH, 20.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 0.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        builder = builder.add(NeoForgeMod.SWIM_SPEED, 0.01);
        return builder;
    }

    private PlayState movementPredicate(AnimationState event) {
        if (this.animationprocedure.equals("empty")) {
            return event.setAndContinue(RawAnimation.begin().thenLoop("idle"));
        }
        return PlayState.STOP;
    }

    private PlayState procedurePredicate(AnimationState event) {
        if (!this.animationprocedure.equals("empty") && event.getController().getAnimationState() == AnimationController.State.STOPPED || !this.animationprocedure.equals(this.prevAnim) && !this.animationprocedure.equals("empty")) {
            if (!this.animationprocedure.equals(this.prevAnim)) {
                event.getController().forceAnimationReset();
            }
            event.getController().setAnimation(RawAnimation.begin().thenPlay(this.animationprocedure));
            if (event.getController().getAnimationState() == AnimationController.State.STOPPED) {
                this.animationprocedure = "empty";
                event.getController().forceAnimationReset();
            }
        } else if (this.animationprocedure.equals("empty")) {
            this.prevAnim = "empty";
            return PlayState.STOP;
        }
        this.prevAnim = this.animationprocedure;
        return PlayState.CONTINUE;
    }

    protected void tickDeath() {
        ++this.deathTime;
        if (this.deathTime == 20) {
            this.remove(Entity.RemovalReason.KILLED);
            this.dropExperience((Entity)this);
        }
    }

    public String getSyncedAnimation() {
        return (String)this.entityData.get(ANIMATION);
    }

    public void setAnimation(String animation) {
        this.entityData.set(ANIMATION, (Object)animation);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController((GeoAnimatable)this, "movement", 4, this::movementPredicate));
        data.add(new AnimationController((GeoAnimatable)this, "procedure", 4, this::procedurePredicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

