/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.rusticengineer.init;

import net.mcreator.rusticengineer.entity.AirshipEntity;
import net.mcreator.rusticengineer.entity.DragonFlyEntity;
import net.mcreator.rusticengineer.entity.ProjectileSpiderMechEntity;
import net.mcreator.rusticengineer.entity.SpiderMechEntity;
import net.mcreator.rusticengineer.entity.SubmarineAbyssalEntity;
import net.mcreator.rusticengineer.entity.WoodenCubeChestEntity;
import net.mcreator.rusticengineer.entity.WoodenCubeEntity;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class RusticEngineerModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"rustic_engineer");
    public static final DeferredHolder<EntityType<?>, EntityType<SpiderMechEntity>> SPIDER_MECH = RusticEngineerModEntities.register("spider_mech", EntityType.Builder.of(SpiderMechEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(2.0f, 2.0f));
    public static final DeferredHolder<EntityType<?>, EntityType<WoodenCubeEntity>> WOODEN_CUBE = RusticEngineerModEntities.register("wooden_cube", EntityType.Builder.of(WoodenCubeEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().sized(0.6f, 0.5f));
    public static final DeferredHolder<EntityType<?>, EntityType<ProjectileSpiderMechEntity>> PROJECTILE_SPIDER_MECH = RusticEngineerModEntities.register("projectile_spider_mech", EntityType.Builder.of(ProjectileSpiderMechEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).sized(0.5f, 0.5f));
    public static final DeferredHolder<EntityType<?>, EntityType<WoodenCubeChestEntity>> WOODEN_CUBE_CHEST = RusticEngineerModEntities.register("wooden_cube_chest", EntityType.Builder.of(WoodenCubeChestEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().sized(0.6f, 1.0f));
    public static final DeferredHolder<EntityType<?>, EntityType<AirshipEntity>> AIRSHIP = RusticEngineerModEntities.register("airship", EntityType.Builder.of(AirshipEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(2.0f, 3.0f));
    public static final DeferredHolder<EntityType<?>, EntityType<DragonFlyEntity>> DRAGON_FLY = RusticEngineerModEntities.register("dragon_fly", EntityType.Builder.of(DragonFlyEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(2.0f, 1.5f));
    public static final DeferredHolder<EntityType<?>, EntityType<SubmarineAbyssalEntity>> SUBMARINE_ABYSSAL = RusticEngineerModEntities.register("submarine_abyssal", EntityType.Builder.of(SubmarineAbyssalEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(2.0f, 2.0f));

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.build(registryname));
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerEntity(Capabilities.ItemHandler.ENTITY, (EntityType)SPIDER_MECH.get(), (living, context) -> living.getInventory());
        event.registerEntity(Capabilities.ItemHandler.ENTITY, (EntityType)WOODEN_CUBE_CHEST.get(), (living, context) -> living.getInventory());
        event.registerEntity(Capabilities.ItemHandler.ENTITY, (EntityType)AIRSHIP.get(), (living, context) -> living.getInventory());
        event.registerEntity(Capabilities.ItemHandler.ENTITY, (EntityType)DRAGON_FLY.get(), (living, context) -> living.getInventory());
        event.registerEntity(Capabilities.ItemHandler.ENTITY, (EntityType)SUBMARINE_ABYSSAL.get(), (living, context) -> living.getInventory());
    }

    @SubscribeEvent
    public static void init(RegisterSpawnPlacementsEvent event) {
        SpiderMechEntity.init(event);
        WoodenCubeEntity.init(event);
        WoodenCubeChestEntity.init(event);
        AirshipEntity.init(event);
        DragonFlyEntity.init(event);
        SubmarineAbyssalEntity.init(event);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)SPIDER_MECH.get(), SpiderMechEntity.createAttributes().build());
        event.put((EntityType)WOODEN_CUBE.get(), WoodenCubeEntity.createAttributes().build());
        event.put((EntityType)WOODEN_CUBE_CHEST.get(), WoodenCubeChestEntity.createAttributes().build());
        event.put((EntityType)AIRSHIP.get(), AirshipEntity.createAttributes().build());
        event.put((EntityType)DRAGON_FLY.get(), DragonFlyEntity.createAttributes().build());
        event.put((EntityType)SUBMARINE_ABYSSAL.get(), SubmarineAbyssalEntity.createAttributes().build());
    }
}

