/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.rusticengineer.block;

import java.util.List;
import net.mcreator.rusticengineer.procedures.GoldenBotSleepOnBlockRightClickedProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class WoodenCubeSleepBlock
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;

    public WoodenCubeSleepBlock() {
        super(BlockBehaviour.Properties.of().ignitedByLava().instrument(NoteBlockInstrument.BASS).sound(SoundType.WOOD).strength(1.0f, 10.0f).noOcclusion().isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(itemstack, context, list, flag);
        list.add((Component)Component.translatable((String)"block.rustic_engineer.wooden_cube_sleep.description_0"));
        list.add((Component)Component.translatable((String)"block.rustic_engineer.wooden_cube_sleep.description_1"));
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            default -> Shapes.or((VoxelShape)WoodenCubeSleepBlock.box((double)4.0, (double)0.0, (double)5.0, (double)12.0, (double)8.0, (double)11.0), (VoxelShape[])new VoxelShape[]{WoodenCubeSleepBlock.box((double)8.7, (double)4.0, (double)10.001, (double)9.7, (double)6.0, (double)11.001), WoodenCubeSleepBlock.box((double)6.3, (double)4.0, (double)10.001, (double)7.3, (double)6.0, (double)11.001), WoodenCubeSleepBlock.box((double)11.7, (double)-0.1, (double)7.0, (double)13.7, (double)4.9, (double)9.0), WoodenCubeSleepBlock.box((double)2.3, (double)-0.1, (double)7.0, (double)4.3, (double)4.9, (double)9.0), WoodenCubeSleepBlock.box((double)8.5, (double)0.0, (double)9.0, (double)11.5, (double)2.0, (double)13.0), WoodenCubeSleepBlock.box((double)8.5, (double)0.0, (double)6.0, (double)11.5, (double)2.0, (double)10.0), WoodenCubeSleepBlock.box((double)4.5, (double)0.0, (double)9.0, (double)7.5, (double)2.0, (double)13.0), WoodenCubeSleepBlock.box((double)4.5, (double)0.0, (double)6.0, (double)7.5, (double)2.0, (double)10.0)});
            case Direction.NORTH -> Shapes.or((VoxelShape)WoodenCubeSleepBlock.box((double)4.0, (double)0.0, (double)5.0, (double)12.0, (double)8.0, (double)11.0), (VoxelShape[])new VoxelShape[]{WoodenCubeSleepBlock.box((double)6.3, (double)4.0, (double)4.999, (double)7.3, (double)6.0, (double)5.999), WoodenCubeSleepBlock.box((double)8.7, (double)4.0, (double)4.999, (double)9.7, (double)6.0, (double)5.999), WoodenCubeSleepBlock.box((double)2.3, (double)-0.1, (double)7.0, (double)4.3, (double)4.9, (double)9.0), WoodenCubeSleepBlock.box((double)11.7, (double)-0.1, (double)7.0, (double)13.7, (double)4.9, (double)9.0), WoodenCubeSleepBlock.box((double)4.5, (double)0.0, (double)3.0, (double)7.5, (double)2.0, (double)7.0), WoodenCubeSleepBlock.box((double)4.5, (double)0.0, (double)6.0, (double)7.5, (double)2.0, (double)10.0), WoodenCubeSleepBlock.box((double)8.5, (double)0.0, (double)3.0, (double)11.5, (double)2.0, (double)7.0), WoodenCubeSleepBlock.box((double)8.5, (double)0.0, (double)6.0, (double)11.5, (double)2.0, (double)10.0)});
            case Direction.EAST -> Shapes.or((VoxelShape)WoodenCubeSleepBlock.box((double)5.0, (double)0.0, (double)4.0, (double)11.0, (double)8.0, (double)12.0), (VoxelShape[])new VoxelShape[]{WoodenCubeSleepBlock.box((double)10.001, (double)4.0, (double)6.3, (double)11.001, (double)6.0, (double)7.3), WoodenCubeSleepBlock.box((double)10.001, (double)4.0, (double)8.7, (double)11.001, (double)6.0, (double)9.7), WoodenCubeSleepBlock.box((double)7.0, (double)-0.1, (double)2.3, (double)9.0, (double)4.9, (double)4.3), WoodenCubeSleepBlock.box((double)7.0, (double)-0.1, (double)11.7, (double)9.0, (double)4.9, (double)13.7), WoodenCubeSleepBlock.box((double)9.0, (double)0.0, (double)4.5, (double)13.0, (double)2.0, (double)7.5), WoodenCubeSleepBlock.box((double)6.0, (double)0.0, (double)4.5, (double)10.0, (double)2.0, (double)7.5), WoodenCubeSleepBlock.box((double)9.0, (double)0.0, (double)8.5, (double)13.0, (double)2.0, (double)11.5), WoodenCubeSleepBlock.box((double)6.0, (double)0.0, (double)8.5, (double)10.0, (double)2.0, (double)11.5)});
            case Direction.WEST -> Shapes.or((VoxelShape)WoodenCubeSleepBlock.box((double)5.0, (double)0.0, (double)4.0, (double)11.0, (double)8.0, (double)12.0), (VoxelShape[])new VoxelShape[]{WoodenCubeSleepBlock.box((double)4.999, (double)4.0, (double)8.7, (double)5.999, (double)6.0, (double)9.7), WoodenCubeSleepBlock.box((double)4.999, (double)4.0, (double)6.3, (double)5.999, (double)6.0, (double)7.3), WoodenCubeSleepBlock.box((double)7.0, (double)-0.1, (double)11.7, (double)9.0, (double)4.9, (double)13.7), WoodenCubeSleepBlock.box((double)7.0, (double)-0.1, (double)2.3, (double)9.0, (double)4.9, (double)4.3), WoodenCubeSleepBlock.box((double)3.0, (double)0.0, (double)8.5, (double)7.0, (double)2.0, (double)11.5), WoodenCubeSleepBlock.box((double)6.0, (double)0.0, (double)8.5, (double)10.0, (double)2.0, (double)11.5), WoodenCubeSleepBlock.box((double)3.0, (double)0.0, (double)4.5, (double)7.0, (double)2.0, (double)7.5), WoodenCubeSleepBlock.box((double)6.0, (double)0.0, (double)4.5, (double)10.0, (double)2.0, (double)7.5)});
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public InteractionResult useWithoutItem(BlockState blockstate, Level world, BlockPos pos, Player entity, BlockHitResult hit) {
        super.useWithoutItem(blockstate, world, pos, entity, hit);
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        double hitX = hit.getLocation().x;
        double hitY = hit.getLocation().y;
        double hitZ = hit.getLocation().z;
        Direction direction = hit.getDirection();
        GoldenBotSleepOnBlockRightClickedProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        return InteractionResult.SUCCESS;
    }
}

