/*
 * Decompiled with CFR 0.152.
 */
package ru.netherdon.netheragriculture.blocks;

import com.mojang.serialization.MapCodec;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_4970;
import net.minecraft.class_5819;

public class BurningCrateBlock
extends class_2248 {
    public static final MapCodec<BurningCrateBlock> CODEC = BurningCrateBlock.method_54094(BurningCrateBlock::new);
    private static final float FLAME_OFFSET = 3.5f;
    private static final float FLAME_SPREAD = 9.0f;
    private static final float FLAME_Y_OFFSET = 1.1f;
    private static final float FLAME_Y_OFFSET_BOTTOM = 0.6f;

    public BurningCrateBlock(class_4970.class_2251 properties) {
        super(properties);
    }

    public void method_9591(class_1937 level, class_2338 pos, class_2680 state, class_1297 entity) {
        BurningCrateBlock.damageWhileWalking(level, entity);
        super.method_9591(level, pos, state, entity);
    }

    public void method_9496(class_2680 blockState, class_1937 level, class_2338 blockPos, class_5819 randomSource) {
        super.method_9496(blockState, level, blockPos, randomSource);
        BurningCrateBlock.spawnFlameParticle(level, blockPos, randomSource, false);
    }

    protected MapCodec<? extends BurningCrateBlock> method_53969() {
        return CODEC;
    }

    public static void damageWhileWalking(class_1937 level, class_1297 entity) {
        if (entity instanceof class_1309) {
            entity.method_5643(level.method_48963().method_48820(), 1.0f);
        }
    }

    public static void spawnFlameParticle(class_1937 level, class_2338 pos, class_5819 random, boolean bottom) {
        if (random.method_43048(2) != 0) {
            return;
        }
        float yOffset = 1.1f;
        if (bottom) {
            yOffset = 0.6f;
        } else if (!BurningCrateBlock.canBurnAt(level, pos)) {
            return;
        }
        float x = (float)pos.method_10263() + (3.5f + 9.0f * random.method_43057()) / 16.0f;
        float y = (float)pos.method_10264() + yOffset;
        float z = (float)pos.method_10260() + (3.5f + 9.0f * random.method_43057()) / 16.0f;
        level.method_8406((class_2394)class_2398.field_11240, (double)x, (double)y, (double)z, 0.0, 0.0, 0.0);
        level.method_8406((class_2394)class_2398.field_11251, (double)x, (double)y, (double)z, 0.0, 0.0, 0.0);
    }

    private static boolean canBurnAt(class_1937 level, class_2338 pos) {
        class_2680 stateAbove = level.method_8320(pos.method_10084());
        return !stateAbove.method_26206((class_1922)level, pos, class_2350.field_11033) && stateAbove.method_26227().method_15769();
    }
}

