/*
 * Decompiled with CFR 0.152.
 */
package ru.netherdon.netheragriculture.blocks;

import com.mojang.serialization.MapCodec;
import java.util.Objects;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import org.jetbrains.annotations.Nullable;
import ru.netherdon.netheragriculture.blocks.INetherCrop;
import ru.netherdon.netheragriculture.blocks.NetherFarmlandBlock;
import ru.netherdon.netheragriculture.services.CropService;

public class NetherCropBlock
extends class_2302
implements INetherCrop {
    public static final MapCodec<NetherCropBlock> CODEC = class_2248.method_54094(NetherCropBlock::new);
    @Nullable
    private final class_6862<class_2248> fertileSoilsTag;

    public NetherCropBlock(@Nullable class_6862<class_2248> fertileSoilsTag, class_4970.class_2251 properties) {
        super(properties);
        this.fertileSoilsTag = fertileSoilsTag;
    }

    public NetherCropBlock(class_4970.class_2251 properties) {
        this(null, properties);
    }

    protected void method_9514(class_2680 state, class_3218 level, class_2338 pos, class_5819 random) {
        float growthSpeed;
        if (this.canGrow(state, level, pos) && CropService.canGrow(level, pos, state, random.method_43048((int)(20.0f / (growthSpeed = NetherCropBlock.getNetherGrowthSpeed(state, (class_1922)level, pos))) + 1) == 0)) {
            this.grow(state, level, pos, random);
            CropService.onGrowPost(level, pos, state);
        }
    }

    protected boolean canGrow(class_2680 state, class_3218 level, class_2338 pos) {
        return !this.method_9825(state);
    }

    protected void grow(class_2680 state, class_3218 level, class_2338 pos, class_5819 random) {
        int age = this.method_9829(state);
        level.method_8652(pos, this.withAge(state, age + 1), 2);
    }

    protected class_2680 withAge(class_2680 state, int age) {
        return (class_2680)state.method_11657((class_2769)this.method_9824(), (Comparable)Integer.valueOf(age));
    }

    @Override
    public boolean isFertileSoil(class_2680 state) {
        return this.fertileSoilsTag != null && state.method_26164(this.getFertileSoilsTag());
    }

    @Nullable
    protected class_6862<class_2248> getFertileSoilsTag() {
        return this.fertileSoilsTag;
    }

    protected boolean method_9695(class_2680 state, class_1922 level, class_2338 pos) {
        return state.method_26204() instanceof NetherFarmlandBlock;
    }

    protected boolean method_9558(class_2680 state, class_4538 level, class_2338 pos) {
        class_2338 blockpos = pos.method_10074();
        class_2680 belowBlockState = level.method_8320(blockpos);
        Boolean soilDecision = CropService.canSustainPlant(belowBlockState, (class_1922)level, blockpos, class_2350.field_11036, state);
        return Objects.requireNonNullElseGet(soilDecision, () -> this.method_9695(belowBlockState, (class_1922)level, blockpos));
    }

    protected class_1935 method_9832() {
        class_1792 item = this.method_8389();
        if (item != class_1802.field_8162) {
            return item;
        }
        return super.method_9832();
    }

    public MapCodec<? extends NetherCropBlock> method_53969() {
        return CODEC;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{this.method_9824()});
    }

    protected static float getNetherGrowthSpeed(class_2680 blockState, class_1922 level, class_2338 pos) {
        boolean flag1;
        class_2248 block = blockState.method_26204();
        float speed = 1.0f;
        class_2338 posBelow = pos.method_10074();
        class_2680 stateBelow = level.method_8320(posBelow);
        Boolean soilDecision = CropService.canSustainPlant(stateBelow, level, posBelow, class_2350.field_11036, blockState);
        if (soilDecision == null || soilDecision.booleanValue()) {
            INetherCrop netherCropBlock;
            class_2248 class_22482 = blockState.method_26204();
            speed = class_22482 instanceof INetherCrop && (netherCropBlock = (INetherCrop)class_22482).isFertileSoil(stateBelow) ? (speed += 3.0f) : (speed += 1.0f);
        }
        class_2338 posNorth = pos.method_10095();
        class_2338 posSouth = pos.method_10072();
        class_2338 posWest = pos.method_10067();
        class_2338 posEast = pos.method_10078();
        boolean flag = level.method_8320(posWest).method_27852(block) || level.method_8320(posEast).method_27852(block);
        boolean bl = flag1 = level.method_8320(posNorth).method_27852(block) || level.method_8320(posSouth).method_27852(block);
        if (flag && flag1) {
            speed /= 2.0f;
        } else {
            boolean flag2;
            boolean bl2 = flag2 = level.method_8320(posWest.method_10095()).method_27852(block) || level.method_8320(posEast.method_10095()).method_27852(block) || level.method_8320(posEast.method_10072()).method_27852(block) || level.method_8320(posWest.method_10072()).method_27852(block);
            if (flag2) {
                speed /= 2.0f;
            }
        }
        return speed;
    }
}

