/*
 * Decompiled with CFR 0.152.
 */
package ru.netherdon.netheragriculture.client.particles;

import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_3999;
import net.minecraft.class_4002;
import net.minecraft.class_4184;
import net.minecraft.class_4588;
import net.minecraft.class_5819;
import net.minecraft.class_5878;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.minecraft.class_723;
import ru.netherdon.netheragriculture.client.particles.ISourcedParticle;
import ru.netherdon.netheragriculture.client.particles.NAParticleGroups;
import ru.netherdon.netheragriculture.client.particles.options.GlowingSporeAirParticleOptions;

@Environment(value=EnvType.CLIENT)
public class GlowingSporeParticle
extends class_723
implements ISourcedParticle {
    private static final float SPEED = 0.03f;
    private static final int FADE_TIME = 10;
    private final List<class_703.class_9213> faders;
    private final class_2338 sourcePos;
    private final class_2248 sourceBlock;

    public GlowingSporeParticle(class_638 level, class_2338 sourcePos, class_2248 sourceBlock, class_4002 spriteSet, List<class_703.class_9213> faders, double x, double y, double z, double dx, double dy, double dz) {
        super(level, spriteSet, x, y, z, dx, dy, dz);
        this.sourcePos = sourcePos;
        this.sourceBlock = sourceBlock;
        this.faders = faders;
        this.method_3084(1.0f, 1.0f, 1.0f);
        this.method_3083(0.0f);
    }

    public Optional<class_5878> method_34019() {
        return Optional.of(NAParticleGroups.GLOWING_SPORES);
    }

    @Override
    public class_2338 getSourcePos() {
        return this.sourcePos;
    }

    @Override
    public void sourceChanged(class_2680 newState) {
        int newAge;
        if (!newState.method_27852(this.sourceBlock) && this.field_3866 < (newAge = this.field_3847 - Math.min(this.field_3866, 10))) {
            this.field_3866 = newAge;
        }
    }

    public void method_3074(class_4588 vertexConsumer, class_4184 camera, float partialTick) {
        this.method_3083(this.faders.stream().map(fader -> Float.valueOf(fader.method_56834(this.field_3866, this.field_3847, partialTick))).filter(alpha -> alpha.floatValue() != 1.0f).findFirst().orElse(Float.valueOf(1.0f)).floatValue());
        super.method_3074(vertexConsumer, camera, partialTick);
    }

    protected int method_3068(float partialTick) {
        int oldLight = super.method_3068(partialTick);
        int j = oldLight & 0xFF;
        int k = oldLight >> 16 & 0xFF;
        if ((j += (int)(this.field_3841 * 15.0f * 16.0f)) > 240) {
            j = 240;
        }
        return j | k << 16;
    }

    public class_3999 method_18122() {
        return class_3999.field_17829;
    }

    @Environment(value=EnvType.CLIENT)
    public static class GlowingSporeAirProvider
    implements class_707<GlowingSporeAirParticleOptions> {
        private final class_4002 sprites;

        public GlowingSporeAirProvider(class_4002 sprites) {
            this.sprites = sprites;
        }

        public class_703 createParticle(GlowingSporeAirParticleOptions options, class_638 level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            int lifetime = class_3532.method_32751((class_5819)level.field_9229, (int)60, (int)100);
            class_703.class_9213 faderIn = new class_703.class_9213(0.0f, 1.0f, 0.0f, 10.0f / (float)lifetime);
            class_703.class_9213 faderOut = new class_703.class_9213(1.0f, 0.0f, (float)(lifetime - 10) / (float)lifetime, 1.0f);
            GlowingSporeParticle particle = new GlowingSporeParticle(level, options.pos(), options.block(), this.sprites, List.of(faderIn, faderOut), x, y, z, xSpeed, ySpeed, zSpeed);
            particle.method_3077(lifetime);
            particle.field_3852 *= 0.03f;
            particle.field_3869 *= 0.03f;
            particle.field_3850 *= 0.03f;
            return particle;
        }
    }
}

